package org.phosphoresce.dbbrowser.resource.definition.dbdriver;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.dbbrowser.exception.DatabaseBrowserResourceException;
import org.phosphoresce.dbbrowser.util.DatabaseBrowserUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**
 * DatabaseBrowserTvJDBC`NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/26	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserJDBCSample implements Serializable {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** JDBC`TvXML */
	public static final String JDBC_SAMPLE_XML = "/org/phosphoresce/dbbrowser/resource/definition/dbdriver/DatabaseBrowserJDBCSample.xml";

	/** ZtCX^X */
	private static DatabaseBrowserJDBCSample instance = null;

	/** `Xg */
	private List list = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserJDBCSample() {
		super();
		this.list = new LinkedList();
	}

	/**
	 * VOgZtNXCX^X擾܂B<br>
	 * @return ZtNXCX^X
	 * @throws DatabaseBrowserResourceException Ƀ\[X̏ǂݍ݂ɍsȂꍇɃX[܂
	 */
	public static DatabaseBrowserJDBCSample instance() throws DatabaseBrowserResourceException {
		if (instance == null) {
			instance = new DatabaseBrowserJDBCSample();
			instance.initialize();
		}
		return instance;
	}

	/**
	 * \[Xǂݍ݃Tv`NXCX^X܂B<br>
	 * @throws DatabaseBrowserResourceException Ƀ\[X̃p[XsȂꍇɔ
	 */
	private void initialize() throws DatabaseBrowserResourceException {
		try {
			DatabaseBrowserJDBCSampleContentHandler handler = new DatabaseBrowserJDBCSampleContentHandler();

			XMLReader reader = DatabaseBrowserUtil.createXMLReader();
			reader.setContentHandler(handler);
			reader.parse(new InputSource(this.getClass().getResourceAsStream(JDBC_SAMPLE_XML)));

			list = handler.getDefinitionList();

			log.info("JDBC sample definition resource loaded.");
		} catch (Throwable e) {
			throw new DatabaseBrowserResourceException("failed to load JDBC sample definition.", e);
		}
	}

	/**
	 * Tv`Ce[^IuWFNg擾܂B<br>
	 * @return Tv`Ce[^IuWFNg
	 */
	public Iterator getSampleDefinitionIterator() {
		return list.iterator();
	}

	/**
	 * w肳ꂽCfbNX̃Tv`擾܂B<br>
	 * @param index CfbNX
	 * @return Tv`
	 */
	public DatabaseBrowserJDBCSampleDefinition getSampleDefinition(int index) {
		return (DatabaseBrowserJDBCSampleDefinition) list.get(index);
	}
}
