package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserEBhEݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserWindowConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "windowConfig";

	/** TCY */
	private DatabaseBrowserWindowBoundsConfig boundsConfig;

	/** R|[lg */
	private DatabaseBrowserWindowComponentConfig componentConfig;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserWindowConfig() {
		super();
		initialize();
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		boundsConfig = new DatabaseBrowserWindowBoundsConfig();
		componentConfig = new DatabaseBrowserWindowComponentConfig();
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		getBoundsConfig().save(document, node);
		getComponentConfig().save(document, node);
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if (DatabaseBrowserWindowBoundsConfig.NODE_NAME.equals(node.getNodeName())) {
				boundsConfig = new DatabaseBrowserWindowBoundsConfig(node);
			}
			if (DatabaseBrowserWindowComponentConfig.NODE_NAME.equals(node.getNodeName())) {
				componentConfig = new DatabaseBrowserWindowComponentConfig(node);
			}
		}
	}

	/**
	 * TCY擾܂B<br>
	 * @return TCY
	 */
	public DatabaseBrowserWindowBoundsConfig getBoundsConfig() {
		return boundsConfig;
	}

	/**
	 * TCYݒ肵܂B<br>
	 * @param boundsConfig TCY
	 */
	public void setBoundsConfig(DatabaseBrowserWindowBoundsConfig boundsConfig) {
		this.boundsConfig = boundsConfig;
	}

	/**
	 * R|[lg擾܂B<br>
	 * @return R|[lg
	 */
	public DatabaseBrowserWindowComponentConfig getComponentConfig() {
		return componentConfig;
	}

	/**
	 * R|[lgݒ肵܂B<br>
	 * @param componentConfig R|[lg
	 */
	public void setComponentConfig(DatabaseBrowserWindowComponentConfig componentConfig) {
		this.componentConfig = componentConfig;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserWindowConfig{");
		buffer.append("boundsConfig=");
		buffer.append(getBoundsConfig());
		buffer.append(",");
		buffer.append("componentConfig=");
		buffer.append(getComponentConfig());
		buffer.append("}");
		return buffer.toString();
	}
}
