package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;

import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserf[^x[XRlNVݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserConnectionConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "databaseConfig";

	/** f[^x[Xڑ` */
	private String name;

	/** f[^x[Xڑݒ */
	private DatabaseConfig databaseConfig;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserConnectionConfig() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserConnectionConfig(Node root) {
		super();
		initialize();
		load(root);
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserConnectionConfig(DatabaseConfig databaseConfig) {
		super();
		initialize();
		this.databaseConfig = databaseConfig;
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		name = "";
		databaseConfig = new DatabaseConfig();
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		Node name = node.appendChild(document.createElement("name"));
		Node driver = node.appendChild(document.createElement("driver"));
		Node url = node.appendChild(document.createElement("url"));
		Node user = node.appendChild(document.createElement("user"));
		Node password = node.appendChild(document.createElement("password"));

		name.appendChild(document.createTextNode(getName()));
		driver.appendChild(document.createTextNode(getDatabaseConfig().getJdbcDriver()));
		url.appendChild(document.createTextNode(getDatabaseConfig().getJdbcUrl()));
		user.appendChild(document.createTextNode(getDatabaseConfig().getJdbcUser()));
		password.appendChild(document.createTextNode(getDatabaseConfig().getJdbcPassword()));
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if ("name".equals(node.getNodeName())) {
				name = XMLUtil.getTextContent(node);
			} else if ("driver".equals(node.getNodeName())) {
				getDatabaseConfig().setJdbcDriver(XMLUtil.getTextContent(node));
			} else if ("url".equals(node.getNodeName())) {
				getDatabaseConfig().setJdbcUrl(XMLUtil.getTextContent(node));
			} else if ("user".equals(node.getNodeName())) {
				getDatabaseConfig().setJdbcUser(XMLUtil.getTextContent(node));
			} else if ("password".equals(node.getNodeName())) {
				getDatabaseConfig().setJdbcPassword(XMLUtil.getTextContent(node));
			}
		}
	}

	/**
	 * f[^x[Xڑ`擾܂B<br>
	 * @return f[^x[Xڑ`
	 */
	public String getName() {
		if (name == null) {
			name = "";
		}
		return name;
	}

	/**
	 * f[^x[Xڑ`ݒ肵܂B<br>
	 * @param name f[^x[Xڑ`
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * f[^x[Xڑݒ擾܂B<br>
	 * @return f[^x[Xڑݒ
	 */
	public DatabaseConfig getDatabaseConfig() {
		if (databaseConfig == null) {
			databaseConfig = new DatabaseConfig();
		}
		return databaseConfig;
	}

	/**
	 * f[^x[Xڑݒݒ肵܂B<br>
	 * @param databaseConfig f[^x[Xڑݒ
	 */
	public void setDatabaseConfig(DatabaseConfig databaseConfig) {
		this.databaseConfig = databaseConfig;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserConnectionConfig{");
		buffer.append("name=");
		buffer.append(getName());
		buffer.append(",");
		buffer.append("databaseConfig=");
		buffer.append(getDatabaseConfig());
		buffer.append("}");
		return buffer.toString();
	}
}
