package org.phosphoresce.dbbrowser.config;

import java.io.FileOutputStream;
import java.io.Serializable;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.exception.BrowserConfigException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserݒNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/24	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "configuration";

	/** K[IuWFNg */
	private static transient Log log = LogFactory.getLog(DatabaseBrowserConfig.class);

	/** VOgZtCX^X */
	private static transient DatabaseBrowserConfig instance = null;

	/** `ςݐڑݒIuWFNg */
	private DatabaseBrowserDefinitionedConnectionConfig definitionedConnectionConfig = null;

	/** ŋߗpڑݒIuWFNg */
	private DatabaseBrowserRecentConnectionConfig recentConnectionConfig = null;

	/** EBhEݒIuWFNg */
	private DatabaseBrowserWindowConfig windowConfig = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserConfig() {
		super();
	}

	/**
	 * ZtCX^X擾܂B<br>
	 * @return DatabaseBrowserConfigNXtCX^X
	 */
	public static DatabaseBrowserConfig instance() {
		if (instance == null) {
			instance = new DatabaseBrowserConfig();
		}
		return instance;
	}

	/**
	 * ݒIuWFNgt@Cɕۑ܂B<br>
	 * @throws BrowserConfigException ɕۑȂꍇɔ
	 */
	public void save() throws BrowserConfigException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.newDocument();
			Node root = document.appendChild(document.createElement(NODE_NAME));

			getRecentConnectionConfig().save(document, root);
			getDefinitionedConnectionConfig().save(document, root);
			getWindowConfig().save(document, root);

			FileOutputStream stream = new FileOutputStream(DatabaseBrowserConstants.CONFIG_FILE);
			StreamSource xslt = new StreamSource(getClass().getResourceAsStream(DatabaseBrowserConstants.CONFIG_FILE_XSLT));
			Transformer transformer = TransformerFactory.newInstance().newTransformer(xslt);
			transformer.transform(new DOMSource(document), new StreamResult(stream));
			stream.close();
		} catch (Throwable throwable) {
			log.warn("failed to save configuration.", throwable);
		}
	}

	/**
	 * ݒIuWFNgt@Cǂݍ݂܂B<br>
	 * AAt@C݂Ȃꍇ͏񂪃NA܂B<br>
	 * ܂Aǂݍ݂ɏIȂꍇ͗O̓X[ꂸAɏ܂B<br>
	 * @throws BrowserConfigException ɓǂݍݏȂꍇɔ
	 */
	public void load() throws BrowserConfigException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(DatabaseBrowserConstants.CONFIG_FILE);
			Element root = document.getDocumentElement();
			NodeList nodeList = root.getChildNodes();
			for (int i = 0; i <= nodeList.getLength() - 1; i++) {
				Node node = nodeList.item(i);
				if (DatabaseBrowserWindowConfig.NODE_NAME.equals(node.getNodeName())) {
					getWindowConfig().load(node);
				} else if (DatabaseBrowserRecentConnectionConfig.NODE_NAME.equals(node.getNodeName())) {
					getRecentConnectionConfig().load(node);
				} else if (DatabaseBrowserDefinitionedConnectionConfig.NODE_NAME.equals(node.getNodeName())) {
					getDefinitionedConnectionConfig().load(node);
				}
			}
			log.trace("loaded DatabaseBrowser configuration file.");
			log.trace(toString());
		} catch (Throwable throwable) {
			//log.warn("failed to load configuration.", throwable);
		}
	}

	/**
	 * `ςݐڑݒIuWFNg擾܂B<br>
	 * @return `ςݐڑݒIuWFNg
	 */
	public DatabaseBrowserDefinitionedConnectionConfig getDefinitionedConnectionConfig() {
		if (definitionedConnectionConfig == null) {
			definitionedConnectionConfig = new DatabaseBrowserDefinitionedConnectionConfig();
		}
		return definitionedConnectionConfig;
	}

	/**
	 * `ςݐڑݒIuWFNgݒ肵܂B<br>
	 * @param definitionedConnectionConfig `ςݐڑݒIuWFNg
	 */
	public void setDefinitionedConnectionConfig(DatabaseBrowserDefinitionedConnectionConfig definitionedConnectionConfig) {
		this.definitionedConnectionConfig = definitionedConnectionConfig;
	}

	/**
	 * ŋߗpڑݒIuWFNg擾܂B<br>
	 * @return ŋߗpڑݒIuWFNg
	 */
	public DatabaseBrowserRecentConnectionConfig getRecentConnectionConfig() {
		if (recentConnectionConfig == null) {
			recentConnectionConfig = new DatabaseBrowserRecentConnectionConfig();
		}
		return recentConnectionConfig;
	}

	/**
	 * ŋߗpڑݒIuWFNgݒ肵܂B<br>
	 * @param recentConnectionConfig ŋߗpڑݒIuWFNg
	 */
	public void setRecentConnectionConfig(DatabaseBrowserRecentConnectionConfig recentConnectionConfig) {
		this.recentConnectionConfig = recentConnectionConfig;
	}

	/**
	 * EBhEݒIuWFNg擾܂B<br>
	 * @return EBhEݒIuWFNg
	 */
	public DatabaseBrowserWindowConfig getWindowConfig() {
		if (windowConfig == null) {
			windowConfig = new DatabaseBrowserWindowConfig();
		}
		return windowConfig;
	}

	/**
	 * EBhEݒIuWFNgݒ肵܂B<br>
	 * @param windowConfig EBhEݒIuWFNg
	 */
	public void setWindowConfig(DatabaseBrowserWindowConfig windowConfig) {
		this.windowConfig = windowConfig;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserConfig{");
		buffer.append("definitionedConnectionConfig=");
		buffer.append(getDefinitionedConnectionConfig());
		buffer.append(",");
		buffer.append("recentConnectionConfig=");
		buffer.append(getRecentConnectionConfig());
		buffer.append(",");
		buffer.append("windowConfig=");
		buffer.append(getWindowConfig());
		buffer.append("}");
		return buffer.toString();
	}
}
