/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.accessor.ResultAccessor;
import org.phosphoresce.commons.database.accessor.ResultAccessorListener;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public abstract class ResultAccessorAbstract
implements ResultAccessor {
    protected Log log = LogFactory.getLog(this.getClass());
    protected ResultSet resultSet = null;
    protected ResultAccessorState state = null;
    protected ResultAccessorListener listener = null;
    protected DatabaseError error = null;

    protected ResultAccessorAbstract(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener) throws ResultSetAccessException {
        if (resultSet == null) {
            throw new ResultSetAccessException("null 'resultSet' argument.");
        }
        if (state == null) {
            throw new ResultSetAccessException("null 'state' argument.");
        }
        this.resultSet = resultSet;
        this.listener = listener;
        this.state = state;
        this.error = null;
    }

    private ResultAccessorAbstract() throws ResultSetAccessException {
        this(null, null, null);
    }

    public final ResultAccessorState getState() {
        return this.state;
    }

    public final boolean hasError() {
        return this.error != null;
    }

    public final DatabaseError getError() {
        return this.error;
    }

    protected final void refreshResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.refreshResult(false);
    }

    protected abstract void refreshResult(boolean var1) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

    protected abstract void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

    protected final void moveCurser(int rowIndex) throws ResultSetAccessException {
        try {
            if (rowIndex == 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(rowIndex);
            }
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to move cursor.", e);
        }
    }

    protected final int getResultSetRowIndex() throws ResultSetAccessException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get ResultSet row index.", e);
        }
    }

    protected final boolean validateStateListener() {
        return this.listener != null;
    }
}

