/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.resource.definition.dbdriver;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.dbbrowser.exception.DatabaseBrowserResourceException;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSampleContentHandler;
import org.phosphoresce.dbbrowser.resource.definition.dbdriver.DatabaseBrowserJDBCSampleDefinition;
import org.phosphoresce.dbbrowser.util.DatabaseBrowserUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class DatabaseBrowserJDBCSample
implements Serializable {
    private Log log = LogFactory.getLog(this.getClass());
    public static final String JDBC_SAMPLE_XML = "/org/phosphoresce/dbbrowser/resource/definition/dbdriver/DatabaseBrowserJDBCSample.xml";
    private static DatabaseBrowserJDBCSample instance = null;
    private List list = new LinkedList();

    private DatabaseBrowserJDBCSample() {
    }

    public static DatabaseBrowserJDBCSample instance() throws DatabaseBrowserResourceException {
        if (instance == null) {
            instance = new DatabaseBrowserJDBCSample();
            instance.initialize();
        }
        return instance;
    }

    private void initialize() throws DatabaseBrowserResourceException {
        try {
            DatabaseBrowserJDBCSampleContentHandler handler = new DatabaseBrowserJDBCSampleContentHandler();
            XMLReader reader = DatabaseBrowserUtil.createXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(this.getClass().getResourceAsStream(JDBC_SAMPLE_XML)));
            this.list = handler.getDefinitionList();
            this.log.info((Object)"JDBC sample definition resource loaded.");
        }
        catch (Throwable e) {
            throw new DatabaseBrowserResourceException("failed to load JDBC sample definition.", e);
        }
    }

    public Iterator getSampleDefinitionIterator() {
        return this.list.iterator();
    }

    public DatabaseBrowserJDBCSampleDefinition getSampleDefinition(int index) {
        return (DatabaseBrowserJDBCSampleDefinition)this.list.get(index);
    }
}

