/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserWindowComponentQueryManageConfig
implements Serializable {
    public static final String NODE_NAME = "queryManage";
    private int tableTreePaneDivideLocation;
    private int queryAreaDivideLocation;
    private int resultAreaDivideLocation;

    DatabaseBrowserWindowComponentQueryManageConfig() {
        this.initialize();
    }

    DatabaseBrowserWindowComponentQueryManageConfig(Node root) {
        this.initialize();
        this.load(root);
    }

    private void initialize() {
        this.tableTreePaneDivideLocation = 160;
        this.queryAreaDivideLocation = 80;
        this.resultAreaDivideLocation = -1;
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Node tableTreePaneDivideLocation = node.appendChild(document.createElement("tableTreePaneDivideLocation"));
        tableTreePaneDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getTableTreePaneDivideLocation())));
        Node queryAreaDivideLocation = node.appendChild(document.createElement("queryAreaDivideLocation"));
        queryAreaDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getQueryAreaDivideLocation())));
        Node resultAreaDivideLocation = node.appendChild(document.createElement("resultAreaDivideLocation"));
        resultAreaDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getResultAreaDivideLocation())));
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if ("tableTreePaneDivideLocation".equals(node.getNodeName())) {
                this.tableTreePaneDivideLocation = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
            }
            if ("queryAreaDivideLocation".equals(node.getNodeName())) {
                this.queryAreaDivideLocation = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
            }
            if (!"resultAreaDivideLocation".equals(node.getNodeName())) continue;
            this.resultAreaDivideLocation = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
        }
    }

    public int getTableTreePaneDivideLocation() {
        return this.tableTreePaneDivideLocation;
    }

    public void setTableTreePaneDivideLocation(int tableTreePaneDivideLocation) {
        this.tableTreePaneDivideLocation = tableTreePaneDivideLocation;
    }

    public int getQueryAreaDivideLocation() {
        return this.queryAreaDivideLocation;
    }

    public void setQueryAreaDivideLocation(int queryAreaDivideLocation) {
        this.queryAreaDivideLocation = queryAreaDivideLocation;
    }

    public int getResultAreaDivideLocation() {
        return this.resultAreaDivideLocation;
    }

    public void setResultAreaDivideLocation(int resultAreaDivideLocation) {
        this.resultAreaDivideLocation = resultAreaDivideLocation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DatabaseBrowserWindowComponentConfig{");
        buffer.append("tableTreePaneDivideLocation=");
        buffer.append(this.getTableTreePaneDivideLocation());
        buffer.append(",");
        buffer.append("queryAreaDivideLocation=");
        buffer.append(this.getQueryAreaDivideLocation());
        buffer.append(",");
        buffer.append("resultAreaDivideLocation=");
        buffer.append(this.getResultAreaDivideLocation());
        buffer.append("}");
        return buffer.toString();
    }
}

