/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.config;

import java.awt.Rectangle;
import java.io.Serializable;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DatabaseBrowserWindowBoundsConfig
implements Serializable {
    public static final String NODE_NAME = "windowBounds";
    private Rectangle bounds;
    private int extendsState;

    DatabaseBrowserWindowBoundsConfig() {
        this.initialize();
    }

    DatabaseBrowserWindowBoundsConfig(Node root) {
        this.initialize();
        this.load(root);
    }

    private void initialize() {
        this.bounds = new Rectangle(0, 0, 800, 600);
        this.extendsState = 0;
    }

    void save(Document document, Node root) {
        Node node = root.appendChild(document.createElement(NODE_NAME));
        Node x = node.appendChild(document.createElement("x"));
        Node y = node.appendChild(document.createElement("y"));
        Node width = node.appendChild(document.createElement("width"));
        Node height = node.appendChild(document.createElement("height"));
        Node extendsState = node.appendChild(document.createElement("extendsState"));
        x.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getBounds().x)));
        y.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getBounds().y)));
        width.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getBounds().width)));
        height.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getBounds().height)));
        extendsState.appendChild(document.createTextNode(StringUtil.valueOf((int)this.getExtendsState())));
    }

    void load(Node root) {
        NodeList nodeList = root.getChildNodes();
        this.initialize();
        for (int i = 0; i <= nodeList.getLength() - 1; ++i) {
            Node node = nodeList.item(i);
            if ("x".equals(node.getNodeName())) {
                this.getBounds().x = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
                continue;
            }
            if ("y".equals(node.getNodeName())) {
                this.getBounds().y = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
                continue;
            }
            if ("width".equals(node.getNodeName())) {
                this.getBounds().width = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
                continue;
            }
            if ("height".equals(node.getNodeName())) {
                this.getBounds().height = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
                continue;
            }
            if (!"extendsState".equals(node.getNodeName())) continue;
            this.extendsState = StringUtil.parsePrimitiveInt((String)XMLUtil.getTextContent(node));
        }
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public int getExtendsState() {
        return this.extendsState;
    }

    public void setExtendsState(int extendsState) {
        this.extendsState = extendsState;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DatabaseBrowserWindowBoundsConfig{");
        buffer.append("bounds=");
        buffer.append(this.getBounds());
        buffer.append(",");
        buffer.append("extendsState=");
        buffer.append(this.getExtendsState());
        buffer.append("}");
        return buffer.toString();
    }
}

