/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETextArea;
import org.phosphoresce.commons.eswing.core.ESwingConfig;

public final class EMessageDialog
extends EDialog {
    public static final int BUTTON_CLOSE = -1;
    public static final int BUTTON_CANCEL = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_YES = 2;
    public static final int BUTTON_NO = 3;
    public static final int BUTTON_RETRY = 4;
    private int pressedButton = -1;
    private EPanel contentsPanel = null;
    private ELabel dialogIconLabel = null;
    private ELabel messageLabel = null;
    private EPanel messageContentsPanel = null;
    private EPanel buttonPanel = null;
    private boolean okButtonVisible = true;
    private EButton okButton = null;
    private boolean retryButtonVisible = true;
    private EButton retryButton = null;
    private boolean cancelButtonVisible = true;
    private EButton cancelButton = null;
    private boolean yesButtonVisible = true;
    private EButton yesButton = null;
    private boolean noButtonVisible = true;
    private EButton noButton = null;
    private boolean detailButtonVisible = true;
    private EButton detailButton = null;
    private EScrollPane detailMessageScrollPane = null;
    private ETextArea detailMessageField = null;

    private EMessageDialog() {
        this.initialize();
    }

    public EMessageDialog(Frame parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, boolean detailButtonVisible) {
        super(parent, true);
        this.retryButtonVisible = retryButtonVisible;
        this.okButtonVisible = okButtonVisible;
        this.cancelButtonVisible = cancelButtonVisible;
        this.yesButtonVisible = yesButtonVisible;
        this.noButtonVisible = noButtonVisible;
        this.detailButtonVisible = detailButtonVisible;
        this.initialize();
    }

    public EMessageDialog(Dialog parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, boolean detailButtonVisible) {
        super(parent, true);
        this.retryButtonVisible = retryButtonVisible;
        this.okButtonVisible = okButtonVisible;
        this.cancelButtonVisible = cancelButtonVisible;
        this.yesButtonVisible = yesButtonVisible;
        this.noButtonVisible = noButtonVisible;
        this.detailButtonVisible = detailButtonVisible;
        this.initialize();
    }

    public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogErrorIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogErrorIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showError(Frame parent, String message) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showError(Dialog parent, String message) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showError(Frame parent, String message, Throwable throwable) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, throwable);
    }

    public static int showError(Dialog parent, String message, Throwable throwable) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, throwable);
    }

    public static int showError(Frame parent, String message, String detail) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, detail);
    }

    public static int showError(Dialog parent, String message, String detail) {
        return EMessageDialog.showError(parent, message, false, true, false, false, false, detail);
    }

    public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogInformationIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogInformationIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showInformation(Frame parent, String message) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showInformation(Dialog parent, String message) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showInformation(Frame parent, String message, Throwable throwable) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, throwable);
    }

    public static int showInformation(Dialog parent, String message, Throwable throwable) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, throwable);
    }

    public static int showInformation(Frame parent, String message, String detail) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, detail);
    }

    public static int showInformation(Dialog parent, String message, String detail) {
        return EMessageDialog.showInformation(parent, message, false, true, false, false, false, detail);
    }

    public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogWarningIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogWarningIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showWarning(Frame parent, String message) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showWarning(Dialog parent, String message) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showWarning(Frame parent, String message, Throwable throwable) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, throwable);
    }

    public static int showWarning(Dialog parent, String message, Throwable throwable) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, throwable);
    }

    public static int showWarning(Frame parent, String message, String detail) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, detail);
    }

    public static int showWarning(Dialog parent, String message, String detail) {
        return EMessageDialog.showWarning(parent, message, false, true, false, false, false, detail);
    }

    public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogQuestionIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogQuestionIcon());
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return EMessageDialog.showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showQuestion(Frame parent, String message) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, (String)null);
    }

    public static int showQuestion(Dialog parent, String message) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, (String)null);
    }

    public static int showQuestion(Frame parent, String message, Throwable throwable) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, throwable);
    }

    public static int showQuestion(Dialog parent, String message, Throwable throwable) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, throwable);
    }

    public static int showQuestion(Frame parent, String message, String detail) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, detail);
    }

    public static int showQuestion(Dialog parent, String message, String detail) {
        return EMessageDialog.showQuestion(parent, message, false, false, false, true, true, detail);
    }

    public void setMessage(String message) {
        this.getMessageLabel().setText("<html>" + (message == null ? "" : message) + "</html>");
    }

    public String getMessage() {
        return this.getMessageLabel().getText().startsWith("<html>") && this.getMessageLabel().getText().endsWith("</html>") ? this.getMessageLabel().getText().substring(6, this.getMessageLabel().getText().length() - 7) : this.getMessageLabel().getText();
    }

    private void initialize() {
        this.setSize(new Dimension(400, 300));
        this.setContentPane(this.getContentsPanel());
        if (this.getParent() instanceof Dialog) {
            this.setTitle(((Dialog)this.getParent()).getTitle());
        } else if (this.getParent() instanceof Frame) {
            this.setTitle(((Frame)this.getParent()).getTitle());
        }
        this.pack();
    }

    private EPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            this.contentsPanel = new EPanel();
            this.contentsPanel.setLayout(new GridBagLayout());
            this.contentsPanel.add((Component)this.getMessageContentsPanel(), gridBagConstraints1);
            this.contentsPanel.add((Component)this.getDetailMessageScrollPane(), gridBagConstraints2);
            this.contentsPanel.add((Component)this.getButtonPanel(), gridBagConstraints3);
        }
        return this.contentsPanel;
    }

    private ELabel getDialogIconLabel() {
        if (this.dialogIconLabel == null) {
            this.dialogIconLabel = new ELabel();
            this.dialogIconLabel.setPreferredSize(ESwingConfig.getMessageDialogIconSize());
            this.dialogIconLabel.setHorizontalAlignment(0);
            this.dialogIconLabel.setVerticalAlignment(1);
        }
        return this.dialogIconLabel;
    }

    private ELabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new ELabel();
            this.messageLabel.setVerticalAlignment(1);
            this.messageLabel.setPreferredSize(ESwingConfig.getMessageDialogMessagePaneSize());
        }
        return this.messageLabel;
    }

    private EPanel getMessageContentsPanel() {
        if (this.messageContentsPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.anchor = 11;
            gridBagConstraints1.insets = new Insets(30, 20, 10, 10);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(20, 10, 20, 20);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.messageContentsPanel = new EPanel();
            this.messageContentsPanel.setLayout(new GridBagLayout());
            this.messageContentsPanel.add((Component)this.getDialogIconLabel(), gridBagConstraints1);
            this.messageContentsPanel.add((Component)this.getMessageLabel(), gridBagConstraints2);
        }
        return this.messageContentsPanel;
    }

    private EPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints;
            this.buttonPanel = new EPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setPreferredSize(new Dimension(100, (int)ESwingConfig.getMessageDialogButtonSize().getHeight() + 20));
            if (this.retryButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getRetryButton(), gridBagConstraints);
            }
            if (this.yesButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getYesButton(), gridBagConstraints);
            }
            if (this.noButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getNoButton(), gridBagConstraints);
            }
            if (this.okButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints);
            }
            if (this.cancelButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints);
            }
            if (this.detailButtonVisible) {
                GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
                gridBagConstraints6.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints6.gridx = 5;
                gridBagConstraints6.gridy = 0;
                this.buttonPanel.add((Component)this.getDetailButton(), gridBagConstraints6);
            }
        }
        return this.buttonPanel;
    }

    private EButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new EButton();
            this.okButton.setText("OK");
            this.okButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EMessageDialog.this.pressedButton = 1;
                    EMessageDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private EButton getRetryButton() {
        if (this.retryButton == null) {
            this.retryButton = new EButton();
            this.retryButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.retryButton.setText("Retry");
            this.retryButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EMessageDialog.this.pressedButton = 4;
                    EMessageDialog.this.dispose();
                }
            });
        }
        return this.retryButton;
    }

    private EButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new EButton();
            this.cancelButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EMessageDialog.this.pressedButton = 0;
                    EMessageDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private EButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new EButton();
            this.yesButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.yesButton.setText("Yes");
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EMessageDialog.this.pressedButton = 2;
                    EMessageDialog.this.dispose();
                }
            });
        }
        return this.yesButton;
    }

    private EButton getNoButton() {
        if (this.noButton == null) {
            this.noButton = new EButton();
            this.noButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.noButton.setText("No");
            this.noButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EMessageDialog.this.pressedButton = 3;
                    EMessageDialog.this.dispose();
                }
            });
        }
        return this.noButton;
    }

    private EButton getDetailButton() {
        if (this.detailButton == null) {
            this.detailButton = new EButton();
            this.detailButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
            this.detailButton.setText("Detail >>");
            this.detailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Dimension dimension = EMessageDialog.this.getSize();
                    if (!EMessageDialog.this.getDetailMessageScrollPane().isVisible()) {
                        dimension.height += ((EMessageDialog)EMessageDialog.this).getDetailMessageScrollPane().getPreferredSize().height;
                        EMessageDialog.this.setSize(dimension);
                        EMessageDialog.this.getDetailMessageScrollPane().setVisible(true);
                        EMessageDialog.this.getDetailButton().setText("<< Detail");
                        EMessageDialog.this.pack();
                    } else {
                        dimension.height -= ((EMessageDialog)EMessageDialog.this).getDetailMessageScrollPane().getPreferredSize().height;
                        EMessageDialog.this.setSize(dimension);
                        EMessageDialog.this.getDetailMessageScrollPane().setVisible(false);
                        EMessageDialog.this.getDetailButton().setText("Detail >>");
                        EMessageDialog.this.pack();
                    }
                }
            });
        }
        return this.detailButton;
    }

    private EScrollPane getDetailMessageScrollPane() {
        if (this.detailMessageScrollPane == null) {
            this.detailMessageScrollPane = new EScrollPane();
            this.detailMessageScrollPane.setPreferredSize(ESwingConfig.getMessageDialogDitailMessagePaneSize());
            this.detailMessageScrollPane.setVisible(false);
            this.detailMessageScrollPane.setViewportView(this.getDetailMessageField());
        }
        return this.detailMessageScrollPane;
    }

    private ETextArea getDetailMessageField() {
        if (this.detailMessageField == null) {
            this.detailMessageField = new ETextArea();
            this.detailMessageField.setEditable(false);
        }
        return this.detailMessageField;
    }
}

