package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseConnectionException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hANZXNXۃNX<br>
 * <br>
 * NX̓R[hANZXɂ鋤ʂ̃C^tF[XyуtB[h񋟂܂B<br>
 * eANZXTuNX͂pāATuNXɓ܂B<br>
 * <br>
 * ܂ATuNXɂāAeGgNX̏ԂύXꂽƂɂA
 * Cӂ̏sꍇ́Ag̃NXɓXi[NX݂AGgNX
 * ɒ񋟂AԂ̕ύXsꂽ^C~OŁÃXi[ɃCxgʒmĖႢ܂B<br>
 * ȂAXi[NX̒񋟂͕K{ł͂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/09	Kitagawa		VK쐬
 *-->
 */
public abstract class RecordAccessorAbstract implements RecordAccessor {

	/** K[IuWFNg */
	protected Log log = LogFactory.getLog(this.getClass());

	/** f[^x[XZbVIuWFNg */
	private DatabaseSession session = null;

	/** ResultSetIuWFNg */
	protected ResultSet resultSet = null;

	/** R[h`IuWFNg */
	protected ResultRowDefinition rowDefinition;

	/** ԊǗXi[IuWFNg */
	protected ResultAccessorListener listener = null;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @throws ResultSetAccessException sResultSetIuWFNgw肵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException w肳ꂽReusltSetIuWFNg̃J[\ʒu擪OɂȂĂȂꍇɔ 
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 */
	protected RecordAccessorAbstract(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetAdjustmentException, IllegalResultSetLocationIndexException {
		if (resultSet == null) {
			throw new ResultSetAccessException("null 'resultSet' argument.");
		}
		this.resultSet = resultSet;
		this.rowDefinition = new ResultRowDefinition(resultSet);
		this.listener = null;
		if (getResultSetRowIndex() != 0) {
			throw new IllegalResultSetAdjustmentException("'resultSet' cursor is not before first row.");
		}
	}

	/**
	 * RXgN^<br>
	 * @throws ResultSetAccessException sResultSetIuWFNgw肵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException w肳ꂽReusltSetIuWFNg̃J[\ʒu擪OɂȂĂȂꍇɔ 
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 */
	private RecordAccessorAbstract() throws ResultSetAccessException, IllegalResultSetAdjustmentException, IllegalResultSetLocationIndexException {
		this(null);
	}

	// Public Final Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * ݁AύXsĂeׂ͂ĔjAResultSet̏ōXV܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#refreshResult()
	 */
	public final void refreshResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		refreshResult(false);
	}

	/**
	 * ResultSet̏ɂ`ێev[gsIuWFNg𐶐܂B<br>
	 * @return ev[gsIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#createTemplateRow()
	 */
	public final ResultTemplateRow createTemplateRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		return new ResultTemplateRow(resultSet, rowDefinition);
	}

	/**
	 * ResultSetێ郌R[h擾܂B<br>
	 * @return ResultSetێ郌R[h
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultRowCount()
	 */
	public final int getResultRowCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
		try {
			int currentRow = resultSet.getRow();
			resultSet.last();
			int lastRow = resultSet.getRow();
			moveCurser(currentRow);
			return lastRow;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get ResultSet row count.", e);
		}
	}

	/**
	 * R[hJ擾܂B<br>
	 * @return R[hJ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultColumnCount()
	 */
	public final int getResultColumnCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
		return rowDefinition.getColumnCount();
	}

	/**
	 * s`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultRowDefinition()
	 */
	public final ResultRowDefinition getResultRowDefinition() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
		return rowDefinition;
	}

	/**
	 * w肳ꂽJCfbNX̃J`擾܂B<br>
	 * @param columnIndex JCfbNX
	 * @return J`
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultColumnDefinition(int)
	 */
	public final ResultColumnDefinition getResultColumnDefinition(int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException {
		return rowDefinition.getColumnDefinition(columnIndex);
	}

	/**
	 * w肳ꂽJ̃J`擾܂B<br>
	 * @param columnName J
	 * @return J`
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultColumnDefinition(java.lang.String)
	 */
	public final ResultColumnDefinition getResultColumnDefinition(String columnName) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException {
		return rowDefinition.getColumnDefinition(columnName);
	}

	// Public Final Method (Transaction)

	/**
	 * R[hANZXIuWFNgێ񂪓ǂݎpł邩肵܂B<br>
	 * @return R[hANZXIuWFNgێ񂪓ǂݎpłꍇtrueԋp
	 * @throws DatabaseConnectionException Ƀf[^x[XRlNVɃANZXłȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#isReadOnly()
	 */
	public final boolean isReadOnly() throws DatabaseConnectionException {
		try {
			return resultSet.getStatement().getConnection().isReadOnly();
		} catch (SQLException e) {
			throw new DatabaseConnectionException("failed to analyze read only statement.", e);
		}
	}

	// Protected Final Method

	/**
	 * ݃ANeBuResultSetIuWFNg̍sʒu擾܂B<br>
	 * @return ݃ANeBuResultSetIuWFNg̍sʒu
	 * @throws ResultSetAccessException ɃJ[\ړsȂꍇɔ
	 */
	protected final int getResultSetRowIndex() throws ResultSetAccessException {
		try {
			return resultSet.getRow();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get ResultRow index.", e);
		}
	}

	/**
	 * w肳ꂽsʒu(ResultSetdlɔA1`)ɃJ[\ړ܂B<br>
	 * @param rowIndex sʒu(1`)
	 * @throws ResultSetAccessException ɃJ[\ړsȂꍇɔ
	 */
	protected final void moveCurser(int rowIndex) throws ResultSetAccessException {
		try {
			if (rowIndex == 0) {
				resultSet.beforeFirst();
			} else {
				resultSet.absolute(rowIndex);
			}
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to move cursor.", e);
		}
	}

	/**
	 * ԊǗXi[IuWFNgLł邩肵܂B<br>
	 * @return ԊǗXi[IuWFNgLłꍇtrueԋp
	 */
	protected final boolean validateStateListener() {
		return listener != null;
	}
}
