/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultRow;

public class FetchingList
implements List {
    private Map map = new TreeMap();
    private int count = 0;

    public FetchingList() {
    }

    public FetchingList(int count) {
        this.count = count;
    }

    private void incrementIndex(int index) {
        for (int i = this.count - 1; i >= index; --i) {
            Integer key = new Integer(i);
            if (!this.map.containsKey(key)) continue;
            Object object = this.map.get(key);
            this.map.remove(key);
            this.map.put(new Integer(key + 1), object);
        }
    }

    private void decrementIndex(int index) {
        for (int i = index; i <= this.count - 1; ++i) {
            Integer key = new Integer(i);
            if (!this.map.containsKey(key)) continue;
            Object object = this.map.get(key);
            this.map.remove(key);
            this.map.put(new Integer(key - 1), object);
        }
    }

    public void clearStaticRecords() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ResultRow resultRow = (ResultRow)iterator.next();
            if (resultRow == null || !resultRow.getState().equals(ResultAccessorState.STATIC)) continue;
            this.remove(resultRow);
        }
    }

    public boolean add(Object o) {
        this.map.put(new Integer(++this.count - 1), o);
        return true;
    }

    public void add(int index, Object element) {
        if (this.count - 1 < index) {
            this.count = index;
            this.add(element);
        } else {
            this.incrementIndex(index);
            this.map.put(new Integer(index), element);
        }
    }

    public boolean addAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        int count = 0;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            this.add(index + count++, iterator.next());
        }
        return true;
    }

    public void clear() {
        this.map.clear();
        this.count = 0;
    }

    public boolean contains(Object o) {
        return this.map.containsValue(o);
    }

    public boolean containsAll(Collection c) {
        if (c == null || c.size() == 0) {
            return true;
        }
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        return this.map.get(new Integer(index));
    }

    public int indexOf(Object o) {
        if (!this.map.containsValue(o)) {
            return -1;
        }
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (o == null && entry.getValue() == null) {
                Integer key = (Integer)entry.getKey();
                return key;
            }
            if (o == null || !o.equals(entry.getValue())) continue;
            Integer key = (Integer)entry.getKey();
            return key;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator iterator() {
        return new FetchingListIterator();
    }

    public int lastIndexOf(Object o) {
        if (!this.map.containsValue(o)) {
            return -1;
        }
        int result = -1;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer key;
            Map.Entry entry = iterator.next();
            if (o == null && entry.getValue() == null) {
                key = (Integer)entry.getKey();
                result = key;
                continue;
            }
            if (o == null || !o.equals(entry.getValue())) continue;
            key = (Integer)entry.getKey();
            result = key;
        }
        return result;
    }

    public ListIterator listIterator() {
        return new FetchingListListIterator();
    }

    public ListIterator listIterator(int index) {
        return new FetchingListListIterator(index);
    }

    public Object remove(int index) {
        Object object = this.get(index);
        this.decrementIndex(index);
        return object;
    }

    public boolean remove(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        int index = this.indexOf(o);
        Object object = this.remove(index);
        return true;
    }

    public boolean removeAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        boolean result = false;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.contains(object)) {
                result = true;
            }
            this.remove(object);
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        boolean result = false;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.contains(object)) continue;
            result = true;
            this.remove(object);
        }
        return result;
    }

    public Object set(int index, Object element) {
        Object object = this.get(index);
        if (this.count - 1 < index) {
            this.count = index + 1;
        }
        this.map.put(new Integer(index), element);
        return object;
    }

    public int size() {
        return this.count;
    }

    public List subList(int fromIndex, int toIndex) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = fromIndex; i <= toIndex; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public Object[] toArray() {
        Object[] objects = new Object[this.count];
        for (int i = 0; i <= this.count - 1; ++i) {
            objects[i] = this.get(i);
        }
        return objects;
    }

    public Object[] toArray(Object[] a) {
        for (int i = 0; i <= this.count - 1; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    private class FetchingListListIterator
    implements ListIterator {
        private int index = 0;

        public FetchingListListIterator() {
        }

        public FetchingListListIterator(int index) {
            this.index = index;
        }

        public void add(Object o) {
            FetchingList.this.add(o);
        }

        public boolean hasNext() {
            return this.index < FetchingList.this.count - 1;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object next() {
            return FetchingList.this.get(this.index++);
        }

        public int nextIndex() {
            return this.index;
        }

        public Object previous() {
            return FetchingList.this.get(--this.index);
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            FetchingList.this.remove(this.index);
        }

        public void set(Object o) {
            FetchingList.this.set(this.index, o);
        }
    }

    private class FetchingListIterator
    implements Iterator {
        private int index = 0;

        public boolean hasNext() {
            return this.index <= FetchingList.this.count - 1;
        }

        public Object next() {
            return FetchingList.this.get(this.index++);
        }

        public void remove() {
            FetchingList.this.remove(this.index);
        }
    }
}

