package org.phosphoresce.commons.eswing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.SwingConstants;

import org.phosphoresce.commons.eswing.core.ESwingConfig;

/**
 * ėpIȃbZ[W_CAONX<br>
 * <br>
 * JOptionPaneȈՂȃC^tF[XpӂAgppx̍C^tF[Xł
 * _CAO\ړIƂ_CAONXłB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class EMessageDialog extends EDialog {

	/** {^ */
	public static final int BUTTON_CLOSE = -1;

	/** Cancel{^ */
	public static final int BUTTON_CANCEL = 0;

	/** OK{^ */
	public static final int BUTTON_OK = 1;

	/** Yes{^ */
	public static final int BUTTON_YES = 2;

	/** No{^ */
	public static final int BUTTON_NO = 3;

	/** Retry{^ */
	public static final int BUTTON_RETRY = 4;

	/** {^ */
	private int pressedButton = BUTTON_CLOSE;

	/** Recpl */
	private EPanel contentsPanel = null;

	/** _CAOACRx */
	private ELabel dialogIconLabel = null;

	/** bZ[Wx */
	private ELabel messageLabel = null;

	/** bZ[WRecpl */
	private EPanel messageContentsPanel = null;

	/** {^pl */
	private EPanel buttonPanel = null;

	/** OK{^\tO */
	private boolean okButtonVisible = true;

	/** OK{^ */
	private EButton okButton = null;

	/** Retry{^\tO */
	private boolean retryButtonVisible = true;

	/** Retry{^ */
	private EButton retryButton = null;

	/** Cancel{^\tO */
	private boolean cancelButtonVisible = true;

	/** Cancel{^ */
	private EButton cancelButton = null;

	/** Yes{^\tO */
	private boolean yesButtonVisible = true;

	/** Yes{^\ */
	private EButton yesButton = null;

	/** No{^\tO */
	private boolean noButtonVisible = true;

	/** No{^\ */
	private EButton noButton = null;

	/** Detail{^\tO */
	private boolean detailButtonVisible = true;

	/** Detail{^\ */
	private EButton detailButton = null;

	/** ڍ׃bZ[WXN[yC */
	private EScrollPane detailMessageScrollPane = null;

	/** ڍ׃bZ[WtB[h */
	private ETextArea detailMessageField = null;

	/**
	 * RXgN^<br>
	 */
	private EMessageDialog() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param parent eR|[lgIuWFNg
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detailButtonVisible Detail{^\tO
	 */
	public EMessageDialog(Frame parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible,
			boolean detailButtonVisible) {
		super(parent, true);
		this.retryButtonVisible = retryButtonVisible;
		this.okButtonVisible = okButtonVisible;
		this.cancelButtonVisible = cancelButtonVisible;
		this.yesButtonVisible = yesButtonVisible;
		this.noButtonVisible = noButtonVisible;
		this.detailButtonVisible = detailButtonVisible;
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param parent eR|[lgIuWFNg
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detailButtonVisible Detail{^\tO
	 */
	public EMessageDialog(Dialog parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible,
			boolean detailButtonVisible) {
		super(parent, true);
		this.retryButtonVisible = retryButtonVisible;
		this.okButtonVisible = okButtonVisible;
		this.cancelButtonVisible = cancelButtonVisible;
		this.yesButtonVisible = yesButtonVisible;
		this.noButtonVisible = noButtonVisible;
		this.detailButtonVisible = detailButtonVisible;
		initialize();
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogErrorIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogErrorIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showError(Frame parent, String message) {
		return showError(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showError(Dialog parent, String message) {
		return showError(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showError(Frame parent, String message, Throwable throwable) {
		return showError(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showError(Dialog parent, String message, Throwable throwable) {
		return showError(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showError(Frame parent, String message, String detail) {
		return showError(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * G[bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showError(Dialog parent, String message, String detail) {
		return showError(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogInformationIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogInformationIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showInformation(Frame parent, String message) {
		return showInformation(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showInformation(Dialog parent, String message) {
		return showInformation(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showInformation(Frame parent, String message, Throwable throwable) {
		return showInformation(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showInformation(Dialog parent, String message, Throwable throwable) {
		return showInformation(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showInformation(Frame parent, String message, String detail) {
		return showInformation(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * 񃁃bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showInformation(Dialog parent, String message, String detail) {
		return showInformation(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogWarningIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogWarningIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showWarning(Frame parent, String message) {
		return showWarning(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showWarning(Dialog parent, String message) {
		return showWarning(parent, message, false, true, false, false, false, (String) null);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showWarning(Frame parent, String message, Throwable throwable) {
		return showWarning(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showWarning(Dialog parent, String message, Throwable throwable) {
		return showWarning(parent, message, false, true, false, false, false, throwable);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showWarning(Frame parent, String message, String detail) {
		return showWarning(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * xbZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showWarning(Dialog parent, String message, String detail) {
		return showWarning(parent, message, false, true, false, false, false, detail);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogQuestionIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, String detail) {
		EMessageDialog dialog = new EMessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null
				&& !"".equals(detail.trim()));
		dialog.getDialogIconLabel().setIcon(ESwingConfig.getMessageDialogQuestionIcon());
		dialog.getDetailMessageField().setText(detail);
		dialog.setMessage(message);
		dialog.pack();
		dialog.setLocationRelativeTo(parent);
		dialog.setVisible(true);
		return dialog.pressedButton;
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param retryButtonVisible Retrey{^\tO
	 * @param okButtonVisible Ok{^\tO
	 * @param cancelButtonVisible Cancel{^\tO
	 * @param yesButtonVisible Yes{^\tO
	 * @param noButtonVisible No{^\tO
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible,
			boolean noButtonVisible, Throwable throwable) {
		StringWriter writer = new StringWriter();
		throwable.printStackTrace(new PrintWriter(writer));
		return showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Frame parent, String message) {
		return showQuestion(parent, message, false, false, false, true, true, (String) null);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Dialog parent, String message) {
		return showQuestion(parent, message, false, false, false, true, true, (String) null);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showQuestion(Frame parent, String message, Throwable throwable) {
		return showQuestion(parent, message, false, false, false, true, true, throwable);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 * @return {^l
	 */
	public static int showQuestion(Dialog parent, String message, Throwable throwable) {
		return showQuestion(parent, message, false, false, false, true, true, throwable);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Frame parent, String message, String detail) {
		return showQuestion(parent, message, false, false, false, true, true, detail);
	}

	/**
	 * ⃁bZ[W_CAO\܂B<br>
	 * @param parent eR|[lgIuWFNg
	 * @param message bZ[W
	 * @param detail ڍ׃bZ[W
	 * @return {^l
	 */
	public static int showQuestion(Dialog parent, String message, String detail) {
		return showQuestion(parent, message, false, false, false, true, true, detail);
	}

	/**
	 * bZ[Wݒ肵܂B<br>
	 * w肷郁bZ[Whtml`̃bZ[Wœhtml^O⊮܂B<br>
	 * @param message bZ[W
	 */
	public void setMessage(String message) {
		getMessageLabel().setText("<html>" + (message == null ? "" : message) + "</html>");
	}

	/**
	 * bZ[W擾܂B<br>
	 * @return bZ[W
	 */
	public String getMessage() {
		return getMessageLabel().getText().startsWith("<html>") && getMessageLabel().getText().endsWith("</html>") //
		? getMessageLabel().getText().substring(6, getMessageLabel().getText().length() - 7) : getMessageLabel().getText();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setSize(new Dimension(400, 300));
		this.setContentPane(getContentsPanel());
		if (getParent() instanceof Dialog) {
			this.setTitle(((Dialog) getParent()).getTitle());
		} else if (getParent() instanceof Frame) {
			this.setTitle(((Frame) getParent()).getTitle());
		}
		this.pack();
	}

	/**
	 * Recpl擾܂B<br>
	 * @return Recpl
	 */
	private EPanel getContentsPanel() {
		if (contentsPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0D;
			gridBagConstraints1.weighty = 1.0D;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 1;
			gridBagConstraints2.weightx = 1.0D;
			gridBagConstraints2.weighty = 0.0D;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 2;
			gridBagConstraints3.weightx = 1.0D;
			gridBagConstraints3.weighty = 0.0D;
			contentsPanel = new EPanel();
			contentsPanel.setLayout(new GridBagLayout());
			contentsPanel.add(getMessageContentsPanel(), gridBagConstraints1);
			contentsPanel.add(getDetailMessageScrollPane(), gridBagConstraints2);
			contentsPanel.add(getButtonPanel(), gridBagConstraints3);
		}
		return contentsPanel;
	}

	/**
	 * _CAOACRx擾܂B<br>
	 * @return _CAOACRx
	 */
	private ELabel getDialogIconLabel() {
		if (dialogIconLabel == null) {
			dialogIconLabel = new ELabel();
			dialogIconLabel.setPreferredSize(ESwingConfig.getMessageDialogIconSize());
			dialogIconLabel.setHorizontalAlignment(SwingConstants.CENTER);
			dialogIconLabel.setVerticalAlignment(SwingConstants.TOP);
		}
		return dialogIconLabel;
	}

	/**
	 * bZ[Wx擾܂B<br>
	 * @return bZ[Wx
	 */
	private ELabel getMessageLabel() {
		if (messageLabel == null) {
			messageLabel = new ELabel();
			messageLabel.setVerticalAlignment(SwingConstants.TOP);
			messageLabel.setPreferredSize(ESwingConfig.getMessageDialogMessagePaneSize());
		}
		return messageLabel;
	}

	/**
	 * bZ[WRecpl擾܂B<br>
	 * @return bZ[WRecpl
	 */
	private EPanel getMessageContentsPanel() {
		if (messageContentsPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.NONE;
			gridBagConstraints1.anchor = GridBagConstraints.NORTH;
			gridBagConstraints1.insets = new Insets(30, 20, 10, 10);
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 0.0D;
			gridBagConstraints1.weighty = 1.0D;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.anchor = GridBagConstraints.NORTH;
			gridBagConstraints2.insets = new Insets(20, 10, 20, 20);
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.gridy = 0;
			gridBagConstraints2.weightx = 1.0D;
			gridBagConstraints2.weighty = 1.0D;
			messageContentsPanel = new EPanel();
			messageContentsPanel.setLayout(new GridBagLayout());
			messageContentsPanel.add(getDialogIconLabel(), gridBagConstraints1);
			messageContentsPanel.add(getMessageLabel(), gridBagConstraints2);
		}
		return messageContentsPanel;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return {^pl
	 */
	private EPanel getButtonPanel() {
		if (buttonPanel == null) {
			buttonPanel = new EPanel();
			buttonPanel.setLayout(new GridBagLayout());
			buttonPanel.setPreferredSize(new Dimension(100, (int) ESwingConfig.getMessageDialogButtonSize().getHeight() + 20));
			if (retryButtonVisible) {
				GridBagConstraints gridBagConstraints = new GridBagConstraints();
				gridBagConstraints.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints.gridx = 0;
				gridBagConstraints.gridy = 0;
				buttonPanel.add(getRetryButton(), gridBagConstraints);
			}
			if (yesButtonVisible) {
				GridBagConstraints gridBagConstraints = new GridBagConstraints();
				gridBagConstraints.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints.gridx = 1;
				gridBagConstraints.gridy = 0;
				buttonPanel.add(getYesButton(), gridBagConstraints);
			}
			if (noButtonVisible) {
				GridBagConstraints gridBagConstraints = new GridBagConstraints();
				gridBagConstraints.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints.gridx = 2;
				gridBagConstraints.gridy = 0;
				buttonPanel.add(getNoButton(), gridBagConstraints);
			}
			if (okButtonVisible) {
				GridBagConstraints gridBagConstraints = new GridBagConstraints();
				gridBagConstraints.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints.gridx = 3;
				gridBagConstraints.gridy = 0;
				buttonPanel.add(getOkButton(), gridBagConstraints);
			}
			if (cancelButtonVisible) {
				GridBagConstraints gridBagConstraints = new GridBagConstraints();
				gridBagConstraints.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints.gridx = 4;
				gridBagConstraints.gridy = 0;
				buttonPanel.add(getCancelButton(), gridBagConstraints);
			}
			if (detailButtonVisible) {
				GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
				gridBagConstraints6.insets = new Insets(0, 4, 0, 4);
				gridBagConstraints6.gridx = 5;
				gridBagConstraints6.gridy = 0;
				buttonPanel.add(getDetailButton(), gridBagConstraints6);
			}
		}
		return buttonPanel;
	}

	/**
	 * OK{^擾܂B<br>
	 * @return OK{^
	 */
	private EButton getOkButton() {
		if (okButton == null) {
			okButton = new EButton();
			okButton.setText("OK");
			okButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			okButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					pressedButton = BUTTON_OK;
					dispose();
				}
			});
		}
		return okButton;
	}

	/**
	 * Retry{^擾܂B<br>
	 * @return Retry{^
	 */
	private EButton getRetryButton() {
		if (retryButton == null) {
			retryButton = new EButton();
			retryButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			retryButton.setText("Retry");
			retryButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					pressedButton = BUTTON_RETRY;
					dispose();
				}
			});
		}
		return retryButton;
	}

	/**
	 * Cancel{^擾܂B<br>
	 * @return Cancel{^
	 */
	private EButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new EButton();
			cancelButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					pressedButton = BUTTON_CANCEL;
					dispose();
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Yes{^擾܂B<br>
	 * @return Yes{^
	 */
	private EButton getYesButton() {
		if (yesButton == null) {
			yesButton = new EButton();
			yesButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			yesButton.setText("Yes");
			yesButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					pressedButton = BUTTON_YES;
					dispose();
				}
			});
		}
		return yesButton;
	}

	/**
	 * No{^擾܂B<br>
	 * @return No{^
	 */
	private EButton getNoButton() {
		if (noButton == null) {
			noButton = new EButton();
			noButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			noButton.setText("No");
			noButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					pressedButton = BUTTON_NO;
					dispose();
				}
			});
		}
		return noButton;
	}

	/**
	 * Detail{^擾܂B<br>
	 * @return Detail{^
	 */
	private EButton getDetailButton() {
		if (detailButton == null) {
			detailButton = new EButton();
			detailButton.setPreferredSize(ESwingConfig.getMessageDialogButtonSize());
			detailButton.setText("Detail >>");
			detailButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Dimension dimension = getSize();
					if (!getDetailMessageScrollPane().isVisible()) {
						dimension.height = dimension.height + getDetailMessageScrollPane().getPreferredSize().height;
						setSize(dimension);
						getDetailMessageScrollPane().setVisible(true);
						getDetailButton().setText("<< Detail");
						pack();
					} else {
						dimension.height = dimension.height - getDetailMessageScrollPane().getPreferredSize().height;
						setSize(dimension);
						getDetailMessageScrollPane().setVisible(false);
						getDetailButton().setText("Detail >>");
						pack();
					}
				}
			});
		}
		return detailButton;
	}

	/**
	 * ڍ׃bZ[WXN[yC擾܂B<br>
	 * @return ڍ׃bZ[WXN[yC
	 */
	private EScrollPane getDetailMessageScrollPane() {
		if (detailMessageScrollPane == null) {
			detailMessageScrollPane = new EScrollPane();
			detailMessageScrollPane.setPreferredSize(ESwingConfig.getMessageDialogDitailMessagePaneSize());
			detailMessageScrollPane.setVisible(false);
			detailMessageScrollPane.setViewportView(getDetailMessageField());
		}
		return detailMessageScrollPane;
	}

	/**
	 * ڍ׃bZ[WtB[h擾܂B<br>
	 * @return ڍ׃bZ[WtB[h
	 */
	private ETextArea getDetailMessageField() {
		if (detailMessageField == null) {
			detailMessageField = new ETextArea();
			detailMessageField.setEditable(false);
		}
		return detailMessageField;
	}
}
