package org.phosphoresce.library.wpoi.util;

import java.io.Serializable;

import org.apache.poi.hssf.usermodel.HSSFHeader;

/**
 * POIwb_/tb^\zNXB<br>
 * HSSFHeaderyHSSFFooter񋟂wb_/tb^̍\z@\񋟂B<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2006/01/25
 * 
 *<!--
 * XV       XV          XVe
 * 2006/01/25	Kitagawa		VK쐬
 *-->
 */
public final class PoiPrintStringBuilder implements Serializable {

	/** obt@ */
	private StringBuffer buffer;

	/**
	 * RXgN^<br>
	 */
	public PoiPrintStringBuilder() {
		this.buffer = new StringBuffer();
	}

	/**
	 * \z擾B<br>
	 * @return wb_/tb^p
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return buffer.toString();
	}

	/**
	 * w肳ꂽǉB<br>
	 * @param string ǉ
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder append(String string) {
		buffer.append(string);
		return this;
	}

	/**
	 * w肳ꂽtHgƃX^CǉB<br>
	 * @param fontname tHg
	 * @param style tHgX^C
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder append(String fontname, String style) {
		buffer.append(HSSFHeader.font(fontname, style));
		return this;
	}

	/**
	 * tǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendDate() {
		buffer.append(HSSFHeader.date());
		return this;
	}

	/**
	 * t@CǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendFileName() {
		buffer.append(HSSFHeader.file());
		return this;
	}

	/**
	 * y[WǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendLastPageNo() {
		buffer.append(HSSFHeader.numPages());
		return this;
	}

	/**
	 * y[WǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendPageNo() {
		buffer.append(HSSFHeader.page());
		return this;
	}

	/**
	 * ^uǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendTab() {
		buffer.append(HSSFHeader.tab());
		return this;
	}

	/**
	 * ǉB<br>
	 * @return g̃CX^X
	 */
	public PoiPrintStringBuilder appendTime() {
		buffer.append(HSSFHeader.time());
		return this;
	}
}
