package org.phosphoresce.library.wpoi.test.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.library.wpoi.test.util.CommonUtils;

/**
 * TvNX<br>
 * Ѓf<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV       XV          XVe
 * 2005/12/07	Kitagawa		VK쐬
 *-->
 */
public final class Company extends Model {

	/** ЃR[h */
	private String code;

	/**  */
	private String country;

	/** Ж */
	private String name;

	/**  */
	private Section[] sections;

	/** q */
	private Company[] childCompanies;

	/** ǗvWFNg */
	private Project[] projects;

	/**
	 * RXgN^<br>
	 * @param code ЃR[h
	 * @param country 
	 * @param name Ж
	 */
	public Company(String code, String country, String name) {
		super();
		this.code = code;
		this.country = country;
		this.name = name;
	}

	/**
	 * ǗvWFNgǉ܂B<br>
	 * @param project vWFNg
	 */
	public void addProject(Project project) {
		List buffer = new LinkedList(Arrays.asList(getProjects()));
		if (project != null && !buffer.contains(project)) {
			buffer.add(project);
		}
		projects = (Project[]) CommonUtils.castArray(Project.class, buffer);
	}

	/**
	 * ǉ܂B<br>
	 * @param section 
	 */
	public void addSection(Section section) {
		List buffer = new LinkedList(Arrays.asList(getSections()));
		if (section != null && !buffer.contains(section)) {
			buffer.add(section);
			section.setCompany(this);
		}
		sections = (Section[]) CommonUtils.castArray(Section.class, buffer);
	}

	/**
	 * w肳ꂽ폜܂B<br>
	 * @param section 
	 */
	public void removeSection(Section section) {
		List buffer = new LinkedList(Arrays.asList(getSections()));
		if (buffer.contains(section)) {
			buffer.remove(section);
			section.setCompany(null);
		}
		sections = (Section[]) CommonUtils.castArray(Section.class, buffer);
	}

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public Long getSectionCount() {
		return new Long(getSections().length);
	}

	/**
	 * SЈ擾܂B<br>
	 * @return SЈIuWFNgz
	 */
	public Employee[] getAllEmployees() {
		Employee[] allEmployees = new Employee[] {};

		for (int j = 0; j <= sections.length - 1; j++) {
			Section section = sections[j];

			Employee[] employees = section.getEmployees();
			for (int i = 0; i <= employees.length - 1; i++) {
				Employee employee = employees[i];
				allEmployees = (Employee[]) CommonUtils.addArray(Employee.class, allEmployees, employee);
			}
		}

		return allEmployees;
	}

	/**
	 * SЈ擾܂B<br>
	 * @return SЈ
	 */
	public int getEmployeeCount() {
		return getAllEmployees().length;
	}

	/**
	 * ЃR[h擾܂B<br>
	 * @return ЃR[h
	 */
	public String getCode() {
		return code;
	}

	/**
	 * ЃR[hݒ肵܂B<br>
	 * @param code ЃR[h
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * Ж擾܂B<br>
	 * @return Ж
	 */
	public String getName() {
		return name;
	}

	/**
	 * Жݒ肵܂B<br>
	 * @param name Ж
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public Section[] getSections() {
		return sections == null ? new Section[] {} : sections;
	}

	/**
	 * 擾܂B<br>
	 * @return 
	 */
	public String getCountry() {
		return country;
	}

	/**
	 * ݒ肵܂B<br>
	 * @param country 
	 */
	public void setCountry(String country) {
		this.country = country;
	}

	/**
	 * qЂ擾܂B<br>
	 * @return q
	 */
	public Company[] getChildCompanies() {
		return childCompanies == null ? new Company[] {} : childCompanies;
	}

	/**
	 * qЂݒ肵܂B<br>
	 * @param childCompanies q
	 */
	public void setChildCompanies(Company[] childCompanies) {
		this.childCompanies = childCompanies;
	}

	/**
	 * vWFNg擾܂B<br>
	 * @return vWFNg
	 */
	public Project[] getProjects() {
		return projects == null ? new Project[] {} : projects;
	}
}
