package org.phosphoresce.library.wpoi.dyna;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.library.wpoi.adapter.PoiValue;
import org.phosphoresce.library.wpoi.exception.PoiException;

/**
 * PoiDynaMapt@NgNX<br>
 * Jakarta񋟂BeanUtilAPropertyUtilpBeanIuWFNgPoiDynaMap̐@\񋟂B<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2006/02/16
 * 
 *<!--
 * XV       XV          XVe
 * 2006/02/16	Kitagawa		VK쐬
 * 2006/03/27	Kitagawa		̏OL[w肷C^tF[Xp
 *-->
 */
public class PoiDynaMapFactory {

	/** MOIuWFNg */
	private static Log log = LogFactory.getLog(PoiDynaMapFactory.class);

	/** fBtHg[xE */
	public static final int DEFAULT_SEARCH_DEPTH = 3;

	/**
	 * w肳ꂽBeanIuWFNgz񂩂PoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param beans BeanIuWFNgz
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @return w肳ꂽBeanIuWFNgz񂩂琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(Object[] beans, int maxSearchDepth, String[] excludeKeys) throws PoiException {
		PoiDynaList dynaList = new PoiDynaList();

		if (beans == null || beans.length == 0) {
			return new PoiDynaList();
		}

		for (int i = 0; i <= beans.length - 1; i++) {
			Object bean = beans[i];
			dynaList.add(createDynaMap(bean, maxSearchDepth, excludeKeys));
		}

		return dynaList;
	}

	/**
	 * w肳ꂽBeanIuWFNgz񂩂PoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param beans BeanIuWFNgz
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @return w肳ꂽBeanIuWFNgz񂩂琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(Object[] beans, int maxSearchDepth) throws PoiException {
		return createDynaList(beans, maxSearchDepth, null);
	}

	/**
	 * w肳ꂽBeanIuWFNgz񂩂PoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param beans BeanIuWFNgz
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @return w肳ꂽBeanIuWFNgz񂩂琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(Object[] beans, String[] excludeKeys) throws PoiException {
		return createDynaList(beans, DEFAULT_SEARCH_DEPTH, excludeKeys);
	}

	/**
	 * w肳ꂽBeanIuWFNgz񂩂PoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param beans BeanIuWFNgz
	 * @return w肳ꂽBeanIuWFNgz񂩂琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(Object[] beans) throws PoiException {
		return createDynaList(beans, DEFAULT_SEARCH_DEPTH);
	}

	/**
	 * w肳ꂽBeanIuWFNgXgPoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param beanList BeanIuWFNgXg
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @return w肳ꂽBeanIuWFNgXg琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(List beanList, int maxSearchDepth, String[] excludeKeys) throws PoiException {
		if (beanList == null || beanList.size() == 0) {
			return new PoiDynaList();
		}

		return createDynaList(beanList.toArray(new Object[beanList.size()]), maxSearchDepth, excludeKeys);
	}

	/**
	 * w肳ꂽBeanIuWFNgXgPoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param beanList BeanIuWFNgXg
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @return w肳ꂽBeanIuWFNgXg琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(List beanList, int maxSearchDepth) throws PoiException {
		if (beanList == null || beanList.size() == 0) {
			return new PoiDynaList();
		}

		return createDynaList(beanList.toArray(new Object[beanList.size()]), maxSearchDepth);
	}

	/**
	 * w肳ꂽBeanIuWFNgXgPoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param beanList BeanIuWFNgXg
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @return w肳ꂽBeanIuWFNgXg琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(List beanList, String[] excludeKeys) throws PoiException {
		return createDynaList(beanList, DEFAULT_SEARCH_DEPTH, excludeKeys);
	}

	/**
	 * w肳ꂽBeanIuWFNgXgPoiDynaList𐶐܂B<br>
	 * BeanIuWFNgPoiDynaMap̓createDynaMapɈˑ܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param beanList BeanIuWFNgXg
	 * @return w肳ꂽBeanIuWFNgXg琶PoiDynaList
	 * @throws PoiException PoiDynaListIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaList createDynaList(List beanList) throws PoiException {
		return createDynaList(beanList, DEFAULT_SEARCH_DEPTH);
	}

	/**
	 * w肳ꂽBeanIuWFNgPoiDynaMapIuWFNg𐶐܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param bean ϊΏBeanIuWFNg
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @return ϊPoiDynaMapIuWFNg
	 * @throws PoiException PoiDynaMapIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaMap createDynaMap(Object bean, int maxSearchDepth, String[] excludeKeys) throws PoiException {
		try {
			if (bean == null) {
				return null;
			} else if (bean instanceof Object[]) {
				throw new PoiException("PoiDynaMapΏBeanIuWFNgzɂȂĂ܂");
			} else if (bean instanceof List) {
				throw new PoiException("PoiDynaMapΏBeanIuWFNgListIuWFNgɂȂĂ܂");
			} else {
				PoiDynaMapDescribe describe = new PoiDynaMapDescribe();
				return renderDynaMap(describe.describe(bean), 0, maxSearchDepth, describe, excludeKeys);
			}
		} catch (Exception e) {
			throw new PoiException("w肳ꂽBeanIuWFNgPoiDynaMapIuWFNg𐶐ł܂ł[" + bean.getClass().getName() + "]", e);
		}
	}

	/**
	 * w肳ꂽBeanIuWFNgPoiDynaMapIuWFNg𐶐܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param bean ϊΏBeanIuWFNg
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @return ϊPoiDynaMapIuWFNg
	 * @throws PoiException PoiDynaMapIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaMap createDynaMap(Object bean, int maxSearchDepth) throws PoiException {
		return createDynaMap(bean, maxSearchDepth, null);
	}

	/**
	 * w肳ꂽBeanIuWFNgPoiDynaMapIuWFNg𐶐܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param bean ϊΏBeanIuWFNg
	 * @param excludeKeys ΏۊÕvpeBL[
	 * @return ϊPoiDynaMapIuWFNg
	 * @throws PoiException PoiDynaMapIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaMap createDynaMap(Object bean, String[] excludeKeys) throws PoiException {
		return createDynaMap(bean, DEFAULT_SEARCH_DEPTH, excludeKeys);
	}

	/**
	 * w肳ꂽBeanIuWFNgPoiDynaMapIuWFNg𐶐܂B<br>
	 * ċNs[xɂĂ͓NX񋟂fBtHgElgp܂B<br>
	 * @param bean ϊΏBeanIuWFNg
	 * @return ϊPoiDynaMapIuWFNg
	 * @throws PoiException PoiDynaMapIuWFNg𐶐łȂꍇɔ
	 */
	public static PoiDynaMap createDynaMap(Object bean) throws PoiException {
		return createDynaMap(bean, null);
	}

	/**
	 * w肳ꂽMapIuWFNgPoiDynaMap𐶐܂B<br>
	 * maxSearchDepthŎw肳ꂽ[xE܂ōċNs܂Aȏ̐[̏
	 * ɂĂ͌sɍs܂(zQƂ̃IuWFNgɑ΂鏈u)B<br>
	 * fBtHǧE[x͓NXێDEFAULT_SEARCH_DEPTHƂĒ񋟂Ă܂B<br>
	 * @param map PoiDynaMapΏMapIuWFNg
	 * @param depth [x
	 * @param maxSearchDepth [x̌El(̒l[Kw̏͌ɍs܂)
	 * @param bufferedObject ̃IuWFNgobt@
	 * @param bufferedRender ̃_Oobt@
	 * @return w肳ꂽMapIuWFNgɂPoiDynaMapIuWFNg
	 */
	private static PoiDynaMap renderDynaMap(Map map, int depth, int maxSearchDepth, PoiDynaMapDescribe describe, String[] excludeKeys) throws PoiException {
		if (depth > maxSearchDepth) {
			log.trace("w肳ĂċNEl𒴂̂łȏ͍̌s܂");
			return null;
		}

		try {
			PoiDynaMap dynaMap = new PoiDynaMap();

			if (map == null) {
				return null;
			}

			Iterator iterator = map.keySet().iterator();
			while (iterator.hasNext()) {
				String key = (String) iterator.next();
				Object object = map.get(key);

				log.trace("****  : " + key);

				boolean skip = false;
				if (excludeKeys != null) {
					for (int i = 0; i <= excludeKeys.length - 1; i++) {
						if (key.equals(excludeKeys[i])) {
							skip = true;
							break;
						}
					}
				}
				if (skip) {
					log.trace("**** (" + key + ")͖܂");
					continue;
				}

				if (PoiValue.isValidPoiValue(object)) {
					// IuWFNgPoiValueɑΉĂꍇPoiValueIuWFNgZbg
					PoiValue render = PoiValue.createPoiValue(object);
					dynaMap.put(key, render);
				} else if (object instanceof Object[]) {
					PoiDynaList dynaList = new PoiDynaList();
					for (int i = 0; i <= ((Object[]) object).length - 1; i++) {
						Object object2 = ((Object[]) object)[i];
						if (PoiValue.isValidPoiValue(object2)) {
							log.trace("PoiDynaMapMapBeanIuWFNgzȊO̔z񂪊܂܂Ă邽ߖ܂");
						} else {
							dynaList.add(renderDynaMap(describe.describe(object2), depth + 1, maxSearchDepth, describe, excludeKeys));
						}
					}
					dynaMap.put(key, dynaList);
				} else if (object instanceof Collection) {
					PoiDynaList dynaList = new PoiDynaList();
					Iterator iterator2 = ((Collection) object).iterator();
					while (iterator2.hasNext()) {
						Object object2 = iterator2.next();
						if (PoiValue.isValidPoiValue(object2)) {
							log.trace("PoiDynaMapMapBeanIuWFNgCollectionȊOCollection܂܂Ă邽ߖ܂");
						} else {
							dynaList.add(renderDynaMap(describe.describe(object2), depth + 1, maxSearchDepth, describe, excludeKeys));
						}
					}
					dynaMap.put(key, dynaList);
				} else {
					PoiDynaMap innerDynaMap = renderDynaMap(describe.describe(object), depth + 1, maxSearchDepth, describe, excludeKeys);

					if (innerDynaMap != null) {
						PoiDynaMap render = innerDynaMap.getNestedDynaMap(key);

						dynaMap.putAll(render);
					}
				}
			}

			return dynaMap;
		} catch (Exception e) {
			throw new PoiException("MapIuWFNgPoiDynaMapIuWFNg𐶐邱Ƃo܂ł", e);
		}
	}
}
