package org.phosphoresce.library.wpoi.dyna;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.library.wpoi.adapter.PoiValue;

/**
 * POIIlf[^ێNXB<br>
 * C^tF[Xׁ݂̐AMapC^tF[X͎AMapIuWFNgɏ
 * ϏAƎ̃}bvC^tF[XNXB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 *-->
 */
public final class PoiDynaMap {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** }bvIuWFNg */
	private Map map;

	/**
	 * RXgN^<br>
	 * @see LinkedHashMap#LinkedHashMap()
	 */
	public PoiDynaMap() {
		this.map = new LinkedHashMap();
	}

	/**
	 * RXgN^<br>
	 * @param m PoiDynaMapIuWFNg
	 * @see LinkedHashMap#LinkedHashMap(java.util.Map)
	 */
	public PoiDynaMap(PoiDynaMap m) {
		this.map = new LinkedHashMap(m.map);
	}

	/**
	 * RXgN^<br>
	 * @param map LinkedHashMap}bvIuWFNg
	 * @see LinkedHashMap#LinkedHashMap(java.util.Map)
	 */
	private PoiDynaMap(LinkedHashMap map) {
		this.map = map;
	}

	/**
	 * @param key L[
	 * @return L[݂ꍇAtrueԋp
	 * @see HashMap#containsKey(java.lang.Object)
	 */
	public boolean containsKey(String key) {
		return map.containsKey(key);
	}

	/**
	 * @param value l
	 * @return l݂ꍇAtrueԋp
	 * @see HashMap#containsValue(java.lang.Object)
	 */
	public boolean containsValue(PoiValue value) {
		return map.containsValue(value);
	}

	/**
	 * @param value l
	 * @return l݂ꍇAtrueԋp
	 * @see HashMap#containsValue(java.lang.Object)
	 */
	public boolean containsValue(PoiDynaList value) {
		return map.containsValue(value);
	}

	/**
	 * @param o IuWFNg(PoiDynaMapz)
	 * @return ̃IuWFNgłꍇAtrueԋp
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		return map.equals(o);
	}

	/**
	 * @param key L[
	 * @return L[ŕێĂPoiValueIuWFNg
	 * @see HashMap#get(java.lang.Object)
	 */
	public PoiValue getDynaValue(String key) {
		return (PoiValue) map.get(key);
	}

	/**
	 * @param key L[
	 * @return L[ŕێĂPoiDynaListIuWFNg
	 * @see HashMap#get(java.lang.Object)
	 */
	public PoiDynaList getDynaList(String key) {
		return (PoiDynaList) map.get(key);
	}

	/**
	 * @param key L[
	 * @return w肳ꂽL[ŕێĂf[^PoiValuełꍇAtrueԋp
	 */
	public boolean isDynaValue(String key) {
		return map.get(key) instanceof PoiValue;
	}

	/**
	 * @param key L[
	 * @return w肳ꂽL[ŕێĂf[^PoiDynaListłꍇAtrueԋp
	 */
	public boolean isDynaList(String key) {
		return map.get(key) instanceof PoiDynaList;
	}

	/**
	 * @return PoiDynaMapłꍇAtrueԋp
	 * @see HashMap#isEmpty()
	 */
	public boolean isEmpty() {
		return map.isEmpty();
	}

	/**
	 * @param key L[
	 * @param value PoiValueIuWFNg
	 * @return ݒOɕێĂPoiValue܂PoiDynaListIuWFNg
	 * @see HashMap#put(java.lang.Object, java.lang.Object)
	 */
	public Object put(String key, PoiValue value) {
		return map.put(key, value);
	}

	/**
	 * @param key L[
	 * @param value PoiDynaListIuWFNg
	 * @return ݒOɕێĂPoiValue܂PoiDynaListIuWFNg
	 * @see HashMap#put(java.lang.Object, java.lang.Object)
	 */
	public Object put(String key, PoiDynaList value) {
		return map.put(key, value);
	}

	/**
	 * @param t PoiDynaMapIuWFNg
	 * @see HashMap#putAll(java.util.Map)
	 */
	public void putAll(PoiDynaMap t) {
		map.putAll(t.map);
	}

	/**
	 * @param key L[
	 * @return 폜OɕێĂPoiValue܂PoiDynaListIuWFNg
	 * @see HashMap#remove(java.lang.Object)
	 */
	public Object remove(String key) {
		return map.remove(key);
	}

	/**
	 * @return }bṽTCY
	 * @see HashMap#size()
	 */
	public int size() {
		return map.size();
	}

	/**
	 * @return IuWFNg̕
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return map.toString();
	}

	/**
	 * w肳ꂽePoiDynaMapIuWFNgvtBNXɂL[
	 * VPoiDynaMapIuWFNg擾܂B<br>
	 * @return w肳ꂽePoiDynaMapIuWFNgvtBNXɂL[VPoiDynaMapIuWFNg
	 */
	final PoiDynaMap getNestedDynaMap(String parentBeanName) {
		LinkedHashMap render = new LinkedHashMap();

		Iterator iterator = map.keySet().iterator();

		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			Object object = map.get(key);

			render.put(parentBeanName + "." + key, object);
		}

		return new PoiDynaMap(render);
	}
}
