/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.dyna;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.phosphoresce.library.wpoi.adapter.PoiCell;
import org.phosphoresce.library.wpoi.adapter.PoiRange;
import org.phosphoresce.library.wpoi.adapter.PoiRow;
import org.phosphoresce.library.wpoi.adapter.PoiSheet;
import org.phosphoresce.library.wpoi.adapter.PoiValue;
import org.phosphoresce.library.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.library.wpoi.dyna.PoiDynaList;
import org.phosphoresce.library.wpoi.dyna.PoiDynaMap;
import org.phosphoresce.library.wpoi.dyna.PoiDynaUtil;
import org.phosphoresce.library.wpoi.exception.PoiException;
import org.phosphoresce.library.wpoi.exception.PoiIOException;
import org.phosphoresce.library.wpoi.util.PoiPrintConfig;
import org.phosphoresce.library.wpoi.util.PoiProgressMonitor;

public final class PoiDynaSheet
implements Serializable {
    private Log log = LogFactory.getLog(this.getClass());
    private String path;
    private int index;
    private String[] sheetNames;
    private PoiDynaMap[] dynaMaps;
    private PoiPrintConfig[] printConfigs;
    public int debugCount = 0;
    public static boolean debugOut = false;
    private PoiProgressMonitor monitor = null;

    private PoiDynaSheet() {
    }

    public PoiDynaSheet(String path, int index) {
        this.path = path;
        this.index = index;
        this.sheetNames = new String[0];
        this.dynaMaps = new PoiDynaMap[0];
        this.printConfigs = new PoiPrintConfig[0];
        this.monitor = null;
    }

    public PoiDynaSheet(String path, int index, PoiProgressMonitor monitor) {
        this.path = path;
        this.index = index;
        this.sheetNames = new String[0];
        this.dynaMaps = new PoiDynaMap[0];
        this.printConfigs = new PoiPrintConfig[0];
        this.monitor = monitor;
    }

    private void debugOutSheet(PoiWorkbook pWorkbook) {
        if (debugOut) {
            ++this.debugCount;
            String postfix = this.debugCounter(this.debugCount);
            try {
                pWorkbook.save(this.path + "." + "DEBUG" + postfix + ".xls");
            }
            catch (PoiIOException e) {
                e.printStackTrace();
            }
            this.log.trace((Object)("................................................................ \u30c7\u30d0\u30c3\u30b0\u7528\u51fa\u529b\u3092\u884c\u3044\u307e\u3057\u305f[" + postfix + "]"));
        }
    }

    private String debugCounter(int count) {
        String render = String.valueOf(count);
        while (render.length() < 4) {
            render = "0" + render;
        }
        return render;
    }

    private void setMonitorMessage(String message) {
        if (this.monitor != null) {
            this.monitor.setMessage(message);
        }
    }

    public void addDynaSheet(String sheetName, PoiDynaMap dynaMap) throws PoiException {
        if (sheetName == null || sheetName.length() == 0) {
            throw new PoiException("\u6307\u5b9a\u3059\u308b\u30b7\u30fc\u30c8\u540d\u306b1\u6587\u5b57\u4ee5\u4e0b\u306e\u6587\u5b57\u5217\u307e\u305f\u306fnull\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        for (int i = 0; i <= this.sheetNames.length - 1; ++i) {
            if (!sheetName.equals(this.sheetNames[i])) continue;
            throw new PoiException("\u65e2\u306b\u5b58\u5728\u3059\u308b\u30b7\u30fc\u30c8\u540d[" + sheetName + "]\u3067\u30b7\u30fc\u30c8\u3092\u8ffd\u52a0\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        LinkedList<String> sheetNameList = new LinkedList<String>(Arrays.asList(this.sheetNames));
        sheetNameList.add(sheetName);
        this.sheetNames = sheetNameList.toArray(new String[sheetNameList.size()]);
        LinkedList<PoiDynaMap> dynaMapList = new LinkedList<PoiDynaMap>(Arrays.asList(this.dynaMaps));
        dynaMapList.add(dynaMap);
        this.dynaMaps = dynaMapList.toArray(new PoiDynaMap[dynaMapList.size()]);
        LinkedList<PoiPrintConfig> printConfigList = new LinkedList<PoiPrintConfig>(Arrays.asList(this.printConfigs));
        printConfigList.add(null);
        this.printConfigs = printConfigList.toArray(new PoiPrintConfig[printConfigList.size()]);
    }

    public void addDynaSheet(String sheetName, PoiDynaMap dynaMap, PoiPrintConfig printConfig) throws PoiException {
        if (sheetName == null || sheetName.length() == 0) {
            throw new PoiException("\u6307\u5b9a\u3059\u308b\u30b7\u30fc\u30c8\u540d\u306b1\u6587\u5b57\u4ee5\u4e0b\u306e\u6587\u5b57\u5217\u307e\u305f\u306fnull\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        for (int i = 0; i <= this.sheetNames.length - 1; ++i) {
            if (!sheetName.equals(this.sheetNames[i])) continue;
            throw new PoiException("\u65e2\u306b\u5b58\u5728\u3059\u308b\u30b7\u30fc\u30c8\u540d[" + sheetName + "]\u3067\u30b7\u30fc\u30c8\u3092\u8ffd\u52a0\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        LinkedList<String> sheetNameList = new LinkedList<String>(Arrays.asList(this.sheetNames));
        sheetNameList.add(sheetName);
        this.sheetNames = sheetNameList.toArray(new String[sheetNameList.size()]);
        LinkedList<PoiDynaMap> dynaMapList = new LinkedList<PoiDynaMap>(Arrays.asList(this.dynaMaps));
        dynaMapList.add(dynaMap);
        this.dynaMaps = dynaMapList.toArray(new PoiDynaMap[dynaMapList.size()]);
        LinkedList<PoiPrintConfig> printConfigList = new LinkedList<PoiPrintConfig>(Arrays.asList(this.printConfigs));
        printConfigList.add(printConfig);
        this.printConfigs = printConfigList.toArray(new PoiPrintConfig[printConfigList.size()]);
    }

    private PoiWorkbook createWorkbookManager() throws PoiException, PoiIOException {
        try {
            int i;
            this.setMonitorMessage("\u5e33\u7968\u51fa\u529b\u6e96\u5099\u3092\u958b\u59cb\u3057\u307e\u3059");
            HSSFWorkbook workbook = new HSSFWorkbook(new POIFSFileSystem((InputStream)new FileInputStream(new File(this.path))));
            if (workbook.getNumberOfSheets() - 1 < this.index) {
                throw new PoiException("\u6307\u5b9a\u3055\u308c\u305f\u30b7\u30fc\u30c8\u30a4\u30f3\u30c7\u30c3\u30af\u30b9[" + this.index + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            workbook.cloneSheet(this.index);
            int sheetCount = workbook.getNumberOfSheets();
            for (i = 0; i <= sheetCount - 2; ++i) {
                workbook.removeSheetAt(0);
            }
            for (i = 1; i <= this.sheetNames.length - 1; ++i) {
                workbook.cloneSheet(0);
            }
            for (i = 0; i <= workbook.getNumberOfSheets() - 1; ++i) {
                workbook.getSheetAt(i).setSelected(false);
            }
            workbook.getSheetAt(0).setSelected(true);
            this.log.trace((Object)("******** \u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u7528\u306e\u30ef\u30fc\u30af\u30d6\u30c3\u30af\u30b7\u30fc\u30c8\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f[" + this.path + ":" + this.index + "]"));
            return new PoiWorkbook(workbook);
        }
        catch (FileNotFoundException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u304b\u3001\u4ed6\u306e\u30d7\u30ed\u30bb\u30b9\u3067\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059", e);
        }
        catch (IOException e) {
            throw new PoiIOException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u3092\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    private PoiWorkbook createDynaValuedWorkbookManager() throws PoiException, PoiIOException {
        PoiWorkbook pWorkbook = this.createWorkbookManager();
        if (this.sheetNames.length == 0) {
            throw new PoiException("\u52d5\u7684\u51fa\u529b\u5bfe\u8c61\u306e\u30b7\u30fc\u30c8\u60c5\u5831\u304c1\u3064\u3082\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        for (int i = 0; i <= this.sheetNames.length - 1; ++i) {
            PoiSheet pSheet = pWorkbook.getPoiSheet(i);
            pSheet.setSheetName(this.sheetNames[i]);
            if (this.printConfigs[i] != null) {
                pSheet.applyPrintConfig(this.printConfigs[i]);
            }
            for (int j = 0; j <= pSheet.getLastRowNum(); ++j) {
                this.log.trace((Object)("---------------- " + j + "\u884c\u76ee\u306e\u52d5\u7684\u5024\u30bb\u30c3\u30c8\u30e1\u30a4\u30f3\u30eb\u30fc\u30d7\u3092\u958b\u59cb\u3057\u307e\u3059"));
                PoiRow pRow = pSheet.getPoiRow(j);
                PoiCell headPCell = pRow == null ? null : pRow.getPoiCell((short)0);
                int returnRow = -1;
                if (PoiDynaUtil.isDynaCell(headPCell) && (PoiDynaUtil.isDynaListStart(headPCell) || PoiDynaUtil.isDynaListEnd(headPCell))) {
                    if (PoiDynaUtil.isDynaListEnd(headPCell)) {
                        throw new PoiException("\u30ea\u30b9\u30c8\u958b\u59cb\u6307\u793a\u30ad\u30fc\u3088\u308a\u5148\u306b\u30ea\u30b9\u30c8\u7d42\u4e86\u30ad\u30fc\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    int endListRow = this.getDynaListEndIdentifierRowNum(pWorkbook, pSheet, headPCell);
                    if (endListRow == -1) {
                        throw new PoiException("\u30ea\u30b9\u30c8\u958b\u59cb\u6307\u793a\u30ad\u30fc[" + PoiDynaUtil.getDynaKey(headPCell) + "]\u306b\u5bfe\u5fdc\u3059\u308b\u7d42\u4e86\u6307\u793a\u30ad\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                    }
                    this.log.trace((Object)("\u30ea\u30b9\u30c8\u958b\u59cb\u6307\u793a\u30ad\u30fc\u3092\u53d6\u5f97[\u884c(" + PoiDynaUtil.getDynaKey(headPCell) + ") : " + j + "-" + endListRow + "]"));
                    returnRow = this.setDynaList(pWorkbook, pSheet, this.dynaMaps[i], PoiDynaUtil.getDynaKey(headPCell), PoiDynaUtil.getDynaComment(headPCell), j, endListRow, null);
                } else {
                    returnRow = this.setDynaValues(pWorkbook, pSheet, pRow, this.dynaMaps[i]);
                }
                int adjustJ = returnRow >= 0 ? returnRow : j;
                this.log.trace((Object)("---------------- " + j + "\u884c\u76ee\u306e\u52d5\u7684\u5024\u30bb\u30c3\u30c8\u30e1\u30a4\u30f3\u30eb\u30fc\u30d7\u3092\u7d42\u4e86\u3057\u307e\u3059 / \u51e6\u7406\u5fa9\u5143\u5f8c\u6b21\u884c\u756a\u53f7 = " + (adjustJ + 1)));
                this.debugOutSheet(pWorkbook);
                j = adjustJ;
            }
        }
        return pWorkbook;
    }

    private int getDynaListEndIdentifierRowNum(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiCell pCell) throws PoiException {
        int endListRow = -1;
        String listKey = PoiDynaUtil.getDynaKey(pCell);
        this.log.trace((Object)("\u30ea\u30b9\u30c8\u7e70\u308a\u8fd4\u3057\u7d42\u4e86\u884c\u3092\u691c\u7d22\u3057\u307e\u3059[" + listKey + "] : \u691c\u7d22\u958b\u59cb\u884c\u306f" + pCell.getRowNum() + "\u3067\u3059"));
        for (int j = pCell.getRowNum() + 1; j <= pSheet.getLastRowNum(); ++j) {
            PoiRow checkPRow = pSheet.getPoiRow(j);
            PoiCell checkHeadPCell = checkPRow.getPoiCell((short)0);
            if (!PoiDynaUtil.isDynaCell(checkHeadPCell) || !PoiDynaUtil.isDynaListEnd(checkHeadPCell) || !listKey.equals(PoiDynaUtil.getDynaKey(checkHeadPCell))) continue;
            endListRow = j;
            break;
        }
        return endListRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiCell pCell, PoiDynaMap dynaMap, PoiRange range) throws PoiException {
        int returnRow;
        int n = returnRow = pCell == null ? -1 : pCell.getRowNum();
        if (pCell == null) {
            this.log.trace((Object)"\u30bb\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304cnull\u306e\u70ba\u51e6\u7406\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059");
            return returnRow;
        } else if (PoiDynaUtil.isDynaListStart(pCell)) {
            if (pCell.getColNum() != 0) throw new PoiException("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u30ea\u30b9\u30c8\u30c7\u30fc\u30bf\u6307\u793a\u30ad\u30fc\u306f\u5148\u982d\u30bb\u30eb\u306e\u307f\u5b9a\u7fa9\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u3059");
            int innerListStartRow = pCell.getRowNum();
            int innerListEndRow = this.getDynaListEndIdentifierRowNum(pWorkbook, pSheet, pCell);
            String innerListKey = PoiDynaUtil.getDynaKey(pCell);
            String innerListComment = PoiDynaUtil.getDynaComment(pCell);
            this.log.trace((Object)("---- \u968e\u5c64\u69cb\u9020\u306e\u30ea\u30b9\u30c8\u6307\u793a\u30ad\u30fc\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f : " + innerListKey + "[" + innerListStartRow + "-" + innerListEndRow + "]"));
            PoiDynaList list = dynaMap.getDynaList(innerListKey);
            returnRow = this.setDynaList(pWorkbook, pSheet, dynaMap, innerListKey, innerListComment, innerListStartRow, innerListEndRow, range);
            this.log.trace((Object)("---- \u968e\u5c64\u69cb\u9020\u306e\u30ea\u30b9\u30c8\u306e\u8a2d\u5b9a\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f : " + innerListKey + " \u51e6\u7406\u5fa9\u5e30\u884c\u756a\u53f7 = " + returnRow));
            return returnRow;
        } else {
            if (PoiDynaUtil.isDynaListEnd(pCell)) {
                throw new PoiException("\u30ea\u30b9\u30c8\u958b\u59cb\u6307\u793a\u30ad\u30fc\u3088\u308a\u5148\u306b\u30ea\u30b9\u30c8\u7d42\u4e86\u30ad\u30fc\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            String key = PoiDynaUtil.getDynaKey(pCell);
            String comment = PoiDynaUtil.getDynaComment(pCell);
            if (dynaMap != null) {
                if (!dynaMap.containsKey(key)) {
                    this.log.warn((Object)("PoiDynaMap\u306f\u6b21\u306e\u30ad\u30fc\u3092\u4fdd\u6301\u3057\u3066\u3044\u307e\u305b\u3093 : \"" + key + "\""));
                    pCell.setValue(new PoiValue(""));
                    return returnRow;
                } else {
                    if (dynaMap.isDynaList(key)) {
                        throw new PoiException("\u5358\u4e00\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u3042\u308b\u3079\u304d\u52d5\u7684\u30bb\u30eb\u30ad\u30fc[" + key + "]\u306b\u30ea\u30b9\u30c8\u30c7\u30fc\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    PoiValue value = dynaMap.getDynaValue(key);
                    this.log.trace((Object)("\u52d5\u7684\u5024\u8a2d\u5b9a(" + this.debugCounter(pCell.getRowNum()) + "\u884c\u76ee) : \"" + key + "(" + comment + ")\" = " + value));
                    pCell.setValue(value);
                }
                return returnRow;
            } else {
                this.log.warn((Object)("PoiDynaMap\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304cnull\u3067\u3059 : \"" + key + "\""));
                pCell.setValue(new PoiValue(""));
            }
        }
        return returnRow;
    }

    private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRow pRow, PoiDynaMap dynaMap) throws PoiException {
        int returnRow;
        int n = returnRow = pRow == null ? -1 : pRow.getRowNum();
        if (pRow == null) {
            return returnRow;
        }
        for (short j = 0; j <= pRow.getLastColNum(); j = (short)(j + 1)) {
            PoiCell pCell = pRow.getPoiCell(j);
            if (!PoiDynaUtil.isDynaCell(pCell)) continue;
            returnRow = this.setDynaValues(pWorkbook, pSheet, pCell, dynaMap, null);
        }
        return returnRow;
    }

    private int setDynaValues(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiRange range, PoiDynaMap dynaMap) throws PoiException {
        int returnRow = -1;
        for (int i = range.getRowFrom(); i <= range.getRowTo(); ++i) {
            for (short j = range.getColFrom(); j <= range.getColTo(); j = (short)(j + 1)) {
                PoiCell pCell = pSheet.getPoiCell(i, j);
                if (!PoiDynaUtil.isDynaCell(pCell) || (returnRow = this.setDynaValues(pWorkbook, pSheet, pCell, dynaMap, range)) < 0) continue;
                i = returnRow;
            }
        }
        return returnRow;
    }

    private int setDynaList(PoiWorkbook pWorkbook, PoiSheet pSheet, PoiDynaMap dynaMap, String key, String comment, int startRow, int endRow, PoiRange adjustRange) throws PoiException {
        this.log.trace((Object)("-------- [" + this.debugCounter(startRow) + "\u884c\u76ee] \u52d5\u7684\u30ea\u30b9\u30c8\u8a2d\u5b9a\u51e6\u7406\u958b\u59cb"));
        int adjustRow = 0;
        pSheet.deleteRow(endRow);
        pSheet.deleteRow(startRow);
        int setRows = endRow - startRow + 1 - 2;
        int listSize = 0;
        this.log.trace((Object)("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u9664\u304f\u30ea\u30b9\u30c8\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u884c\u30b5\u30a4\u30ba\u306f" + setRows + "\u3067\u3059"));
        if (adjustRange != null) {
            this.log.trace((Object)("\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u8b58\u5225\u5b50\u884c\u5206\u7e2e\u5c0f = -2 / \u5909\u66f4\u524d : " + adjustRange));
            adjustRange.setRowTo(adjustRange.getRowTo() - 2);
            this.log.trace((Object)("\u5909\u66f4\u5f8c\u306e\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8 : " + adjustRange));
        }
        if (startRow + 1 == endRow) {
            this.log.warn((Object)"\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306b\u52d5\u7684\u5024\u5b9a\u7fa9\u304c1\u884c\u3082\u5b58\u5728\u3057\u306a\u3044\u30ea\u30b9\u30c8\u8b58\u5225\u5b50\u306e\u70ba\u3001\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059");
        } else {
            PoiRange range = new PoiRange(startRow, 0, endRow - 2, pSheet.getLastColNum());
            this.log.trace((Object)("\u30ea\u30b9\u30c8\u7e70\u308a\u66ff\u3048\u3057\u90e8\u30b3\u30d4\u30fc\u30ec\u30f3\u30b8[" + range.toString() + "]"));
            if (!dynaMap.containsKey(key)) {
                this.log.warn((Object)("\u52d5\u7684\u30de\u30c3\u30d7\u304c\u6b21\u306e\u30ad\u30fc\u3092\u4fdd\u6301\u3057\u307e\u305b\u3093 : \"" + key + "\""));
                for (int i = 0; i <= setRows - 1; ++i) {
                    pSheet.deleteRow(startRow);
                }
                if (adjustRange != null) {
                    this.log.trace((Object)("\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u5206\u7e2e\u5c0f = -" + setRows + " / \u5909\u66f4\u524d : " + adjustRange));
                    adjustRange.setRowTo(adjustRange.getRowTo() - setRows);
                    this.log.trace((Object)("\u5909\u66f4\u5f8c\u306e\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8 : " + adjustRange));
                }
            } else if (dynaMap.getDynaList(key) == null || dynaMap.getDynaList(key).size() == 0) {
                this.log.trace((Object)"\u30ea\u30b9\u30c8\u30b5\u30a4\u30ba\u306f0\u306e\u70ba\u3001\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u884c\u524a\u9664\u51e6\u7406\u306e\u307f\u884c\u3044\u307e\u3059");
                for (int i = 0; i <= setRows - 1; ++i) {
                    pSheet.deleteRow(startRow);
                }
                if (adjustRange != null) {
                    this.log.trace((Object)("\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u5206\u7e2e\u5c0f = -" + setRows + " / \u5909\u66f4\u524d : " + adjustRange));
                    adjustRange.setRowTo(adjustRange.getRowTo() - setRows);
                    this.log.trace((Object)("\u5909\u66f4\u5f8c\u306e\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8 : " + adjustRange));
                }
            } else {
                int i;
                listSize = dynaMap.getDynaList(key).size();
                this.log.trace((Object)("\u30bb\u30c3\u30c8\u30ea\u30b9\u30c8\u30b5\u30a4\u30ba\u306f" + listSize + "\u3067\u3059"));
                for (i = 0; i <= (listSize - 1) * setRows - 1; ++i) {
                    pSheet.insertRow(startRow + setRows);
                }
                for (i = 1; i <= listSize - 1; ++i) {
                    pSheet.copyPaste(range, startRow + i * setRows, (short)0);
                }
                if (adjustRange != null) {
                    this.log.trace((Object)("\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u30ea\u30b9\u30c8\u5206\u62e1\u5927 = +" + setRows * (listSize - 1) + " / \u5909\u66f4\u524d : " + adjustRange));
                    adjustRange.setRowTo(adjustRange.getRowTo() + setRows * (listSize - 1));
                    this.log.trace((Object)("\u5909\u66f4\u5f8c\u306e\u30ec\u30f3\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8 : " + adjustRange));
                }
                PoiRange setRange = new PoiRange(range);
                for (int i2 = 0; i2 <= listSize - 1; ++i2) {
                    this.setMonitorMessage(listSize + "\u4ef6\u4e2d" + (i2 + 1) + "\u4ef6\u76ee\u306e" + comment + "\u30ec\u30b3\u30fc\u30c9\u3092\u51e6\u7406\u4e2d\u3067\u3059");
                    this.log.trace((Object)("\u30ea\u30b9\u30c8\u30a4\u30f3\u30c7\u30c3\u30af\u30b9(=" + i2 + ")\u306e\u30ea\u30b9\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u307e\u3059[" + this.debugCounter(startRow) + "\u884c\u76ee\u306e\u51e6\u7406]"));
                    this.log.trace((Object)("\u6b21\u306e\u7bc4\u56f2\u306b\u5bfe\u3057\u3066\u51e6\u7406\u304c\u884c\u308f\u308c\u307e\u3059 : " + setRange));
                    this.debugOutSheet(pWorkbook);
                    if (i2 > 0) {
                        setRange.shift(setRows, (short)0);
                    }
                    int returnRow = this.setDynaValues(pWorkbook, pSheet, setRange, dynaMap.getDynaList(key).get(i2));
                }
                adjustRow += listSize * setRows;
            }
            this.log.trace((Object)("\u30ea\u30b9\u30c8\u30bb\u30c3\u30c8\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3001" + (startRow + adjustRow) + "\u884c\u76ee\u3088\u308a\u51e6\u7406\u3092\u7d9a\u884c\u3057\u307e\u3059"));
        }
        this.log.trace((Object)("-------- [" + this.debugCounter(startRow) + "\u884c\u76ee] \u52d5\u7684\u30ea\u30b9\u30c8\u8a2d\u5b9a\u51e6\u7406\u7d42\u4e86"));
        this.debugOutSheet(pWorkbook);
        return startRow + adjustRow - 1;
    }

    public void save(String path) throws PoiException, PoiIOException {
        this.log.trace((Object)("######## \u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9[" + path + "]\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u3092\u958b\u59cb\u3057\u307e\u3059"));
        PoiWorkbook pWorkbook = this.createDynaValuedWorkbookManager();
        this.log.trace((Object)("######## \u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9[" + path + "]\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f"));
        pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);
        pWorkbook.save(path);
        this.log.trace((Object)("######## \u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9[" + path + "]\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f"));
    }

    public void save(OutputStream os) throws PoiException, PoiIOException {
        this.log.trace((Object)"######## \u6307\u5b9a\u3055\u308c\u305fOutputStream\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u3092\u958b\u59cb\u3057\u307e\u3059");
        PoiWorkbook pWorkbook = this.createDynaValuedWorkbookManager();
        this.log.trace((Object)"######## \u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9OutputStream\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);
        pWorkbook.save(os);
        this.log.trace((Object)"######## \u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9OutputStream\u306b\u5bfe\u3057\u3066\u52d5\u7684\u306bExcel\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
    }

    public PoiWorkbook save() throws PoiException, PoiIOException {
        this.log.trace((Object)"######## PoiWorkbook\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u751f\u6210\u3092\u958b\u59cb\u3057\u307e\u3059");
        PoiWorkbook pWorkbook = this.createDynaValuedWorkbookManager();
        pWorkbook.setSelectedSheet(pWorkbook.getNumberOfSheets() - 1);
        this.log.trace((Object)"######## PoiWorkbook\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u751f\u6210\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        return pWorkbook;
    }
}

