/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.dyna;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.library.wpoi.adapter.PoiValue;
import org.phosphoresce.library.wpoi.dyna.PoiDynaList;

public final class PoiDynaMap {
    private Log log = LogFactory.getLog(this.getClass());
    private Map map;

    public PoiDynaMap() {
        this.map = new LinkedHashMap();
    }

    public PoiDynaMap(PoiDynaMap m) {
        this.map = new LinkedHashMap(m.map);
    }

    private PoiDynaMap(LinkedHashMap map) {
        this.map = map;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(PoiValue value) {
        return this.map.containsValue(value);
    }

    public boolean containsValue(PoiDynaList value) {
        return this.map.containsValue(value);
    }

    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    public PoiValue getDynaValue(String key) {
        return (PoiValue)this.map.get(key);
    }

    public PoiDynaList getDynaList(String key) {
        return (PoiDynaList)this.map.get(key);
    }

    public boolean isDynaValue(String key) {
        return this.map.get(key) instanceof PoiValue;
    }

    public boolean isDynaList(String key) {
        return this.map.get(key) instanceof PoiDynaList;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Object put(String key, PoiValue value) {
        return this.map.put(key, value);
    }

    public Object put(String key, PoiDynaList value) {
        return this.map.put(key, value);
    }

    public void putAll(PoiDynaMap t) {
        this.map.putAll(t.map);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    final PoiDynaMap getNestedDynaMap(String parentBeanName) {
        LinkedHashMap render = new LinkedHashMap();
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object object = this.map.get(key);
            render.put(parentBeanName + "." + key, object);
        }
        return new PoiDynaMap(render);
    }
}

