/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.library.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.phosphoresce.library.wpoi.adapter.PoiCell;
import org.phosphoresce.library.wpoi.adapter.PoiSheet;
import org.phosphoresce.library.wpoi.adapter.PoiWorkbook;
import org.phosphoresce.library.wpoi.exception.PoiException;

public final class PoiRow {
    private Log log = LogFactory.getLog(this.getClass());
    private PoiWorkbook pWorkbook;
    private PoiSheet pSheet;
    private HSSFRow hssfRow;

    private PoiRow() {
    }

    protected PoiRow(PoiWorkbook pWorkbook, PoiSheet pSheet, HSSFRow hssfRow) {
        this.pWorkbook = pWorkbook;
        this.pSheet = pSheet;
        this.hssfRow = hssfRow;
    }

    protected HSSFRow getHssfRow() {
        return this.hssfRow;
    }

    public PoiCell getPoiCell(short col, boolean fourceInstance) {
        if (this.hssfRow == null) {
            return null;
        }
        if (this.hssfRow.getCell(col) == null) {
            if (fourceInstance) {
                return new PoiCell(this.pWorkbook, this.pSheet, this, this.hssfRow.createCell(col));
            }
            return null;
        }
        return new PoiCell(this.pWorkbook, this.pSheet, this, this.hssfRow.getCell(col));
    }

    public PoiCell getPoiCell(short col) {
        return this.getPoiCell(col, false);
    }

    public short getLastColNum() {
        if (this.hssfRow == null) {
            return -1;
        }
        return this.hssfRow.getLastCellNum();
    }

    public int getRowNum() throws PoiException {
        if (this.hssfRow == null) {
            return -1;
        }
        for (int i = 0; i <= this.pSheet.getLastRowNum(); ++i) {
            if (!this.hssfRow.equals((Object)this.pSheet.getPoiRow(i, true).getHssfRow())) continue;
            return i;
        }
        return -1;
    }
}

