package org.phosphoresce.commons.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

import org.phosphoresce.commons.util.ExceptionUtil;

/**
 * OvIuWFNgێ郉^COgNXB<br>
 * Java 2 SDK 1.4胋[gP[Xg[X悤ɂȂA
 * ȑOJDK̏ꍇA܂1.4ɂmore...ڍׂȃ[gP[X
 * g[Xꍇɂ͓NXʃNXƂėONX݂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/05/17	Kitagawa		VK쐬
 *-->
 */
public abstract class RootHoldingRuntimeException extends RuntimeException {

	/** [gP[XOIuWFNg */
	private Throwable parent = null;

	/**
	 * RXgN^<br>
	 */
	public RootHoldingRuntimeException() {
		//
	}

	/**
	 * RXgN^<br>
	 * @param cause [gP[XOIuWFNg
	 */
	public RootHoldingRuntimeException(Throwable cause) {
		super(cause);
		this.parent = cause;
	}

	/**
	 * RXgN^<br>
	 * @param message bZ[W
	 * @param cause [gP[XOIuWFNg
	 */
	public RootHoldingRuntimeException(String message, Throwable cause) {
		super(message, cause);
		this.parent = cause;
	}

	/**
	 * RXgN^<br>
	 * @param message bZ[W
	 */
	public RootHoldingRuntimeException(String message) {
		super(message);
	}

	/**
	 * [gP[XOێ邩肵܂B<br>
	 * @return [gP[XOێꍇtrueԋp
	 */
	public final boolean hasParent() {
		return parent != null;
	}

	/**
	 * [gP[XOIuWFNg擾܂B<br>
	 * @return [gP[XOIuWFNgԋp܂B
	 */
	public final Throwable getParent() {
		return parent;
	}

	/**
	 * X^bNg[XStringIuWFNgƂĎ擾܂B<br>
	 * @return X^bNg[X
	 */
	public String getStackTraceValue() {
		return ExceptionUtil.getStackTraceValue(this);
	}

	/**
	 * W̏o͐ɑ΂ăX^bNg[Xo͂܂B<br>
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace() {
		super.printStackTrace();
		if (hasParent()) {
			parent.printStackTrace();
		}
	}

	/**
	 * w肳ꂽPrintStreamIuWFNgɑ΂ăX^bNg[Xo͂܂B<br>
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream stream) {
		super.printStackTrace(stream);
		if (hasParent()) {
			parent.printStackTrace(stream);
		}
	}

	/**
	 * w肳ꂽPrintWriterIuWFNgɑ΂ăX^bNg[Xo͂܂B<br>
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter writer) {
		super.printStackTrace(writer);
		if (hasParent()) {
			parent.printStackTrace(writer);
		}
	}
}
