package org.phosphoresce.commons.csv;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/**
 * CSVR[hSێ郊XgNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/16	Kitagawa		VK쐬
 *-->
 */
public final class CSVRecordList implements Serializable {

	/** CSVR[hXg */
	private List list = null;

	/**
	 * RXgN^<br>
	 */
	public CSVRecordList() {
		super();
		this.list = new LinkedList();
	}

	/**
	 * RXgN^<br>
	 * @param list CSVR[hXgIuWFNg
	 */
	public CSVRecordList(CSVRecordList list) {
		super();
		this.list = new LinkedList(list.list);
	}

	/**
	 * CSVR[hXgł邩肵܂B<br>
	 * @return CSVR[hXgłꍇtrueԋp
	 */
	public boolean isEmpty() {
		return list.isEmpty();
	}

	/**
	 * w肳ꂽCSVR[hXgێĂ邩肵܂B<br>
	 * @param record ΏCSVR[h
	 * @return XgCSVR[hێĂꍇtrueԋp
	 */
	public boolean contains(CSVRecord record) {
		return this.list.contains(record);
	}

	/**
	 * w肳ꂽCSVR[hXgeSĕێĂ邩肵܂B<br>
	 * @param list ΏCSVR[hXg
	 * @return w肳ꂽCSVR[hXgeSĕێĂꍇtrueԋp
	 */
	public boolean containsAll(CSVRecordList list) {
		return this.list.containsAll(list.list);
	}

	/**
	 * CSVR[hXgCe[^擾܂B<br>
	 * @return CSVR[hXgCe[^
	 */
	public Iterator iterator() {
		return list.iterator();
	}

	/**
	 * ێĂCSVR[hzƂĎ擾܂B<br>
	 * @return CSVR[hz
	 */
	public CSVRecord[] toArray() {
		return (CSVRecord[]) list.toArray(new CSVRecord[list.size()]);
	}

	/**
	 * w肳ꂽCSVR[hXgSĒǉ܂B<br>
	 * @param list ǉΏCSVR[hXg
	 * @return ǉ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean addAll(CSVRecordList list) {
		return this.list.addAll(list.list);
	}

	/**
	 * w肳ꂽCSVR[hXgwʒuɑSĒǉ܂B<br>
	 * @param index ǉʒuCfbNX
	 * @param list ǉΏCSVR[hXg
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean addAll(int index, CSVRecordList list) {
		expand(index);
		return this.list.addAll(index, list.list);
	}

	/**
	 * w肳ꂽCSVR[hXgXgɊi[Ăvf݂̂căXgҏW܂B<br>
	 * @param list ێΏۂCSVR[hXgێ郊XgIuWFNg
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean retainAll(CSVRecordList list) {
		return this.list.retainAll(list.list);
	}

	/**
	 * ێĂCSVR[hSč폜܂B<br>
	 */
	public void clear() {
		this.list.clear();
	}

	/**
	 * ێĂCSVR[h擾܂B<br>
	 * @return ێĂCSVR[h
	 */
	public int size() {
		return list.size();
	}

	/**
	 * w肳ꂽTCY܂Ńg[NXgTCYg܂B<br>
	 * @param size g̃TCY
	 */
	public void expand(int size) {
		int listSize = list.size();
		for (int i = 0; i <= size - listSize; i++) {
			list.add(new CSVRecord());
		}
	}

	/**
	 * w肳ꂽCSVR[hǉ܂B<br>
	 * @param record CSVR[h
	 */
	public void add(CSVRecord record) {
		this.list.add(record);
	}

	/**
	 * w肳ꂽCfbNXʒuCSVR[hǉ܂B<br>
	 * @param index ǉʒuCfbNX
	 * @param record ǉΏCSVR[h
	 */
	public void add(int index, CSVRecord record) {
		expand(index);
		this.list.add(index, record);
	}

	/**
	 * w肳ꂽCfbNXCSVR[h擾܂B<br>
	 * @param index 擾ΏۃCfbNX
	 * @return CSVR[h
	 */
	public CSVRecord get(int index) {
		expand(index + 1);
		return (CSVRecord) list.get(index);
	}

	/**
	 * w肳ꂽCfbNXɑ΂CSVR[hݒ肵܂B<br>
	 * @param index CfbNX
	 * @param record CSVR[h
	 * @return ݒ菈OɕێĂCSVR[h
	 */
	public CSVRecord set(int index, CSVRecord record) {
		expand(index + 1);
		return (CSVRecord) this.list.set(index, record);
	}

	/**
	 * w肳ꂽCSVR[hXg폜܂B<br>
	 * @param record 폜ΏCSVR[h
	 * @return w肳ꂽCSVR[hێĂꍇtrueԋp
	 */
	public boolean remove(CSVRecord record) {
		return this.list.remove(record);
	}

	/**
	 * w肳ꂽCfbNXCSVR[h폜܂B<br>
	 * @param index R[hXgCfbNX
	 * @return w肳ꂽCfbNXɑ݂CSVR[h
	 */
	public CSVRecord remove(int index) {
		expand(index + 1);
		return (CSVRecord) list.remove(index);
	}

	/**
	 * w肳ꂽCSVR[hXgɊi[Ă邷ׂĂ̗vfXg폜܂B<br>
	 * @param list 폜ΏۂCSVR[hێ郊XgIuWFNg
	 * @return ̌ʁAXgeύXꂽꍇtrueԋp
	 */
	public boolean removeAll(CSVRecordList list) {
		return this.list.removeAll(list.list);
	}

	/**
	 * w肳ꂽCSVR[hʒu擾܂B<br>
	 * @param record ʒu擾ΏCSVR[h
	 * @return w肳ꂽvfXgōŏɌoꂽʒũCfbNXBXgɂ̗vfȂꍇ-1ԋpB
	 */
	public int indexOf(CSVRecord record) {
		return this.list.indexOf(record);
	}

	/**
	 * w肳ꂽCSVR[h̍ŏIoʒu擾܂B<br>
	 * @param record ʒu擾ΏCSVR[h
	 * @return w肳ꂽvfXgōŌɌoꂽʒũCfbNXBXgɂ̗vfȂꍇ-1ԋpB
	 */
	public int lastIndexOf(CSVRecord record) {
		return this.list.lastIndexOf(record);
	}

	/**
	 * CSVR[hXg̗vfK؂ȏŌJԂ锽q擾܂B<br>
	 * @return  CSVR[hXg̗vfK؂ȏŌJԂ锽q
	 */
	public ListIterator listIterator() {
		return list.listIterator();
	}

	/**
	 * Xg̗vfK؂ȏŌJԂAXg̎w肳ꂽʒuJn锽q擾܂B<br>
	 * @param index next\bȟĂяoɂăXgqԂŏ̗vf̃CfbNX
	 * @return  CSVR[hXg̗vfK؂ȏŌJԂ锽q
	 */
	public ListIterator listIterator(int index) {
		expand(index);
		return list.listIterator(index);
	}

	/**
	 * w肳ꂽCfbNX͈͂CSVR[hXg擾܂B<br>
	 * @param fromIndex JnCfbNX
	 * @param toIndex ICfbNX
	 * @return w͈͂CSVR[hXg
	 */
	public CSVRecordList subList(int fromIndex, int toIndex) {
		expand(fromIndex);
		expand(toIndex);
		List record = this.list.subList(fromIndex, toIndex);
		CSVRecordList result = new CSVRecordList();
		for (Iterator iterator = record.iterator(); iterator.hasNext();) {
			result.add((CSVRecord) iterator.next());
		}
		return result;
	}
}
