package org.phosphoresce.contentnotifier.util;

import java.util.Date;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import org.phosphoresce.contentnotifier.exception.MailSendingException;
import org.phosphoresce.contentnotifier.setting.MailSetting;

/**
 * [񋟂郆[eBeBNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public final class MailUtil {

	/** JavaMailϐL[ : SMTPT[o */
	public static final String PROPERTIES_MAIL_SMTP = "mail.smtp.host";

	/**
	 * RXgN^<br>
	 */
	private MailUtil() {
		//
	}

	/**
	 * w肳ꂽMailSettingIuWFNgɃ[𑗐M܂B<br>
	 * @param setting MailSettingIuWFNg
	 * @throws MailSendingException Ƀ[MsȂꍇɔ
	 */
	public static void send(MailSetting setting) throws MailSendingException {
		try {
			// SMTPT[oݒ
			Properties props = new Properties();
			props.put(PROPERTIES_MAIL_SMTP, setting.getMailSmtp());

			// [ZbVIuWFNgݒ
			Session session = Session.getInstance(props, null);

			// [MfobO[hݒ
			session.setDebug(setting.isMailDebug());

			// bZ[WIuWFNg
			MimeMessage message = new MimeMessage(session);

			// MAhXݒ
			{
				InternetAddress[] address = new InternetAddress[setting.getMailAddressTo().length];
				for (int i = 0; i <= setting.getMailAddressTo().length - 1; i++) {
					address[i] = new InternetAddress(setting.getMailAddressTo()[i]);
				}
				message.setRecipients(Message.RecipientType.TO, address);
			}

			// MAhXݒ
			{
				message.setFrom(new InternetAddress(setting.getMailAddressFrom()));
			}

			// \ݒ
			{
				message.setSubject(setting.getMailSubject(), setting.getMailCharset());
			}

			// Mtݒ
			{
				message.setSentDate(new Date());
			}

			// [RecMultiPartIuWFNg
			Multipart multiPart = new MimeMultipart();

			// [{ݒ
			{
				MimeBodyPart part = new MimeBodyPart();
				part.setText(setting.getMailTemplate(), setting.getMailCharset());
				multiPart.addBodyPart(part);
			}

			// Ytt@Cݒ
			if (setting.getMailAttach() != null) {
				for (int i = 0; i <= setting.getMailAttach().length - 1; i++) {
					MimeBodyPart part = new MimeBodyPart();
					FileDataSource data = new FileDataSource(setting.getMailAttach()[i]);
					part.setDataHandler(new DataHandler(data));
					part.setFileName(MimeUtility.encodeWord(data.getName()));
					multiPart.addBodyPart(part);
				}
			}

			// bZ[WIuWFNgɑ΂ăRecIuWFNgݒ
			message.setContent(multiPart);

			// [M
			Transport.send(message);
		} catch (Exception e) {
			throw new MailSendingException("[MɗO܂", e);
		}
	}
}
