package org.phosphoresce.contentnotifier.strategy;

import java.io.BufferedReader;
import java.io.FileReader;

import org.phosphoresce.contentnotifier.exception.ContentCheckException;
import org.phosphoresce.contentnotifier.exception.PropertiesLoadException;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;

/**
 * w肳ꂽt@Cɓ̕񂪊܂܂ĂꍇɒʒmNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public class ContentStringCheckStrategy implements CheckStrategy {

	/** `FbNΏۃt@C */
	private String checkFile;

	/** `FbN */
	private String checkString;

	/**
	 * RXgN^<br>
	 * @param properties vpeBt@C
	 * @throws PropertiesLoadException ɃvpeBt@Cǂݍ߂Ȃꍇɔ
	 */
	public ContentStringCheckStrategy(String properties) throws PropertiesLoadException {
		this.checkFile = PropertiesUtil.getValue(properties, "check.file");
		this.checkString = PropertiesUtil.getValue(properties, "check.string");
	}

	/**
	 * w肳ꂽt@CɎw肳ꂽ񂪊܂܂ꍇfalseԋp܂B<br>
	 * @return w肳ꂽt@CɎw肳ꂽ񂪊܂܂ꍇfalseԋp
	 * @throws ContentCheckException `FbNɗ\ʗOꍇɃX[܂
	 * @see org.phosphoresce.contentnotifier.strategy.CheckStrategy#check()
	 */
	public boolean check() throws ContentCheckException {
		try {
			BufferedReader reader = new BufferedReader(new FileReader(checkFile));
			while (reader.ready()) {
				String line = reader.readLine();
				if (line.indexOf(checkString) > 0) {
					return false;
				}
			}
			reader.close();
			return true;
		} catch (Exception e) {
			throw new ContentCheckException("`FbNɗ\ʗO܂", e);
		}
	}
}
