package org.phosphoresce.contentnotifier.setting;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.contentnotifier.ContentNotifierConstants;
import org.phosphoresce.contentnotifier.exception.IllegalSettingException;
import org.phosphoresce.contentnotifier.strategy.CheckStrategy;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;
import org.phosphoresce.contentnotifier.util.StringUtil;

/**
 * ʒmێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public final class NotifySetting implements ContentNotifierConstants {

	/** t */
	private Date date;

	/**  */
	private String name;

	/** G[̃[\ */
	private String onerrorSubject;

	/** G[̃[MAhX */
	private String onerrorAddressFrom;

	/** G[̃[MAhX */
	private String[] onerrorAddressTo;

	/** G[̃[MtO */
	private boolean onerrorCall;

	/** G[̃X^bNg[Xo̓tO */
	private boolean onerrorStacktrace;

	/** G[̏o̓Ot@CpX */
	private String onerrorLogfile;

	/** G[̃bZ[W */
	private String onerrorMessage;

	/** [ݒ */
	private MailSetting mailSetting;

	/** `FbNNX */
	private CheckStrategy checkStrategy;

	/**
	 * RXgN^<br>
	 */
	public NotifySetting() {
		this.date = new Date();
	}

	/**
	 * RXgN^<br>
	 * @param properties vpeBt@C
	 * @throws IllegalSettingException ɒʒmݒ肪łȂꍇɔ
	 */
	public NotifySetting(String properties) throws IllegalSettingException {
		try {
			this.date = new Date();
			this.name = PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_NAME);
			this.onerrorSubject = PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_SUBJECT);
			this.onerrorAddressFrom = PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_ADDRESS_FROM);
			this.onerrorAddressTo = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_ADDRESS_TO), PROPERTY_DELIM);
			this.onerrorCall = Boolean.valueOf(PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_CALL)).booleanValue();
			this.onerrorStacktrace = Boolean.valueOf(PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_STACKTRACE)).booleanValue();
			this.onerrorLogfile = PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_LOGFILE);
			this.onerrorMessage = PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_ONERROR_MESSAGE);
			this.mailSetting = new MailSetting(PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_MAIL_PROPERTIES));
			this.checkStrategy = (CheckStrategy) Class.forName(PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_CHECK_STRATEGY)).getConstructor(new Class[] { String.class })
					.newInstance(new Object[] { PropertiesUtil.getValue(properties, PROPERTY_NOTIFY_CHECK_STRATEGY_PROPERTIES) });
		} catch (Exception e) {
			throw new IllegalSettingException("ʒmݒ񂪐ɏ܂ł", e);
		}
	}

	/**
	 * w肳ꂽɑ΂ĊeoChĒ񋟂܂B<br>
	 * @param value oChΏە
	 * @return eoCh
	 */
	private String renderBindedString(String value) {
		String buffer = value;
		buffer = StringUtil.binder(buffer, "timestamp", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date));
		buffer = StringUtil.binder(buffer, "date", new SimpleDateFormat("yyyy/MM/dd").format(date));
		buffer = StringUtil.binder(buffer, "time", new SimpleDateFormat("HH:mm:ss").format(date));
		buffer = StringUtil.binder(buffer, "name", name);
		buffer = StringUtil.binder(buffer, "logfile", onerrorLogfile);
		return buffer;
	}

	/**
	 * G[̏o̓Ot@CpX擾܂B<br>
	 * @return G[̏o̓Ot@CpX
	 */
	public String getOnerrorLogfile() {
		return onerrorLogfile;
	}

	/**
	 * G[̏o̓Ot@CpXݒ肵܂B<br>
	 * @param onerrorLogfile G[̏o̓Ot@CpX
	 */
	public void setOnerrorLogfile(String onerrorLogfile) {
		this.onerrorLogfile = onerrorLogfile;
	}

	/**
	 * t擾܂B<br>
	 * @return t
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * tݒ肵܂B<br>
	 * @param date t
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * G[̃[\擾܂B<br>
	 * @return G[̃[\
	 */
	public String getOnerrorSubject() {
		return renderBindedString(onerrorSubject);
	}

	/**
	 * G[̃[\ݒ肵܂B<br>
	 * @param onerrorSubject G[̃[\
	 */
	public void setOnerrorSubject(String onerrorSubject) {
		this.onerrorSubject = onerrorSubject;
	}

	/**
	 * `FbNNX擾܂B<br>
	 * @return `FbNNX
	 */
	public CheckStrategy getCheckStrategy() {
		return checkStrategy;
	}

	/**
	 * `FbNNXݒ肵܂B<br>
	 * @param checkStrategy `FbNNX
	 */
	public void setCheckStrategy(CheckStrategy checkStrategy) {
		this.checkStrategy = checkStrategy;
	}

	/**
	 * [ݒ擾܂B<br>
	 * @return [ݒ
	 */
	public MailSetting getMailSetting() {
		return mailSetting;
	}

	/**
	 * [ݒݒ肵܂B<br>
	 * @param mailSetting [ݒ
	 */
	public void setMailSetting(MailSetting mailSetting) {
		this.mailSetting = mailSetting;
	}

	/**
	 * ̂擾܂B<br>
	 * @return 
	 */
	public String getName() {
		return name;
	}

	/**
	 * ̂ݒ肵܂B<br>
	 * @param name 
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * G[̃[MAhX擾܂B<br>
	 * @return G[̃[MAhX
	 */
	public String[] getOnerrorAddressTo() {
		return onerrorAddressTo;
	}

	/**
	 * G[̃[MAhXݒ肵܂B<br>
	 * @param onerrorAddress G[̃[MAhX
	 */
	public void setOnerrorAddressTo(String[] onerrorAddress) {
		this.onerrorAddressTo = onerrorAddress;
	}

	/**
	 * G[̃[MtO擾܂B<br>
	 * @return G[̃[MtO
	 */
	public boolean isOnerrorCall() {
		return onerrorCall;
	}

	/**
	 * G[̃[MtOݒ肵܂B<br>
	 * @param onerrorCall G[̃[MtO
	 */
	public void setOnerrorCall(boolean onerrorCall) {
		this.onerrorCall = onerrorCall;
	}

	/**
	 * G[̃bZ[W擾܂B<br>
	 * @return G[̃bZ[W
	 */
	public String getOnerrorMessage() {
		return renderBindedString(onerrorMessage);
	}

	/**
	 * G[̃bZ[Wݒ肵܂B<br>
	 * @param onerrorMessage G[̃bZ[W
	 */
	public void setOnerrorMessage(String onerrorMessage) {
		this.onerrorMessage = onerrorMessage;
	}

	/**
	 * G[̃X^bNg[Xo̓tO擾܂B<br>
	 * @return G[̃X^bNg[Xo̓tO
	 */
	public boolean isOnerrorStacktrace() {
		return onerrorStacktrace;
	}

	/**
	 * G[̃X^bNg[Xo̓tOݒ肵܂B<br>
	 * @param onerrorStacktrace G[̃X^bNg[Xo̓tO
	 */
	public void setOnerrorStacktrace(boolean onerrorStacktrace) {
		this.onerrorStacktrace = onerrorStacktrace;
	}

	/**
	 * G[̃[MAhX擾܂B<br>
	 * @return G[̃[MAhX
	 */
	public String getOnerrorAddressFrom() {
		return onerrorAddressFrom;
	}

	/**
	 * G[̃[MAhXݒ肵܂B<br>
	 * @param onerrorAddressFrom G[̃[MAhX
	 */
	public void setOnerrorAddressFrom(String onerrorAddressFrom) {
		this.onerrorAddressFrom = onerrorAddressFrom;
	}
}
