package org.phosphoresce.contentnotifier.setting;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.contentnotifier.ContentNotifierConstants;
import org.phosphoresce.contentnotifier.exception.IllegalSettingException;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;
import org.phosphoresce.contentnotifier.util.StringUtil;

/**
 * [MpێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public final class MailSetting implements ContentNotifierConstants {

	/** fBtHgR[h */
	public static final String DEFAULT_CHARSET = "ISO-2022-JP";

	/** [MfobOtO */
	private boolean mailDebug;

	/** Mt */
	private Date mailDate;

	/** SMTPT[o */
	private String mailSmtp;

	/** MAhX */
	private String mailAddressFrom;

	/** MAhXz */
	private String[] mailAddressTo;

	/** [R[h */
	private String mailCharset;

	/** [薼 */
	private String mailSubject;

	/** [Ytt@CpXz */
	private String[] mailAttach;

	/** [{ev[g */
	private String mailTemplate;

	/** [{ev[gt@C */
	private String mailTemplateFile;

	/**
	 * RXgN^<br>
	 */
	public MailSetting() {
		this.mailDebug = false;
		this.mailDate = new Date();
		this.mailSmtp = "";
		this.mailAddressFrom = "";
		this.mailAddressTo = new String[0];
		this.mailCharset = DEFAULT_CHARSET;
		this.mailSubject = "";
		this.mailAttach = new String[0];
		this.mailTemplate = "";
		this.mailTemplateFile = "";
	}

	/**
	 * RXgN^<br>
	 * @param properties [ݒ`vpt@C
	 * @throws IllegalSettingException sȐݒ肪Ăꍇɔ܂
	 */
	public MailSetting(String properties) throws IllegalSettingException {
		try {
			this.mailDebug = Boolean.valueOf(PropertiesUtil.getValue(properties, PROPERTY_MAIL_DEBUG)).booleanValue();
			this.mailDate = new Date();
			this.mailSmtp = PropertiesUtil.getValue(properties, PROPERTY_MAIL_SMTP);
			this.mailAddressFrom = PropertiesUtil.getValue(properties, PROPERTY_MAIL_ADDRESS_FROM);
			this.mailAddressTo = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, PROPERTY_MAIL_ADDRESS_TO), PROPERTY_DELIM);
			this.mailCharset = PropertiesUtil.getValue(properties, PROPERTY_MAIL_CHARSET);
			this.mailSubject = PropertiesUtil.getValue(properties, PROPERTY_MAIL_SUBJECT);
			this.mailAttach = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, PROPERTY_MAIL_ATTACH), PROPERTY_DELIM);
			this.mailTemplate = PropertiesUtil.getValue(properties, PROPERTY_MAIL_TEMPLATE);
			this.mailTemplateFile = PropertiesUtil.getValue(properties, PROPERTY_MAIL_TEMPLATE_FILE);
		} catch (Exception e) {
			throw new IllegalSettingException("[ݒ񂪐ɏ܂ł", e);
		}
	}

	/**
	 * w肳ꂽɑ΂ĊeoChĒ񋟂܂B<br>
	 * @param value oChΏە
	 * @return eoCh
	 */
	private String renderBindedString(String value) {
		String buffer = value;
		buffer = StringUtil.binder(buffer, "timestamp", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(mailDate));
		buffer = StringUtil.binder(buffer, "date", new SimpleDateFormat("yyyy/MM/dd").format(mailDate));
		buffer = StringUtil.binder(buffer, "time", new SimpleDateFormat("HH:mm:ss").format(mailDate));
		return buffer;
	}

	/**
	 * NXێĂ郁[ev[gt@Cǂݍ݂񋟂܂B<br>
	 * @return ev[gt@C
	 * @throws IllegalSettingException Ƀev[gt@Cǂݍ߂Ȃꍇɔ
	 */
	private String loadTemplate() throws IllegalSettingException {
		StringBuffer buffer = new StringBuffer();
		try {
			if (!StringUtil.isEmpty(mailTemplateFile)) {
				BufferedReader reader = new BufferedReader(new FileReader(mailTemplateFile));
				while (reader.ready()) {
					buffer.append(reader.readLine());
					buffer.append("\n");
				}
				reader.close();
			}
		} catch (Exception e) {
			throw new IllegalSettingException("`Ă郁[ev[gt@C𐳏ɓǂݍ߂܂ł", e);
		}
		return buffer.toString();
	}

	/**
	 * Mt擾܂B<br>
	 * @return Mt
	 */
	public Date getMailDate() {
		return mailDate;
	}

	/**
	 * Mtݒ肵܂B<br>
	 * @param mailDate Mt
	 */
	public void setMailDate(Date mailDate) {
		this.mailDate = mailDate;
	}

	/**
	 * [MfobOtO擾܂B<br>
	 * @return [MfobOtO
	 */
	public boolean isMailDebug() {
		return mailDebug;
	}

	/**
	 * [MfobOtOݒ肵܂B<br>
	 * @param mailDebug [MfobOtO
	 */
	public void setMailDebug(boolean mailDebug) {
		this.mailDebug = mailDebug;
	}

	/**
	 * [{ev[gt@C擾܂B<br>
	 * @return [{ev[gt@C
	 */
	public String getMailTemplateFile() {
		return mailTemplateFile;
	}

	/**
	 * [{ev[gt@Cݒ肵܂B<br>
	 * @param mailTemplateFile [{ev[gt@C
	 */
	public void setMailTemplateFile(String mailTemplateFile) {
		this.mailTemplateFile = mailTemplateFile;
	}

	/**
	 * MAhX擾܂B<br>
	 * @return MAhX
	 */
	public String getMailAddressFrom() {
		return mailAddressFrom;
	}

	/**
	 * MAhXݒ肵܂B<br>
	 * @param mailAddressFrom MAhX
	 */
	public void setMailAddressFrom(String mailAddressFrom) {
		this.mailAddressFrom = mailAddressFrom;
	}

	/**
	 * MAhXz擾܂B<br>
	 * @return MAhXz
	 */
	public String[] getMailAddressTo() {
		return mailAddressTo;
	}

	/**
	 * MAhXzݒ肵܂B<br>
	 * @param mailAddressTo MAhXz
	 */
	public void setMailAddressTo(String[] mailAddressTo) {
		this.mailAddressTo = mailAddressTo;
	}

	/**
	 * [Ytt@CpXz擾܂B<br>
	 * @return [Ytt@CpXz
	 */
	public String[] getMailAttach() {
		return mailAttach;
	}

	/**
	 * [Ytt@CpXzݒ肵܂B<br>
	 * @param mailAttach [Ytt@CpXz
	 */
	public void setMailAttach(String[] mailAttach) {
		this.mailAttach = mailAttach;
	}

	/**
	 * [R[h擾܂B<br>
	 * @return [R[h
	 */
	public String getMailCharset() {
		return mailCharset;
	}

	/**
	 * [R[hݒ肵܂B<br>
	 * @param mailCharset [R[h
	 */
	public void setMailCharset(String mailCharset) {
		this.mailCharset = mailCharset;
	}

	/**
	 * SMTPT[o擾܂B<br>
	 * @return SMTPT[o
	 */
	public String getMailSmtp() {
		return mailSmtp;
	}

	/**
	 * SMTPT[oݒ肵܂B<br>
	 * @param mailSmtp SMTPT[o
	 */
	public void setMailSmtp(String mailSmtp) {
		this.mailSmtp = mailSmtp;
	}

	/**
	 * [薼擾܂B<br>
	 * @return [薼
	 */
	public String getMailSubject() {
		return renderBindedString(mailSubject);
	}

	/**
	 * [薼ݒ肵܂B<br>
	 * @param mailSubject [薼
	 */
	public void setMailSubject(String mailSubject) {
		this.mailSubject = mailSubject;
	}

	/**
	 * [{ev[g擾܂B<br>
	 * @return [{ev[g
	 * @throws IllegalSettingException Ƀev[gt@Cǂݍ߂Ȃꍇɔ
	 */
	public String getMailTemplate() throws IllegalSettingException {
		return !StringUtil.isEmpty(mailTemplateFile) ? renderBindedString(loadTemplate()) : renderBindedString(mailTemplate);
	}

	/**
	 * [{ev[gݒ肵܂B<br>
	 * @param mailTemplate [{ev[g
	 */
	public void setMailTemplate(String mailTemplate) {
		this.mailTemplate = mailTemplate;
	}
}
