/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier.util;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.phosphoresce.contentnotifier.exception.MailSendingException;
import org.phosphoresce.contentnotifier.setting.MailSetting;

public final class MailUtil {
    public static final String PROPERTIES_MAIL_SMTP = "mail.smtp.host";

    private MailUtil() {
    }

    public static void send(MailSetting setting) throws MailSendingException {
        try {
            Properties props = new Properties();
            props.put(PROPERTIES_MAIL_SMTP, setting.getMailSmtp());
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(setting.isMailDebug());
            MimeMessage message = new MimeMessage(session);
            InternetAddress[] address = new InternetAddress[setting.getMailAddressTo().length];
            for (int i = 0; i <= setting.getMailAddressTo().length - 1; ++i) {
                address[i] = new InternetAddress(setting.getMailAddressTo()[i]);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])address);
            message.setFrom((Address)new InternetAddress(setting.getMailAddressFrom()));
            message.setSubject(setting.getMailSubject(), setting.getMailCharset());
            message.setSentDate(new Date());
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setText(setting.getMailTemplate(), setting.getMailCharset());
            multiPart.addBodyPart((BodyPart)part);
            if (setting.getMailAttach() != null) {
                for (int i = 0; i <= setting.getMailAttach().length - 1; ++i) {
                    MimeBodyPart part2 = new MimeBodyPart();
                    FileDataSource data = new FileDataSource(setting.getMailAttach()[i]);
                    part2.setDataHandler(new DataHandler((DataSource)data));
                    part2.setFileName(MimeUtility.encodeWord((String)data.getName()));
                    multiPart.addBodyPart((BodyPart)part2);
                }
            }
            message.setContent((Multipart)multiPart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            throw new MailSendingException("\u30e1\u30fc\u30eb\u9001\u4fe1\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

