/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier.setting;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.phosphoresce.contentnotifier.ContentNotifierConstants;
import org.phosphoresce.contentnotifier.exception.IllegalSettingException;
import org.phosphoresce.contentnotifier.setting.MailSetting;
import org.phosphoresce.contentnotifier.strategy.CheckStrategy;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;
import org.phosphoresce.contentnotifier.util.StringUtil;

public final class NotifySetting
implements ContentNotifierConstants {
    private Date date;
    private String name;
    private String onerrorSubject;
    private String onerrorAddressFrom;
    private String[] onerrorAddressTo;
    private boolean onerrorCall;
    private boolean onerrorStacktrace;
    private String onerrorLogfile;
    private String onerrorMessage;
    private MailSetting mailSetting;
    private CheckStrategy checkStrategy;

    public NotifySetting() {
        this.date = new Date();
    }

    public NotifySetting(String properties) throws IllegalSettingException {
        try {
            this.date = new Date();
            this.name = PropertiesUtil.getValue(properties, "notify.name");
            this.onerrorSubject = PropertiesUtil.getValue(properties, "notify.onerror.subject");
            this.onerrorAddressFrom = PropertiesUtil.getValue(properties, "notify.onerror.address.from");
            this.onerrorAddressTo = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, "notify.onerror.address.to"), ",");
            this.onerrorCall = Boolean.valueOf(PropertiesUtil.getValue(properties, "notify.onerror.call"));
            this.onerrorStacktrace = Boolean.valueOf(PropertiesUtil.getValue(properties, "notify.onerror.stacktrace"));
            this.onerrorLogfile = PropertiesUtil.getValue(properties, "notify.onerror.logfile");
            this.onerrorMessage = PropertiesUtil.getValue(properties, "notify.onerror.message");
            this.mailSetting = new MailSetting(PropertiesUtil.getValue(properties, "notify.mail.properties"));
            this.checkStrategy = (CheckStrategy)Class.forName(PropertiesUtil.getValue(properties, "notify.check.strategy")).getConstructor(String.class).newInstance(PropertiesUtil.getValue(properties, "notify.check.strategy.properties"));
        }
        catch (Exception e) {
            throw new IllegalSettingException("\u901a\u77e5\u8a2d\u5b9a\u60c5\u5831\u304c\u6b63\u5e38\u306b\u521d\u671f\u5316\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    private String renderBindedString(String value) {
        String buffer = value;
        buffer = StringUtil.binder(buffer, "timestamp", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(this.date));
        buffer = StringUtil.binder(buffer, "date", new SimpleDateFormat("yyyy/MM/dd").format(this.date));
        buffer = StringUtil.binder(buffer, "time", new SimpleDateFormat("HH:mm:ss").format(this.date));
        buffer = StringUtil.binder(buffer, "name", this.name);
        buffer = StringUtil.binder(buffer, "logfile", this.onerrorLogfile);
        return buffer;
    }

    public String getOnerrorLogfile() {
        return this.onerrorLogfile;
    }

    public void setOnerrorLogfile(String onerrorLogfile) {
        this.onerrorLogfile = onerrorLogfile;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getOnerrorSubject() {
        return this.renderBindedString(this.onerrorSubject);
    }

    public void setOnerrorSubject(String onerrorSubject) {
        this.onerrorSubject = onerrorSubject;
    }

    public CheckStrategy getCheckStrategy() {
        return this.checkStrategy;
    }

    public void setCheckStrategy(CheckStrategy checkStrategy) {
        this.checkStrategy = checkStrategy;
    }

    public MailSetting getMailSetting() {
        return this.mailSetting;
    }

    public void setMailSetting(MailSetting mailSetting) {
        this.mailSetting = mailSetting;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getOnerrorAddressTo() {
        return this.onerrorAddressTo;
    }

    public void setOnerrorAddressTo(String[] onerrorAddress) {
        this.onerrorAddressTo = onerrorAddress;
    }

    public boolean isOnerrorCall() {
        return this.onerrorCall;
    }

    public void setOnerrorCall(boolean onerrorCall) {
        this.onerrorCall = onerrorCall;
    }

    public String getOnerrorMessage() {
        return this.renderBindedString(this.onerrorMessage);
    }

    public void setOnerrorMessage(String onerrorMessage) {
        this.onerrorMessage = onerrorMessage;
    }

    public boolean isOnerrorStacktrace() {
        return this.onerrorStacktrace;
    }

    public void setOnerrorStacktrace(boolean onerrorStacktrace) {
        this.onerrorStacktrace = onerrorStacktrace;
    }

    public String getOnerrorAddressFrom() {
        return this.onerrorAddressFrom;
    }

    public void setOnerrorAddressFrom(String onerrorAddressFrom) {
        this.onerrorAddressFrom = onerrorAddressFrom;
    }
}

