/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.phosphoresce.contentnotifier.ContentNotifierConstants;
import org.phosphoresce.contentnotifier.exception.MailSendingException;
import org.phosphoresce.contentnotifier.exception.NotifyExecuteException;
import org.phosphoresce.contentnotifier.setting.MailSetting;
import org.phosphoresce.contentnotifier.setting.NotifySetting;
import org.phosphoresce.contentnotifier.strategy.CheckStrategy;
import org.phosphoresce.contentnotifier.util.MailUtil;

public final class ContentNotifier
implements ContentNotifierConstants {
    public static void main(String[] args) throws Exception {
        if (args != null && args.length >= 1) {
            ContentNotifier.execute(args[0]);
        } else {
            ContentNotifier.execute("notifier.properties");
        }
    }

    private static void execute(String properties) throws NotifyExecuteException {
        NotifySetting setting = null;
        try {
            setting = new NotifySetting(properties);
            CheckStrategy strategy = setting.getCheckStrategy();
            if (!strategy.check()) {
                MailUtil.send(setting.getMailSetting());
            }
        }
        catch (Exception e) {
            if (setting != null && setting.isOnerrorCall()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                MailSetting mailSetting = new MailSetting();
                mailSetting.setMailAddressFrom(setting.getOnerrorAddressFrom());
                mailSetting.setMailAddressTo(setting.getOnerrorAddressTo());
                mailSetting.setMailAttach(null);
                mailSetting.setMailSmtp(setting.getMailSetting().getMailSmtp());
                mailSetting.setMailSubject(setting.getOnerrorSubject());
                StringBuffer buffer = new StringBuffer();
                buffer.append(setting.getOnerrorMessage());
                if (setting.isOnerrorStacktrace()) {
                    buffer.append("\n\n");
                    buffer.append(stringWriter.toString());
                }
                mailSetting.setMailTemplate(buffer.toString());
                try {
                    MailUtil.send(mailSetting);
                }
                catch (MailSendingException e1) {
                    // empty catch block
                }
            }
            throw new NotifyExecuteException("\u901a\u77e5\u51e6\u7406\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

