package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessorEditor;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessorRenderer;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETable;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * NGGfB^ʃe[upl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/20	Kitagawa		VK쐬
 *-->
 */
final class QueryManageResultTablePanel extends EScrollPane implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** NGsIuWFNg */
	private QueryManageActionContainer actionContainer = null;

	/** ʃe[u */
	private ETable resultTable = null;

	/**
	 * RXgN^<br>
	 * @param actionContainer NGsIuWFNg
	 */
	public QueryManageResultTablePanel(QueryManageActionContainer actionContainer) {
		super();
		this.actionContainer = actionContainer;
		initialize();
	}

	/**
	 * RXgN^<br>
	 */
	private QueryManageResultTablePanel() {
		this(null);
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		getResultTable().setModel(new DefaultTableModel());
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setSize(new Dimension(600, 400));
		this.setViewportView(getResultTable());
	}

	/**
	 * ʃe[u擾܂B<br>
	 * @return ʃe[u
	 */
	public ETable getResultTable() {
		if (resultTable == null) {
			resultTable = new ETable();
			resultTable.setDefaultRenderer(Object.class, new RecordTableModelAccessorRenderer(resultTable));
			resultTable.setDefaultEditor(Object.class, new RecordTableModelAccessorEditor(resultTable));
			resultTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		}
		return resultTable;
	}
}
