package org.phosphoresce.dbbrowser.gui.common.component;

import java.awt.Color;
import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseContainer;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;

/**
 * J^O/XL[}/e[uXgZ_NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/19	Kitagawa		VK쐬
 *-->
 */
public class CatalogSchemaTableListCellRenderer extends DefaultTreeCellRenderer {

	/**
	 * RXgN^<br>
	 */
	public CatalogSchemaTableListCellRenderer() {
		super();
	}

	/**
	 * ݂̃Z̒lR|[lgɓWJ܂B<br>
	 * @param tree JTreeIuWFNg
	 * @param value ZIuWFNg
	 * @param selected Iς݃tO
	 * @param expanded m[hWJς݃tO
	 * @param leaf m[h[tO
	 * @param row sʒu
	 * @param hasFocus tH[JXtO
	 * @return _OR|[lg
	 * @see javax.swing.tree.TreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
	 */
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
		super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);

		if (selected) {
			setForeground(UIManager.getColor("Tree.selectionForeground"));
			setBackground(UIManager.getColor("Tree.selectionBackground"));
		} else {
			setForeground(UIManager.getColor("Tree.textForeground"));
			setBackground(UIManager.getColor("Tree.textBackground"));
		}

		if (value == null || !(value instanceof DefaultMutableTreeNode)) {
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_16));
			setForeground(Color.RED);
			setText("failed to render tree node");
		}
		Object object = ((DefaultMutableTreeNode) value).getUserObject();
		setForeground(Color.BLACK);
		if (object instanceof DatabaseContainer) {
			DatabaseContainer container = (DatabaseContainer) object;
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATASOURCE_16));
			setText("Database");
		} else if (object instanceof DatabaseCatalog) {
			DatabaseCatalog catalog = (DatabaseCatalog) object;
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CATALOG_16));
			setText(catalog.getName());
		} else if (object instanceof DatabaseSchema) {
			DatabaseSchema schema = (DatabaseSchema) object;
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_SCHEMA_16));
			setText(schema.getName());
		} else if (object instanceof DatabaseTable) {
			DatabaseTable table = (DatabaseTable) object;
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_TABLE_16));
			setText(table.getName());
		} else {
			setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_SPACER_16));
			setText(object.toString());
		}
		return this;
	}
}
