package org.phosphoresce.dbbrowser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.dbbrowser.exception.BrowserPropertiesException;

/**
 * DatabaseBrowservpeBANZXNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserProperties {

	/** vpeB\[X */
	public static final String PROPERTIES_NAME = "databasebrowser.properties";

	/** ZtCX^X */
	private static DatabaseBrowserProperties instance = null;

	/** vpeBt@CIuWFNg */
	private File file = null;

	/** vpeBIuWFNg */
	private Properties properties = null;

	/**
	 * RXgN^<br>
	 * @throws BrowserPropertiesException ɃvpeBǂݍ߂Ȃꍇɔ
	 */
	private DatabaseBrowserProperties() throws BrowserPropertiesException {
		super();
		this.file = new File(PROPERTIES_NAME);
		load();
	}

	/**
	 * DatabaseBrowservpeBANZXNXCX^X񋟂܂B<br>
	 * @return DatabaseBrowservpeBANZXNXCX^X
	 * @throws BrowserPropertiesException ɃvpeBANZXsȂꍇɔ
	 */
	public static DatabaseBrowserProperties instance() throws BrowserPropertiesException {
		if (instance == null) {
			instance = new DatabaseBrowserProperties();
		}
		return instance;
	}

	/**
	 * vpeB\[Xt@Cǂݍ݂܂B<br>
	 * @throws BrowserPropertiesException Ƀt@C̓ǂݍ݂sȂꍇɔ
	 */
	public void load() throws BrowserPropertiesException {
		try {
			if (!file.exists()) {
				file.createNewFile();
			}
			this.properties = new Properties();
			this.properties.load(new FileInputStream(this.file));
		} catch (Throwable throwable) {
			throw new BrowserPropertiesException("failed to load properies.", throwable);
		}
	}

	/**
	 * vpeB\[Xt@Cɕۑ܂B<br>
	 * @throws BrowserPropertiesException Ƀt@Cɏo͂sȂꍇɔ
	 */
	public void save() throws BrowserPropertiesException {
		try {
			FileOutputStream stream = new FileOutputStream(file);
			properties.store(stream, "Database Browser Properies");
			stream.flush();
			stream.close();
		} catch (Throwable throwable) {
			throw new BrowserPropertiesException("failed to save properies.", throwable);
		}
	}

	/**
	 * w肳ꂽL[ŕێĂvpeBl擾܂B<br>
	 * @param key vpeBL[
	 * @return vpeBl
	 */
	private String get(String key) {
		String value = properties.getProperty(key);
		return value == null ? "" : value;
	}

	/**
	 * w肳ꂽL[Ŏw肳ꂽlvpeBɐݒ肵܂B<br>
	 * @param key vpeBL[
	 * @param value vpeBl
	 */
	private void set(String key, String value) {
		properties.setProperty(key, value);
	}

	/**
	 * ŋߎgpꂽJDBC`ɐڑݒIuWFNg擾܂B<br>
	 * @return ڑݒIuWFNg
	 */
	public DatabaseConfig getRecentJdbcConfig() {
		DatabaseConfig config = new DatabaseConfig();
		config.setJdbcDriver(get("recent_jdbc_driver_class"));
		config.setJdbcUrl(get("recent_jdbc_url"));
		config.setJdbcUser(get("recent_jdbc_user"));
		config.setJdbcPassword(get("recent_jdbc_password"));
		return config;
	}

	/**
	 * ŋߎgpꂽJDBC`ڑݒIuWFNgɐݒ肵܂B<br>
	 * @param config ڑݒIuWFNg
	 */
	public void setRecentJdbcConfig(DatabaseConfig config) {
		set("recent_jdbc_driver_class", config.getJdbcDriver());
		set("recent_jdbc_url", config.getJdbcUrl());
		set("recent_jdbc_user", config.getJdbcUser());
		set("recent_jdbc_password", config.getJdbcPassword());
	}

	/**
	 * w肳ꂽCfbNXJDBC`擾܂B<br>
	 * @return ڑݒIuWFNg
	 */
	public String getJdbcConfigName(int index) {
		return get("jdbc_definition_name_" + index);
	}

	/**
	 * w肳ꂽCfbNXJDBC`擾܂B<br>
	 * @return ڑݒIuWFNg
	 */
	public List getJdbcConfigNameList() {
		List list = new LinkedList();
		for (int i = 1; i <= Integer.MAX_VALUE - 1; i++) {
			String name = get("jdbc_definition_name_" + i).trim();
			if ("".equals(name)) {
				return list;
			}
			list.add(name);
		}
		return list;
	}

	/**
	 * w肳ꂽOJDBC`݂邩肵܂B<br>
	 * @param name JDBC`
	 * @return w肳ꂽOJDBC`݂ꍇtrueԋp
	 */
	public boolean containJdbcConfigName(String name) {
		if (name == null) {
			return false;
		}
		List list = getJdbcConfigNameList();
		return list.contains(name.trim());
	}

	/**
	 * w肳ꂽCfbNXJDBC`ɐڑݒIuWFNg擾܂B<br>
	 * @return ڑݒIuWFNg
	 */
	public DatabaseConfig getJdbcConfig(int index) {
		DatabaseConfig config = new DatabaseConfig();
		config.setJdbcDriver(get("jdbc_driver_class_" + index));
		config.setJdbcUrl(get("jdbc_url_" + index));
		config.setJdbcUser(get("jdbc_user_" + index));
		config.setJdbcPassword(get("jdbc_password_" + index));
		return config;
	}

	/**
	 * w肳ꂽJDBC`ڑݒIuWFNgɐݒ肵܂B<br>
	 * @param name ڑ`
	 * @param config ڑݒIuWFNg
	 */
	public void setJdbcConfig(String name, DatabaseConfig config) {
		int index = 1;
		List list = getJdbcConfigNameList();
		if (list.contains(name.trim())) {
			index = list.indexOf(name.trim()) + 1;
		} else {
			index = list.size() + 1;
		}
		set("jdbc_definition_name_" + index, name);
		set("jdbc_driver_class_" + index, config.getJdbcDriver());
		set("jdbc_url_" + index, config.getJdbcUrl());
		set("jdbc_user_" + index, config.getJdbcUser());
		set("jdbc_password_" + index, config.getJdbcPassword());
	}
}
