/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.phosphoresce.commons.util.StringUtil;

public final class DateUtil {
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYYsMMsDD = "yyyy/MM/dd";
    public static final String FORMAT_YYYYsMMsDD_24HHcMM = "yyyy/MM/dd HH:mm";
    public static final String FORMAT_YYYYsMMsDD_24HHcMMcSS = "yyyy/MM/dd HH:mm:ss";
    public static final String FORMAT_YYYYsMMsDD_24HHcMMcSSdSSS = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String FORMAT_YYYYsMMsDD_12HHcMMcSSdSSS_A = "yyyy/MM/dd hh:mm:ss.SSS a";
    public static final String FORMAT_YsMsD = "y/M/d";
    public static final String FORMAT_YsMsD_24HHcMM = "y/M/d HH:mm";
    public static final String FORMAT_YsMsD_24HHcMMcSS = "y/M/d HH:mm:ss";
    public static final String FORMAT_YsMsD_24HHcMMcSSdSSS = "y/M/d HH:mm:ss.SSS";
    public static final String FORMAT_YsMsD_12HHcMMcSSdSSS_A = "y/M/d hh:mm:ss.SSS a";
    public static final String FORMAT_YsMsD_24HcM = "y/M/d H:m";
    public static final String FORMAT_YsMsD_24HcMcS = "y/M/d H:m:s";
    public static final String FORMAT_YsMsD_24HcMcSdS = "y/M/d H:m:s.S";
    public static final String FORMAT_YsMsD_12HcMcSdS_A = "y/M/d h:m:s.S a";
    public static final String FORMAT_YYYYMMDD24HHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_24HHcMM = "HH:mm";
    public static final String FORMAT_24HHcMMcSS = "HH:mm:ss";
    public static final String FORMAT_24HHcMMcSSdSSS = "HH:mm:ss.SSS";
    public static final String FORMAT_24HcM = "H:m";
    public static final String FORMAT_24HcMcS = "H:m:s";
    public static final String FORMAT_24HcMcSdS = "H:m:s.S";
    public static final String FORMAT_YYYYMMDDu24HHMM = "yyyyMMdd_HHmm";
    public static final String FORMAT_YYYY = "yyyy";
    public static final String FORMAT_MM = "MM";
    public static final String FORMAT_DD = "dd";
    public static final String FORMAT_24HH = "HH";
    public static final String FORMAT_12HH = "hh";
    public static final String FORMAT_MI = "mm";
    public static final String FORMAT_SS = "ss";
    public static final String FORMAT_SSS = "SSS";
    public static final String FORMAT_A = "a";
    public static final String DEFAULT_FORMAT = "yyyy/MM/dd";

    private DateUtil() {
    }

    public static Date parse(String date, String format) {
        try {
            return StringUtil.isEmpty(date) ? null : new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u4ed8\u66f8\u5f0f\u3001\u307e\u305f\u306f\u65e5\u4ed8\u6587\u5b57\u5217\u304c\u4e0d\u6b63\u306a\u70ba\u3001Date\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3078\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f [" + date + "]");
        }
    }

    public static Date parse(String date, String[] format) {
        for (int i = 0; i <= format.length - 1; ++i) {
            try {
                return StringUtil.isEmpty(date) ? null : new SimpleDateFormat(format[i]).parse(date);
            }
            catch (ParseException e) {
                if (i < format.length - 1) continue;
                throw new RuntimeException("\u65e5\u4ed8\u66f8\u5f0f\u3001\u307e\u305f\u306f\u65e5\u4ed8\u6587\u5b57\u5217\u304c\u4e0d\u6b63\u306a\u70ba\u3001Date\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3078\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f [" + date + "]");
            }
        }
        return null;
    }

    public static Date parse(String date) {
        return DateUtil.parse(date, "yyyy/MM/dd");
    }

    public static String format(Date date, String format) {
        return date == null ? "" : new SimpleDateFormat(format).format(date);
    }

    public static String format(Date date) {
        return DateUtil.format(date, "yyyy/MM/dd");
    }

    public static String getYear(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_YYYY);
    }

    public static String getMonth(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_MM);
    }

    public static String getDay(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_DD);
    }

    public static String getHour(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_24HH);
    }

    public static String getHour12(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_12HH);
    }

    public static String getMinute(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_MI);
    }

    public static String getSecond(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_SS);
    }

    public static String getMilliSecond(Date date) {
        return date == null ? "" : DateUtil.format(new Date(), FORMAT_SSS);
    }

    public static boolean isAM(Date date) {
        return DateUtil.format(date, FORMAT_24HH).equals(DateUtil.format(date, FORMAT_12HH));
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static String getNowYear() {
        return DateUtil.getYear(new Date());
    }

    public static String getNowMonth() {
        return DateUtil.getMonth(new Date());
    }

    public static String getNowDay() {
        return DateUtil.getDay(new Date());
    }

    public static String getNowHour() {
        return DateUtil.getHour(new Date());
    }

    public static String getNowHour12() {
        return DateUtil.getHour12(new Date());
    }

    public static String getNowMinute() {
        return DateUtil.getMinute(new Date());
    }

    public static boolean isAMAtNow() {
        return DateUtil.isAM(new Date());
    }

    public static boolean isValidityDateStringValue(String value, String pattern) {
        if (value == null || pattern == null) {
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.parse(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidityDateStringValue(String value, DateFormat format) {
        if (value == null || format == null) {
            return false;
        }
        try {
            format.parse(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidityDateStringValue(String value) {
        if (value == null) {
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
            format.parse(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

