/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.EMenu;
import org.phosphoresce.commons.eswing.EMenuBar;
import org.phosphoresce.commons.eswing.EMenuItem;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.ETabbedPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameStatusBarPanel;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.common.window.MessageDialog;
import org.phosphoresce.dbbrowser.gui.panel.dbinformation.DatabaseInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.pcinformation.ClientPCInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManagePanel;
import org.phosphoresce.dbbrowser.gui.window.about.AboutDialog;

public class DatabaseBrowserFrame
extends EFrame
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private EPanel mainContainerPanel = null;
    private FrameStatusBarPanel frameStatusBarPanel = null;
    private ETabbedPane browserTabbedPane = null;
    private ClientPCInformationPanel clientPCInformationPanel = null;
    private DatabaseInformationPanel databaseInformationPanel = null;
    private QueryManagePanel queryManagerPanel = null;
    private EMenuBar browserMenuBar = null;
    private EMenu browserMenuFile = null;
    private EMenu browserMenuView = null;
    private EMenu browserMenuHelp = null;
    private EMenuItem browserMenuItemAbout = null;
    private EMenuItem browserMenuItemNewConnection = null;
    private EMenuItem browserMenuItemClientInformationView = null;
    private EMenuItem browserMenuItemDatabaseInformationView = null;
    private EMenuItem browserMenuItemQueryManagerView = null;

    public DatabaseBrowserFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(900, 700));
        this.setContentPane((Container)this.getMainContainerPanel());
        this.setIconImage(DatabaseBrowserImages.IMAGE_APP_ICON_32);
        this.setJMenuBar((JMenuBar)this.getBrowserMenuBar());
        this.setTitle("Database Browser");
    }

    public void refresh() throws Throwable {
        for (int i = 0; i <= this.getBrowserTabbedPane().getTabCount() - 1; ++i) {
            Component component = this.getBrowserTabbedPane().getComponentAt(i);
            if (!(component instanceof RefreshableComponent)) continue;
            ((RefreshableComponent)((Object)component)).refresh();
        }
        this.getFrameStatusBarPanel().refresh();
    }

    private EPanel getMainContainerPanel() {
        if (this.mainContainerPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.mainContainerPanel = new EPanel();
            this.mainContainerPanel.setLayout((LayoutManager)new GridBagLayout());
            this.mainContainerPanel.add((Component)this.getBrowserTabbedPane(), (Object)gridBagConstraints);
            this.mainContainerPanel.add((Component)((Object)this.getFrameStatusBarPanel()), (Object)gridBagConstraints1);
        }
        return this.mainContainerPanel;
    }

    private FrameStatusBarPanel getFrameStatusBarPanel() {
        if (this.frameStatusBarPanel == null) {
            this.frameStatusBarPanel = FrameStatusBarPanel.instance();
        }
        return this.frameStatusBarPanel;
    }

    private ETabbedPane getBrowserTabbedPane() {
        if (this.browserTabbedPane == null) {
            this.browserTabbedPane = new ETabbedPane();
            this.browserTabbedPane.addTab("Client Information", (Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20), (Component)((Object)this.getClientPCInformationPanel()), "Client PC Information");
            this.browserTabbedPane.addTab("Database Information", (Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20), (Component)((Object)this.getDatabaseInformationPanel()), "Database Information");
            this.browserTabbedPane.addTab("Query Manager", (Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20), (Component)((Object)this.getQueryManagerPanel()), "Query Manager");
            this.browserTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (DatabaseBrowserFrame.this.browserTabbedPane.getSelectedComponent() instanceof RefreshableComponent) {
                        try {
                            ((RefreshableComponent)((Object)DatabaseBrowserFrame.this.browserTabbedPane.getSelectedComponent())).refresh();
                        }
                        catch (Throwable throwable) {
                            String errorMessage = "failed to refresh browser panel.";
                            DatabaseBrowserFrame.this.log.error((Object)errorMessage, throwable);
                            MessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), errorMessage, throwable);
                        }
                    }
                }
            });
            try {
                this.getClientPCInformationPanel().refresh();
            }
            catch (Throwable throwable) {
                String errorMessage = "failed to refresh client pc information panel.";
                this.log.error((Object)errorMessage, throwable);
                MessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), errorMessage, throwable);
            }
        }
        return this.browserTabbedPane;
    }

    private ClientPCInformationPanel getClientPCInformationPanel() {
        if (this.clientPCInformationPanel == null) {
            this.clientPCInformationPanel = new ClientPCInformationPanel();
        }
        return this.clientPCInformationPanel;
    }

    private DatabaseInformationPanel getDatabaseInformationPanel() {
        if (this.databaseInformationPanel == null) {
            this.databaseInformationPanel = new DatabaseInformationPanel();
        }
        return this.databaseInformationPanel;
    }

    private QueryManagePanel getQueryManagerPanel() {
        if (this.queryManagerPanel == null) {
            this.queryManagerPanel = new QueryManagePanel();
        }
        return this.queryManagerPanel;
    }

    private EMenuBar getBrowserMenuBar() {
        if (this.browserMenuBar == null) {
            this.browserMenuBar = new EMenuBar();
            this.browserMenuBar.add((JMenu)this.getBrowserMenuFile());
            this.browserMenuBar.add((JMenu)this.getBrowserMenuView());
            this.browserMenuBar.add((JMenu)this.getBrowserMenuHelp());
        }
        return this.browserMenuBar;
    }

    private EMenu getBrowserMenuFile() {
        if (this.browserMenuFile == null) {
            this.browserMenuFile = new EMenu("File");
            this.browserMenuFile.setMnemonic('F');
            this.browserMenuFile.add((JMenuItem)this.getBrowserMenuItemNewConnection());
        }
        return this.browserMenuFile;
    }

    private EMenu getBrowserMenuView() {
        if (this.browserMenuView == null) {
            this.browserMenuView = new EMenu("View");
            this.browserMenuView.setMnemonic('V');
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemClientInformationView());
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemDatabaseInformationView());
            this.browserMenuView.add((JMenuItem)this.getBrowserMenuItemQueryManagerView());
        }
        return this.browserMenuView;
    }

    private EMenu getBrowserMenuHelp() {
        if (this.browserMenuHelp == null) {
            this.browserMenuHelp = new EMenu("Help");
            this.browserMenuHelp.setMnemonic('H');
            this.browserMenuHelp.add((JMenuItem)this.getBrowserMenuItemAbout());
        }
        return this.browserMenuHelp;
    }

    private EMenuItem getBrowserMenuItemAbout() {
        if (this.browserMenuItemAbout == null) {
            this.browserMenuItemAbout = new EMenuItem("About...");
            this.browserMenuItemAbout.setMnemonic('A');
            this.browserMenuItemAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        new AboutDialog((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), true).setVisible(true);
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to show about dialog.";
                        DatabaseBrowserFrame.this.log.error((Object)errorMessage, throwable);
                        MessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), errorMessage, throwable);
                    }
                }
            });
        }
        return this.browserMenuItemAbout;
    }

    private EMenuItem getBrowserMenuItemNewConnection() {
        if (this.browserMenuItemNewConnection == null) {
            this.browserMenuItemNewConnection = new EMenuItem("New Connection...");
            this.browserMenuItemNewConnection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        new ConnectionConfigureFrame((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), DatabaseBrowserSession.instance()).setVisible(true);
                        DatabaseBrowserFrame.this.refresh();
                    }
                    catch (Throwable throwable) {
                        String errorMessage = "failed to connect new database instance.";
                        DatabaseBrowserFrame.this.log.error((Object)errorMessage, throwable);
                        MessageDialog.showError((Frame)((Object)DatabaseBrowserSession.instance().getBrowserFrame()), errorMessage, throwable);
                    }
                }
            });
        }
        return this.browserMenuItemNewConnection;
    }

    private EMenuItem getBrowserMenuItemClientInformationView() {
        if (this.browserMenuItemClientInformationView == null) {
            this.browserMenuItemClientInformationView = new EMenuItem("ClientInformationView");
            this.browserMenuItemClientInformationView.setMnemonic('C');
            this.browserMenuItemClientInformationView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserFrame.this.getBrowserTabbedPane().setSelectedIndex(0);
                }
            });
        }
        return this.browserMenuItemClientInformationView;
    }

    private EMenuItem getBrowserMenuItemDatabaseInformationView() {
        if (this.browserMenuItemDatabaseInformationView == null) {
            this.browserMenuItemDatabaseInformationView = new EMenuItem("DatabaseInformationView");
            this.browserMenuItemDatabaseInformationView.setMnemonic('D');
            this.browserMenuItemDatabaseInformationView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserFrame.this.getBrowserTabbedPane().setSelectedIndex(1);
                }
            });
        }
        return this.browserMenuItemDatabaseInformationView;
    }

    private EMenuItem getBrowserMenuItemQueryManagerView() {
        if (this.browserMenuItemQueryManagerView == null) {
            this.browserMenuItemQueryManagerView = new EMenuItem("QueryManagerView");
            this.browserMenuItemQueryManagerView.setMnemonic('Q');
            this.browserMenuItemQueryManagerView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatabaseBrowserFrame.this.getBrowserTabbedPane().setSelectedIndex(2);
                }
            });
        }
        return this.browserMenuItemQueryManagerView;
    }
}

