/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.dbbrowser.exception.BrowserPropertiesException;

public final class DatabaseBrowserProperties {
    public static final String PROPERTIES_NAME = "databasebrowser.properties";
    private static DatabaseBrowserProperties instance = null;
    private File file = new File("databasebrowser.properties");
    private Properties properties = null;

    private DatabaseBrowserProperties() throws BrowserPropertiesException {
        this.load();
    }

    public static DatabaseBrowserProperties instance() throws BrowserPropertiesException {
        if (instance == null) {
            instance = new DatabaseBrowserProperties();
        }
        return instance;
    }

    public void load() throws BrowserPropertiesException {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.properties = new Properties();
            this.properties.load(new FileInputStream(this.file));
        }
        catch (Throwable throwable) {
            throw new BrowserPropertiesException("failed to load properies.", throwable);
        }
    }

    public void save() throws BrowserPropertiesException {
        try {
            FileOutputStream stream = new FileOutputStream(this.file);
            this.properties.store(stream, "Database Browser Properies");
            stream.flush();
            stream.close();
        }
        catch (Throwable throwable) {
            throw new BrowserPropertiesException("failed to save properies.", throwable);
        }
    }

    private String get(String key) {
        String value = this.properties.getProperty(key);
        return value == null ? "" : value;
    }

    private void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public DatabaseConfig getRecentJdbcConfig() {
        DatabaseConfig config = new DatabaseConfig();
        config.setJdbcDriver(this.get("recent_jdbc_driver_class"));
        config.setJdbcUrl(this.get("recent_jdbc_url"));
        config.setJdbcUser(this.get("recent_jdbc_user"));
        config.setJdbcPassword(this.get("recent_jdbc_password"));
        return config;
    }

    public void setRecentJdbcConfig(DatabaseConfig config) {
        this.set("recent_jdbc_driver_class", config.getJdbcDriver());
        this.set("recent_jdbc_url", config.getJdbcUrl());
        this.set("recent_jdbc_user", config.getJdbcUser());
        this.set("recent_jdbc_password", config.getJdbcPassword());
    }

    public String getJdbcConfigName(int index) {
        return this.get("jdbc_definition_name_" + index);
    }

    public List getJdbcConfigNameList() {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 1; i <= 0x7FFFFFFE; ++i) {
            String name = this.get("jdbc_definition_name_" + i).trim();
            if ("".equals(name)) {
                return list;
            }
            list.add(name);
        }
        return list;
    }

    public boolean containJdbcConfigName(String name) {
        if (name == null) {
            return false;
        }
        List list = this.getJdbcConfigNameList();
        return list.contains(name.trim());
    }

    public DatabaseConfig getJdbcConfig(int index) {
        DatabaseConfig config = new DatabaseConfig();
        config.setJdbcDriver(this.get("jdbc_driver_class_" + index));
        config.setJdbcUrl(this.get("jdbc_url_" + index));
        config.setJdbcUser(this.get("jdbc_user_" + index));
        config.setJdbcPassword(this.get("jdbc_password_" + index));
        return config;
    }

    public void setJdbcConfig(String name, DatabaseConfig config) {
        int index = 1;
        List list = this.getJdbcConfigNameList();
        index = list.contains(name.trim()) ? list.indexOf(name.trim()) + 1 : list.size() + 1;
        this.set("jdbc_definition_name_" + index, name);
        this.set("jdbc_driver_class_" + index, config.getJdbcDriver());
        this.set("jdbc_url_" + index, config.getJdbcUrl());
        this.set("jdbc_user_" + index, config.getJdbcUser());
        this.set("jdbc_password_" + index, config.getJdbcPassword());
    }
}

