package org.phosphoresce.commons.mail;

import java.io.Serializable;
import java.util.Properties;

import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;

/**
 * [ݒ蒊ۃNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public abstract class MailConfiguration implements Serializable, MailDeclareInterface {

	/** JavaMailfobOtO */
	private boolean debug = false;

	/** T[o[vgR */
	private String protocol = "";

	/** T[o[AhX */
	private String server = "";

	/** T[o[|[g */
	private int port = 0;

	/** T[o[F؃[U[ */
	private String user = "";

	/** T[o[F؃pX[h */
	private String password = "";

	/**
	 * RXgN^<br>
	 */
	public MailConfiguration() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param protocol T[o[vgR
	 * @param server T[o[AhX
	 * @param port T[o[|[g
	 * @param user T[o[F؃[U[
	 * @param password T[o[F؃pX[h
	 */
	public MailConfiguration(String protocol, String server, int port, String user, String password) {
		super();
		this.protocol = protocol;
		this.server = server;
		this.port = port;
		this.user = user;
		this.password = password;
	}

	/**
	 * JavaMailɒ񋟂PropertiesIuWFNg𐶐܂B<br>
	 * @return JavaMailɒ񋟂PropertiesIuWFNg
	 */
	protected final Properties createSessionProperties() {
		Properties properties = new Properties();
		properties.setProperty("mail.debug", Boolean.toString(getDebug()));
		appendSessionProperties(properties);
		return properties;
	}

	/**
	 * eݒIuWFNgێPropertiesIuWFNgɒǉ܂B<br>
	 * @param properties PropertiesIuWFNg
	 */
	protected abstract void appendSessionProperties(Properties properties);

	/**
	 * ݒ񂪑Mp`ł邩擾܂B<br>
	 * @return Mp`łꍇAtrueԋp
	 */
	protected abstract boolean isSender();

	/**
	 * w肳ꂽT[o[ڑݒ肪Ół邩`FbN܂B<br>
	 * @param configuration T[o[ڑݒ
	 * @return w肳ꂽT[o[ڑŐɐڑłꍇtrueԋp܂
	 */
	public static final boolean checkConnection(MailConfiguration configuration) {
		try {
			if (!configuration.isSender()) {
				Store store = configuration.getSession().getStore(configuration.getProtocol());
				store.connect(configuration.getServer(), configuration.getPort(), configuration.getUser(), configuration.getPassword());
				store.close();
			} else {
				Transport transport = configuration.getSession().getTransport(configuration.getProtocol());
				transport.connect(configuration.getServer(), configuration.getPort(), configuration.getUser(), configuration.getPassword());
				transport.close();
			}
		} catch (Exception e) {
			//e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * JavaMailZbVIuWFNg擾܂B<br>
	 * @return JavaMailZbVIuWFNg
	 */
	protected final Session getSession() {
		return Session.getDefaultInstance(createSessionProperties());
	}

	/**
	 * JavaMailfobOtO擾܂B<br>
	 * @return JavaMailfobOtO
	 */
	public final boolean getDebug() {
		return this.debug;
	}

	/**
	 * JavaMailfobOtOݒ肵܂B<br>
	 * @param debug JavaMailfobOtO
	 */
	public final void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 * T[o[F؃pX[h擾܂B<br>
	 * @return T[o[F؃pX[h
	 */
	public final String getPassword() {
		return this.password;
	}

	/**
	 * T[o[F؃pX[hݒ肵܂B<br>
	 * @param password T[o[F؃pX[h
	 */
	public final void setPassword(String password) {
		this.password = password;
	}

	/**
	 * port擾܂B<br>
	 * @return port
	 */
	public final int getPort() {
		return this.port;
	}

	/**
	 * T[o[|[gݒ肵܂B<br>
	 * @param port T[o[|[g
	 */
	public final void setPort(int port) {
		this.port = port;
	}

	/**
	 * T[o[vgR擾܂B<br>
	 * @return T[o[vgR
	 */
	public final String getProtocol() {
		return this.protocol;
	}

	/**
	 * T[o[vgRݒ肵܂B<br>
	 * @param protocol T[o[vgR
	 */
	public final void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * T[o[AhX擾܂B<br>
	 * @return T[o[AhX
	 */
	public final String getServer() {
		return this.server;
	}

	/**
	 * T[o[AhXݒ肵܂B<br>
	 * @param server T[o[AhX
	 */
	public final void setServer(String server) {
		this.server = server;
	}

	/**
	 * T[o[F؃[U[擾܂B<br>
	 * @return T[o[F؃[U[
	 */
	public final String getUser() {
		return this.user;
	}

	/**
	 * T[o[F؃[U[ݒ肵܂B<br>
	 * @param user T[o[F؃[U[
	 */
	public final void setUser(String user) {
		this.user = user;
	}
}
