/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.phosphoresce.commons.mail.MailAttachResource;
import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailException;
import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.mail.exception.MailResourceException;
import org.phosphoresce.commons.mail.mail.MailSafeAccesserUtil;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class MailContent
implements MailDeclareInterface {
    private String subject = "";
    private String subjectCharset = "iso-2022-jp";
    private String content = "";
    private String contentCharset = "iso-2022-jp";
    private boolean isHTML;
    private List attachList = new LinkedList();
    private String attachNameCharset = "iso-2022-jp";

    static MailContent createMailContent(Message message) throws MailMessageException {
        try {
            MailContent content = new MailContent();
            content.subject = MailSafeAccesserUtil.getSubject(message);
            content.subjectCharset = MailUtil.getCharset((Part)message);
            content.render((Part)message);
            return content;
        }
        catch (Exception e) {
            throw new MailMessageException("Message\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304b\u3089\u6b63\u5e38\u306b\u30b3\u30f3\u30c6\u30f3\u30c4\u60c5\u5831\u3092\u53d6\u5f97\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    private void render(Part part) throws MailMessageException {
        try {
            if (part.isMimeType("multipart/*")) {
                Multipart multi = (Multipart)part.getContent();
                for (int i = 0; i <= multi.getCount() - 1; ++i) {
                    this.render((Part)multi.getBodyPart(i));
                }
            } else if (part.isMimeType("message/rfc822")) {
                this.render((Part)part.getContent());
            } else if (part.isMimeType("text/plain")) {
                if (MailUtil.hasContentType(part, "name")) {
                    this.attachList.add(new MailAttachResource(part));
                } else {
                    this.content = MailSafeAccesserUtil.getContent(part);
                    this.contentCharset = MailUtil.getCharset(part);
                }
            } else if (part.isMimeType("text/html")) {
                if (MailUtil.hasContentType(part, "name")) {
                    this.attachList.add(new MailAttachResource(part));
                } else {
                    this.content = MailSafeAccesserUtil.getContent(part);
                    this.contentCharset = MailUtil.getCharset(part);
                    this.isHTML = true;
                }
            } else {
                this.attachList.add(new MailAttachResource(part));
            }
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30fc\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u89e3\u6790\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    Multipart createMultipart() throws MailMessageException {
        try {
            MimeBodyPart part;
            MimeMultipart multipart = new MimeMultipart();
            if (!StringUtil.isEmpty((String)this.content) && !this.isHTML) {
                part = new MimeBodyPart();
                part.setText(this.content, this.contentCharset);
                multipart.addBodyPart((BodyPart)part);
            }
            if (!StringUtil.isEmpty((String)this.content) && this.isHTML) {
                part = new MimeBodyPart();
                part.setContent((Object)this.content, "text/html; charset=" + this.contentCharset);
                multipart.addBodyPart((BodyPart)part);
            }
            if (this.attachList != null) {
                Iterator iterator = this.attachList.iterator();
                while (iterator.hasNext()) {
                    MailAttachResource resource = (MailAttachResource)iterator.next();
                    if (resource.isIncome()) {
                        throw new MailException("\u53d7\u4fe1\u7528\u6dfb\u4ed8\u30ea\u30bd\u30fc\u30b9\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u9001\u4fe1\u7528\u3068\u3057\u3066\u6dfb\u4ed8\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
                    }
                    DataHandler handler = new DataHandler((DataSource)new FileDataSource(resource.getFile()));
                    MimeBodyPart part2 = new MimeBodyPart();
                    part2.setDataHandler(handler);
                    part2.setFileName(MimeUtility.encodeText((String)resource.getName(), (String)this.attachNameCharset, null));
                    multipart.addBodyPart((BodyPart)part2);
                }
            }
            return multipart;
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30fc\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u751f\u6210\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public void addAttachResource(File file) throws MailResourceException {
        this.attachList.add(new MailAttachResource(file));
    }

    public MailAttachResource[] getAttachResources() {
        return this.attachList.toArray(new MailAttachResource[this.attachList.size()]);
    }

    public MailAttachResource getAttachResource(String name) {
        Iterator iterator = this.attachList.iterator();
        while (iterator.hasNext()) {
            MailAttachResource resource = (MailAttachResource)iterator.next();
            if (!name.equals(resource.getName())) continue;
            return resource;
        }
        return null;
    }

    public String getAttachResourceNames() {
        StringBuffer buffer = new StringBuffer();
        MailAttachResource[] resources = this.getAttachResources();
        for (int i = 0; i <= resources.length - 1; ++i) {
            MailAttachResource resource = resources[i];
            buffer.append(resource.getName());
            if (i >= resources.length - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public void saveAttachResources(File file) throws MailResourceException, MailIOException {
        if (!file.isDirectory()) {
            throw new MailResourceException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u306a\u3044File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u3092\u51fa\u529b\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        MailAttachResource[] resources = this.getAttachResources();
        for (int i = 0; i <= resources.length - 1; ++i) {
            resources[i].save(file);
        }
    }

    public boolean isHTML() {
        return this.isHTML;
    }

    public void setHTML(boolean isHTML) {
        this.isHTML = isHTML;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubjectCharset() {
        return this.subjectCharset;
    }

    public void setSubjectCharset(String subjectCharset) {
        this.subjectCharset = subjectCharset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public void setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
    }

    public String getAttachNameCharset() {
        return this.attachNameCharset;
    }

    public void setAttachNameCharset(String attachNameCharset) {
        this.attachNameCharset = attachNameCharset;
    }
}

