/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.io.Serializable;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import org.phosphoresce.commons.mail.MailDeclareInterface;

public abstract class MailConfiguration
implements Serializable,
MailDeclareInterface {
    private boolean debug = false;
    private String protocol = "";
    private String server = "";
    private int port = 0;
    private String user = "";
    private String password = "";

    public MailConfiguration() {
    }

    public MailConfiguration(String protocol, String server, int port, String user, String password) {
        this.protocol = protocol;
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    protected final Properties createSessionProperties() {
        Properties properties = new Properties();
        properties.setProperty("mail.debug", Boolean.toString(this.getDebug()));
        this.appendSessionProperties(properties);
        return properties;
    }

    protected abstract void appendSessionProperties(Properties var1);

    protected abstract boolean isSender();

    public static final boolean checkConnection(MailConfiguration configuration) {
        try {
            if (!configuration.isSender()) {
                Store store = configuration.getSession().getStore(configuration.getProtocol());
                store.connect(configuration.getServer(), configuration.getPort(), configuration.getUser(), configuration.getPassword());
                store.close();
            } else {
                Transport transport = configuration.getSession().getTransport(configuration.getProtocol());
                transport.connect(configuration.getServer(), configuration.getPort(), configuration.getUser(), configuration.getPassword());
                transport.close();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected final Session getSession() {
        return Session.getDefaultInstance((Properties)this.createSessionProperties());
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public final String getServer() {
        return this.server;
    }

    public final void setServer(String server) {
        this.server = server;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setUser(String user) {
        this.user = user;
    }
}

