\echo ###### Prepare for the test
\set QUIET
SET client_min_messages = 'error';
CREATE EXTENSION IF NOT EXISTS pg_store_plans;
DROP TABLE IF EXISTS plans;
CREATE TABLE plans (id int, title text, lplan text, splan text);
SET client_min_messages = 'notice';
\set ECHO none

\echo ###### insert original JSON plans
INSERT INTO plans (VALUES
(-1, '###### Plan -1: all properties 1/2',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Node Type": "Sample Scan",
  "Node Type": "Gather",
  "Node Type": "ProjectSet",
  "Node Type": "Table Function Scan",
  "Node Type": "Named Tuplestore Scan",
  "Node Type": "Gather Merge",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Strategy": "Mixed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Hash Keys": "a",
  "Hash Key": "a",
  "Parallel Aware": "true",
  "Workers Planned": "0",
  "Workers Launched": "0",
  "Workers": "x",
  "Worker Number": "0",
  "Async Capable": "false",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0
}'),(-2, '###### Plan -2: all properties 2/2',
 '{
  "Hash Batches": 0,
  "Hash Buckets": 0,
  "Rows Removed by Filter": 0,
  "Rows Removed by Index Recheck": 0,
  "Time": 0,
  "Calls": 0,
  "Planning Time": 0,
  "Execution Time": 0,
  "Exact Heap Blocks": 0,
  "Lossy Heap Blocks": 0,
  "Rows Removed by Join Filter": 0,
  "Target Tables": "dummy",
  "Conflict Resolution": "NOTHING",
  "Conflict Arbiter Indexes": "ia",
  "Tuples Inserted": 123,
  "Conflicting Tuples": 234,
  "Sampling Method": "system",
  "Sampling Parameters": ["''10''::real"],
  "Repeatable Seed": "''0''::double precision",
  "Workers": "dummy",
  "Worker Number": 0,
  "Async Capable": 0
}'),(-3, '###### Plan -3: some properties plus unknown key',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Node Type": "Sample Scan",
  "Node Type": "Gather",
  "Node Type": "ProjectSet",
  "Node Type": "Table Function Scan",
  "Node Type": "Named Tuplestore Scan",
  "Node Type": "Gather Merge",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Strategy": "Mixed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Hash Keys": "a",
  "Hash Key": "a",
  "Parallel Aware": "true",
  "Workers Planned": "0",
  "Workers Launched": "0",
  "Workers": "x",
  "Worker Number": "0",
  "Async Capable": "false",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0,
  "Unknown Key": "Unknown Value"
}'),
(1, '###### Plan 1: Insert, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 100.01,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 93.227,
    "Actual Total Time": 93.228,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 29749,
    "Shared Read Blocks": 3,
    "Shared Dirtied Blocks": 85,
    "Shared Written Blocks": 84,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Function Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Function Name": "generate_series",
        "Schema": "pg_catalog",
        "Alias": "a",
        "Startup Cost": 0.00,
        "Total Cost": 100.01,
        "Plan Rows": 10001,
        "Plan Width": 40,
        "Actual Startup Time": 2.771,
        "Actual Total Time": 6.297,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a.a", "NULL::integer", "NULL::text"],
        "Function Call": "generate_series(0, 10000)",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -2589108490333464452,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.063,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 24.539,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 20.903,
      "Calls": 10001
    }
  ],
  "Execution Time": 93.551
}'),
(2, '###### Plan 2: Update, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 137.50,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 128.336,
    "Actual Total Time": 128.336,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 60223,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 81,
    "Shared Written Blocks": 81,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 137.50,
        "Plan Rows": 6600,
        "Plan Width": 10,
        "Actual Startup Time": 0.026,
        "Actual Total Time": 5.365,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["(a + 1)", "ctid"],
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -7155621357888961537,
  "Planning": {
    "Shared Hit Blocks": 5,
    "Shared Read Blocks": 3,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 1.256,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 26.522,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 22.213,
      "Calls": 10001
    }
  ],
  "Execution Time": 129.001
}'),
(3, '###### Plan 3: Delete',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 305.20,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 5.304,
    "Actual Total Time": 5.305,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 1109,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 305.20,
        "Plan Rows": 65,
        "Plan Width": 6,
        "Actual Startup Time": 1.497,
        "Actual Total Time": 4.509,
        "Actual Rows": 1000,
        "Actual Loops": 1,
        "Output": ["ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9001,
        "Shared Hit Blocks": 109,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -1217291892215499561,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 6,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 2.240,
  "Triggers": [
  ],
  "Execution Time": 5.444
}'),
(4, '###### Plan 4: Result, Append Seq Scan',
 '{
  "Plan": {
    "Node Type": "Result",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.00,
    "Total Cost": 743.05,
    "Plan Rows": 20002,
    "Plan Width": 12,
    "Actual Startup Time": 1.162,
    "Actual Total Time": 18.645,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["((tt1.a + 1))", "(3)", "1"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 543.03,
        "Plan Rows": 20002,
        "Plan Width": 8,
        "Actual Startup Time": 1.161,
        "Actual Total Time": 12.500,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Subplans Removed": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 288.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 1.160,
            "Actual Total Time": 5.146,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(tt1.a + 1)", "3"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.019,
            "Actual Total Time": 3.517,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.a", "4"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": -1830518987892578530,
  "Planning": {
    "Shared Hit Blocks": 28,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.229,
  "Triggers": [
  ],
  "Execution Time": 21.161
}'),
(5, '###### Plan 5: Index scan (forward) ANY, array in expr, escape',
 E'{
  "Plan": {
    "Node Type": "Index Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "x\\"y",
    "Startup Cost": 0.29,
    "Total Cost": 21.21,
    "Plan Rows": 4,
    "Plan Width": 12,
    "Actual Startup Time": 0.014,
    "Actual Total Time": 0.037,
    "Actual Rows": 4,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Index Cond": "(\\"x\\"\\"y\\".a = ANY (\'{50,120,300,500}\'::integer[]))",
    "Rows Removed by Index Recheck": 0,
    "Shared Hit Blocks": 24,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": -2319859004001884772,
  "Planning": {
    "Shared Hit Blocks": 6,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.078,
  "Triggers": [
  ],
  "Execution Time": 0.093
}'),
(6, '###### Plan 6: Index scan (backward), MergeJoin, Sort, quicksort, alias',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 819.75,
    "Total Cost": 820.68,
    "Plan Rows": 10,
    "Plan Width": 12,
    "Actual Startup Time": 13.895,
    "Actual Total Time": 13.898,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["x.b", "x.c", "x.a"],
    "Shared Hit Blocks": 59,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Merge Join",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Join Type": "Inner",
        "Startup Cost": 819.75,
        "Total Cost": 1746.80,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 13.894,
        "Actual Total Time": 13.896,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["x.b", "x.c", "x.a"],
        "Inner Unique": false,
        "Merge Cond": "(x.a = (((- y.b) * 3)))",
        "Shared Hit Blocks": 59,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Scan Direction": "Backward",
            "Index Name": "i_tt1",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "x",
            "Startup Cost": 0.29,
            "Total Cost": 652.30,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.012,
            "Actual Total Time": 0.012,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["x.a", "x.b", "x.c"],
            "Shared Hit Blocks": 4,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Sort",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 819.47,
            "Total Cost": 844.47,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 10.632,
            "Actual Total Time": 11.786,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.b", "(((- y.b) * 3))"],
            "Sort Key": ["(((- y.b) * 3)) DESC"],
            "Sort Method": "quicksort",
            "Sort Space Used": 811,
            "Sort Space Type": "Memory",
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "tt2",
                "Schema": "public",
                "Alias": "y",
                "Startup Cost": 0.00,
                "Total Cost": 155.01,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.014,
                "Actual Total Time": 4.218,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["y.b", "((- y.b) * 3)"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": 8036956240398275929,
  "Planning": {
    "Shared Hit Blocks": 14,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.188,
  "Triggers": [
  ],
  "Execution Time": 14.225
}'),
(7, '###### Plan 7: IndexOnlyScan',
 '{
  "Plan": {
    "Node Type": "Index Only Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.29,
    "Total Cost": 8.46,
    "Plan Rows": 10,
    "Plan Width": 4,
    "Actual Startup Time": 0.006,
    "Actual Total Time": 0.066,
    "Actual Rows": 10,
    "Actual Loops": 1,
    "Output": ["a"],
    "Index Cond": "(tt1.a < 10)",
    "Rows Removed by Index Recheck": 0,
    "Heap Fetches": 29,
    "Shared Hit Blocks": 31,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": 9043476308310009982,
  "Planning": {
    "Shared Hit Blocks": 4,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.163,
  "Triggers": [
  ],
  "Execution Time": 0.168
}'),
(8, '###### Plan 8: Plain Aggregate, CTE, Recursive Union, WorkTable Scan, CTE Scan',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 3.65,
    "Total Cost": 3.66,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 0.018,
    "Actual Total Time": 0.019,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(cte1.a)"],
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Recursive Union",
        "Parent Relationship": "InitPlan",
        "Subplan Name": "CTE cte1",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 2.95,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.002,
        "Actual Total Time": 0.011,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Result",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 0.01,
            "Plan Rows": 1,
            "Plan Width": 4,
            "Actual Startup Time": 0.001,
            "Actual Total Time": 0.001,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "WorkTable Scan",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "Async Capable": false,
            "CTE Name": "cte1",
            "Alias": "cte1_1",
            "Startup Cost": 0.00,
            "Total Cost": 0.23,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.000,
            "Actual Total Time": 0.000,
            "Actual Rows": 1,
            "Actual Loops": 10,
            "Output": ["(cte1_1.a + 1)"],
            "Filter": "(cte1_1.a < 10)",
            "Rows Removed by Filter": 0,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      },
      {
        "Node Type": "CTE Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "CTE Name": "cte1",
        "Alias": "cte1",
        "Startup Cost": 0.00,
        "Total Cost": 0.62,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.002,
        "Actual Total Time": 0.014,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Output": ["cte1.a"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -1934637991189912523,
  "Planning": {
    "Shared Hit Blocks": 2,
    "Shared Read Blocks": 1,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.083,
  "Triggers": [
  ],
  "Execution Time": 0.152
}'),
(9, '###### Plan 9: FunctionScan, Hash/HashJoin, Nested Loop',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Async Capable": false,
    "Join Type": "Left",
    "Startup Cost": 1.02,
    "Total Cost": 2.30,
    "Plan Rows": 100,
    "Plan Width": 64,
    "Actual Startup Time": 0.072,
    "Actual Total Time": 0.078,
    "Actual Rows": 6,
    "Actual Loops": 1,
    "Output": ["d.datname"],
    "Inner Unique": true,
    "Hash Cond": "(s.datid = d.oid)",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Function Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Function Name": "pg_stat_get_activity",
        "Schema": "pg_catalog",
        "Alias": "s",
        "Startup Cost": 0.00,
        "Total Cost": 1.00,
        "Plan Rows": 100,
        "Plan Width": 8,
        "Actual Startup Time": 0.052,
        "Actual Total Time": 0.054,
        "Actual Rows": 6,
        "Actual Loops": 1,
        "Output": ["s.datid", "s.pid", "s.usesysid", "s.application_name", "s.state", "s.query", "s.wait_event_type", "s.wait_event", "s.xact_start", "s.query_start", "s.backend_start", "s.state_change", "s.client_addr", "s.client_hostname", "s.client_port", "s.backend_xid", "s.backend_xmin", "s.backend_type", "s.ssl", "s.sslversion", "s.sslcipher", "s.sslbits", "s.ssl_client_dn", "s.ssl_client_serial", "s.ssl_issuer_dn", "s.gss_auth", "s.gss_princ", "s.gss_enc", "s.leader_pid", "s.query_id"],
        "Function Call": "pg_stat_get_activity(NULL::integer)",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 1.01,
        "Total Cost": 1.01,
        "Plan Rows": 1,
        "Plan Width": 68,
        "Actual Startup Time": 0.014,
        "Actual Total Time": 0.014,
        "Actual Rows": 4,
        "Actual Loops": 1,
        "Output": ["d.datname", "d.oid"],
        "Hash Buckets": 1024,
        "Original Hash Buckets": 1024,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 9,
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "pg_database",
            "Schema": "pg_catalog",
            "Alias": "d",
            "Startup Cost": 0.00,
            "Total Cost": 1.01,
            "Plan Rows": 1,
            "Plan Width": 68,
            "Actual Startup Time": 0.009,
            "Actual Total Time": 0.010,
            "Actual Rows": 4,
            "Actual Loops": 1,
            "Output": ["d.datname", "d.oid"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 8459435736800325928,
  "Planning": {
    "Shared Hit Blocks": 26,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.326,
  "Triggers": [
  ],
  "Execution Time": 0.475
}'),
(10, '###### Plan 10: MergeAppend, Values',
 E'{
  "Plan": {
    "Node Type": "Merge Append",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.36,
    "Total Cost": 852.43,
    "Plan Rows": 10004,
    "Plan Width": 4,
    "Actual Startup Time": 0.029,
    "Actual Total Time": 32.844,
    "Actual Rows": 10004,
    "Actual Loops": 1,
    "Sort Key": ["tt1.a"],
    "Shared Hit Blocks": 30076,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Subplans Removed": 0,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Async Capable": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 652.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.020,
        "Actual Total Time": 30.984,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a"],
        "Heap Fetches": 29996,
        "Shared Hit Blocks": 30076,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Sort",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.06,
        "Total Cost": 0.07,
        "Plan Rows": 3,
        "Plan Width": 4,
        "Actual Startup Time": 0.008,
        "Actual Total Time": 0.010,
        "Actual Rows": 3,
        "Actual Loops": 1,
        "Output": ["\\"*VALUES*\\".column1"],
        "Sort Key": ["\\"*VALUES*\\".column1"],
        "Sort Method": "quicksort",
        "Sort Space Used": 25,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Values Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Alias": "*VALUES*",
            "Startup Cost": 0.00,
            "Total Cost": 0.04,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.003,
            "Actual Rows": 3,
            "Actual Loops": 1,
            "Output": ["\\"*VALUES*\\".column1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 8163045782145773816,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.101,
  "Triggers": [
  ],
  "Execution Time": 34.205
}'),
(11, '###### Plan 11: Append, HashAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1793.16,
    "Total Cost": 2149.44,
    "Plan Rows": 20002,
    "Plan Width": 4,
    "Actual Startup Time": 20.498,
    "Actual Total Time": 29.907,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["tt1.a"],
    "Group Key": ["tt1.a"],
    "Planned Partitions": 4,
    "HashAgg Batches": 5,
    "Peak Memory Usage": 1073,
    "Disk Usage": 240,
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 24,
    "Temp Written Blocks": 46,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 718.05,
        "Plan Rows": 20002,
        "Plan Width": 4,
        "Actual Startup Time": 0.180,
        "Actual Total Time": 10.035,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Subplans Removed": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.179,
            "Actual Total Time": 3.211,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt1.a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.017,
            "Actual Total Time": 3.053,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 3730801975092271509,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.093,
  "Triggers": [
  ],
  "Execution Time": 32.577
}'),
(12, '###### Plan 12: GroupAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Sorted",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1067.47,
    "Total Cost": 1242.49,
    "Plan Rows": 10001,
    "Plan Width": 12,
    "Actual Startup Time": 10.823,
    "Actual Total Time": 22.573,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["sum(a)", "b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 43,
    "Temp Written Blocks": 54,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 10.817,
        "Actual Total Time": 13.508,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b", "a"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 200,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 43,
        "Temp Written Blocks": 54,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.183,
            "Actual Total Time": 2.951,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 4231724385053355366,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.070,
  "Triggers": [
  ],
  "Execution Time": 24.416
}'),
(13, '###### Plan 13: Group',
 '{
  "Plan": {
    "Node Type": "Group",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1067.47,
    "Total Cost": 1117.47,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 11.725,
    "Actual Total Time": 21.019,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 37,
    "Temp Written Blocks": 45,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 11.723,
        "Actual Total Time": 14.845,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 176,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 37,
        "Temp Written Blocks": 45,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.131,
            "Actual Total Time": 2.957,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 1640542994599740094,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.059,
  "Triggers": [
  ],
  "Execution Time": 22.677
}'),
(14, '###### Plan 14: SetOp intersect, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1432.51,
    "Total Cost": 1457.52,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 19.906,
    "Actual Total Time": 19.909,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Command": "Intersect",
        "Startup Cost": 0.00,
        "Total Cost": 768.05,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 19.901,
        "Actual Total Time": 19.902,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 718.05,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.116,
            "Actual Total Time": 14.699,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.116,
                "Actual Total Time": 6.088,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.114,
                    "Actual Total Time": 3.154,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.062,
                "Actual Total Time": 5.097,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.061,
                    "Actual Total Time": 2.668,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": 3096982350113582736,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.087,
  "Triggers": [
  ],
  "Execution Time": 20.297
}'),
(15, '###### Plan 15: Sorted SetOp, Sort on Disk',
 E'{
  "Plan": {
    "Node Type": "SetOp",
    "Strategy": "Sorted",
    "Parallel Aware": false,
    "Async Capable": false,
    "Command": "Intersect",
    "Startup Cost": 2423.48,
    "Total Cost": 2523.49,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 41.536,
    "Actual Total Time": 41.539,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 110,
    "Temp Written Blocks": 135,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 2423.48,
        "Total Cost": 2473.48,
        "Plan Rows": 20002,
        "Plan Width": 8,
        "Actual Startup Time": 28.351,
        "Actual Total Time": 33.879,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Sort Key": ["\\"*SELECT* 1\\".a"],
        "Sort Method": "external merge",
        "Sort Space Used": 376,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 110,
        "Temp Written Blocks": 135,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 718.05,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.204,
            "Actual Total Time": 12.673,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.203,
                "Actual Total Time": 5.016,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.202,
                    "Actual Total Time": 2.650,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.014,
                "Actual Total Time": 4.694,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.013,
                    "Actual Total Time": 2.437,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": 3096982350113582736,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.146,
  "Triggers": [
  ],
  "Execution Time": 42.164
}'),
(16, '###### Plan 16: HashSetOp intersect All, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1432.51,
    "Total Cost": 1457.52,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 18.058,
    "Actual Total Time": 18.060,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Command": "Intersect All",
        "Startup Cost": 0.00,
        "Total Cost": 768.05,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 18.053,
        "Actual Total Time": 18.054,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 718.05,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.196,
            "Actual Total Time": 13.188,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.195,
                "Actual Total Time": 5.220,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.193,
                    "Actual Total Time": 2.761,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.014,
                "Actual Total Time": 4.903,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.014,
                    "Actual Total Time": 2.513,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": 3568745853788466523,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.125,
  "Triggers": [
  ],
  "Execution Time": 18.485
}'),
(17, '###### Plan 17: HashSetOp except, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1432.51,
    "Total Cost": 1457.52,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 27.722,
    "Actual Total Time": 28.806,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 811,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Command": "Except",
        "Startup Cost": 0.00,
        "Total Cost": 768.05,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 19.322,
        "Actual Total Time": 20.603,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 718.05,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.117,
            "Actual Total Time": 14.680,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.116,
                "Actual Total Time": 5.913,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.115,
                    "Actual Total Time": 3.026,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.021,
                "Actual Total Time": 5.251,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.020,
                    "Actual Total Time": 2.747,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": 3594877820052107993,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.124,
  "Triggers": [
  ],
  "Execution Time": 30.673
}'),
(18, '###### Plan 18: HashSetOp except all, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 1432.51,
    "Total Cost": 1457.52,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 24.268,
    "Actual Total Time": 25.407,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 811,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Command": "Except All",
        "Startup Cost": 0.00,
        "Total Cost": 768.05,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 17.886,
        "Actual Total Time": 19.275,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 718.05,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.111,
            "Actual Total Time": 13.530,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.111,
                "Actual Total Time": 5.005,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.110,
                    "Actual Total Time": 2.733,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.017,
                "Actual Total Time": 5.254,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Async Capable": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.016,
                    "Actual Total Time": 2.658,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": -2116677524503591575,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.075,
  "Triggers": [
  ],
  "Execution Time": 27.394
}'),
(19, '###### Plan 19: merge LEFT join',
 '{
  "Plan": {
    "Node Type": "Merge Join",
    "Parallel Aware": false,
    "Async Capable": false,
    "Join Type": "Left",
    "Startup Cost": 0.71,
    "Total Cost": 3864.99,
    "Plan Rows": 33319,
    "Plan Width": 4,
    "Actual Startup Time": 0.020,
    "Actual Total Time": 65.526,
    "Actual Rows": 60003,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Inner Unique": false,
    "Merge Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 35794,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.29,
        "Total Cost": 652.30,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.007,
        "Actual Total Time": 19.067,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 15484,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Async Capable": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt3_a",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "y",
        "Startup Cost": 0.42,
        "Total Cost": 8173.43,
        "Plan Rows": 180003,
        "Plan Width": 4,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 27.745,
        "Actual Rows": 60004,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Heap Fetches": 60004,
        "Shared Hit Blocks": 20310,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 5445668563620879351,
  "Planning": {
    "Shared Hit Blocks": 41,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.312,
  "Triggers": [
  ],
  "Execution Time": 71.014
}'),
(20, '###### Plan 20: hash FULL join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Async Capable": false,
    "Join Type": "Full",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 5.667,
    "Actual Total Time": 13.838,
    "Actual Rows": 17001,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Inner Unique": false,
    "Hash Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.124,
        "Actual Total Time": 2.075,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.530,
        "Actual Total Time": 5.531,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "y",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.015,
            "Actual Total Time": 2.557,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.a"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 6335038381742375814,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.104,
  "Triggers": [
  ],
  "Execution Time": 15.762
}'),
(21, '###### Plan 21: hash SEMI join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Async Capable": false,
    "Join Type": "Semi",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 12,
    "Actual Startup Time": 9.529,
    "Actual Total Time": 9.531,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Inner Unique": false,
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.104,
        "Actual Total Time": 1.999,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.031,
        "Actual Total Time": 5.032,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.010,
            "Actual Total Time": 2.366,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": -8798771479551581617,
  "Planning": {
    "Shared Hit Blocks": 8,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.212,
  "Triggers": [
  ],
  "Execution Time": 9.776
}'),
(22, '###### Plan 22: Hash Anti Join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Async Capable": false,
    "Join Type": "Anti",
    "Startup Cost": 280.02,
    "Total Cost": 580.54,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 6.258,
    "Actual Total Time": 13.296,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Inner Unique": false,
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.081,
        "Actual Total Time": 2.144,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 6.167,
        "Actual Total Time": 6.168,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.006,
            "Actual Total Time": 2.970,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 4859020764959126897,
  "Planning": {
    "Shared Hit Blocks": 8,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.105,
  "Triggers": [
  ],
  "Execution Time": 14.681
}'),
(23, '###### Plan 23: WindowAgg',
 '{
  "Plan": {
    "Node Type": "WindowAgg",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 952.47,
    "Total Cost": 1152.49,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 6.530,
    "Actual Total Time": 17.093,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["first_value(a) OVER (?)", "((a / 10))"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 952.47,
        "Total Cost": 977.47,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 6.524,
        "Actual Total Time": 7.621,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["((a / 10))", "a"],
        "Sort Key": ["((tt1.a / 10))"],
        "Sort Method": "quicksort",
        "Sort Space Used": 811,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 288.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.145,
            "Actual Total Time": 3.896,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(a / 10)", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": -1216354698760536723,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.056,
  "Triggers": [
  ],
  "Execution Time": 18.497
}'),
(24, '###### Plan 24: Unique',
 '{
  "Plan": {
    "Node Type": "Unique",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.29,
    "Total Cost": 677.30,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 0.016,
    "Actual Total Time": 25.521,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["a"],
    "Shared Hit Blocks": 15403,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 652.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.015,
        "Actual Total Time": 21.061,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a"],
        "Heap Fetches": 20208,
        "Shared Hit Blocks": 15403,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 7686180932610511067,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.052,
  "Triggers": [
  ],
  "Execution Time": 26.598
}'),
(25, '###### Plan 25: PlainAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 288.01,
    "Total Cost": 288.02,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 3.367,
    "Actual Total Time": 3.368,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(a)"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.085,
        "Actual Total Time": 1.590,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 7614438656164053517,
  "Planning": {
    "Shared Hit Blocks": 3,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.067,
  "Triggers": [
  ],
  "Execution Time": 3.453
}'),
(26, '###### Plan 26: BitmapIndexScan/BitmapHeapScan, BitmapOr, lossy',
 E'{
  "Plan": {
    "Node Type": "Bitmap Heap Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 3947.41,
    "Total Cost": 7170.40,
    "Plan Rows": 179999,
    "Plan Width": 12,
    "Actual Startup Time": 10.477,
    "Actual Total Time": 47.936,
    "Actual Rows": 180000,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Recheck Cond": "(tt3.b > \'-99998\'::integer)",
    "Rows Removed by Index Recheck": 0,
    "Exact Heap Blocks": 973,
    "Lossy Heap Blocks": 0,
    "Shared Hit Blocks": 1609,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Bitmap Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Index Name": "i_tt3_b",
        "Startup Cost": 0.00,
        "Total Cost": 3902.41,
        "Plan Rows": 179999,
        "Plan Width": 0,
        "Actual Startup Time": 10.205,
        "Actual Total Time": 10.205,
        "Actual Rows": 180000,
        "Actual Loops": 1,
        "Index Cond": "(tt3.b > \'-99998\'::integer)",
        "Shared Hit Blocks": 636,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -8473665767601577456,
  "Planning": {
    "Shared Hit Blocks": 10,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.070,
  "Triggers": [
  ],
  "Execution Time": 66.101
}'),
(27, '###### Plan 27: Join Filter',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.00,
    "Total Cost": 21.52,
    "Plan Rows": 100,
    "Plan Width": 12,
    "Actual Startup Time": 6.954,
    "Actual Total Time": 7.113,
    "Actual Rows": 100,
    "Actual Loops": 1,
    "Output": ["tt2.a", "tt2.b", "tt2.c"],
    "Shared Hit Blocks": 40,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 12,
    "Plans": [
      {
        "Node Type": "Nested Loop",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Join Type": "Inner",
        "Startup Cost": 0.00,
        "Total Cost": 43048282.11,
        "Plan Rows": 200023334,
        "Plan Width": 12,
        "Actual Startup Time": 6.953,
        "Actual Total Time": 7.096,
        "Actual Rows": 100,
        "Actual Loops": 1,
        "Output": ["tt2.a", "tt2.b", "tt2.c"],
        "Inner Unique": false,
        "Join Filter": "((tt2.a < tt3.a) AND ((tt3.a + tt2.a) < 100000))",
        "Rows Removed by Join Filter": 7001,
        "Shared Hit Blocks": 40,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 12,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.014,
            "Actual Total Time": 0.014,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.a", "tt2.b", "tt2.c"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Materialize",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 4377.05,
            "Plan Rows": 180003,
            "Plan Width": 4,
            "Actual Startup Time": 0.013,
            "Actual Total Time": 5.500,
            "Actual Rows": 7101,
            "Actual Loops": 1,
            "Output": ["tt3.a"],
            "Shared Hit Blocks": 39,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 12,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "tt3",
                "Schema": "public",
                "Alias": "tt3",
                "Startup Cost": 0.00,
                "Total Cost": 2773.03,
                "Plan Rows": 180003,
                "Plan Width": 4,
                "Actual Startup Time": 0.011,
                "Actual Total Time": 1.786,
                "Actual Rows": 7101,
                "Actual Loops": 1,
                "Output": ["tt3.a"],
                "Shared Hit Blocks": 39,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": -762734892635574820,
  "Planning": {
    "Shared Hit Blocks": 3,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.172,
  "Triggers": [
  ],
  "Execution Time": 7.481
}'),
(28, '###### Plan 28: TidScan',
 E'{
  "Plan": {
    "Node Type": "Tid Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 0.00,
    "Total Cost": 4.01,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 0.007,
    "Actual Total Time": 0.008,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "TID Cond": "(tt3.ctid = \'(0,28)\'::tid)",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": -2444693457534222348,
  "Planning": {
    "Shared Hit Blocks": 7,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.053,
  "Triggers": [
  ],
  "Execution Time": 0.120
}'),
(29, '###### Plan 29: LockRows',
 '{
  "Plan": {
    "Node Type": "LockRows",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.00,
    "Total Cost": 313.51,
    "Plan Rows": 50,
    "Plan Width": 10,
    "Actual Startup Time": 0.209,
    "Actual Total Time": 3.592,
    "Actual Rows": 1001,
    "Actual Loops": 1,
    "Output": ["a", "ctid"],
    "Shared Hit Blocks": 1164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 313.01,
        "Plan Rows": 50,
        "Plan Width": 10,
        "Actual Startup Time": 0.194,
        "Actual Total Time": 2.837,
        "Actual Rows": 1001,
        "Actual Loops": 1,
        "Output": ["a", "ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9000,
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 700612173983705222,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.028,
  "Triggers": [
  ],
  "Execution Time": 3.791
}'),
(30, '###### Plan 30: Materialize',
 '{
  "Plan": {
    "Node Type": "Seq Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 1150490.52,
    "Plan Rows": 5000,
    "Plan Width": 12,
    "Actual Startup Time": 7.484,
    "Actual Total Time": 7.485,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Filter": "(SubPlan 1)",
    "Rows Removed by Filter": 10001,
    "Shared Hit Blocks": 164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Materialize",
        "Parent Relationship": "SubPlan",
        "Subplan Name": "SubPlan 1",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 205.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.000,
        "Actual Total Time": 0.000,
        "Actual Rows": 1,
        "Actual Loops": 10001,
        "Output": ["tt2.b"],
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.018,
            "Actual Total Time": 0.018,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 1915684042122908759,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.104,
  "Triggers": [
  ],
  "Execution Time": 7.782
}'),
(31, '###### Plan 31: Update on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 6691.16,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 2265.303,
    "Actual Total Time": 2265.305,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p_1"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "p_2"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "p_3"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "p_4"
      }
    ],
    "Shared Hit Blocks": 1737811,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 1553,
    "Shared Written Blocks": 1553,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Result",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 6691.16,
        "Plan Rows": 200006,
        "Plan Width": 14,
        "Actual Startup Time": 0.095,
        "Actual Total Time": 182.008,
        "Actual Rows": 200005,
        "Actual Loops": 1,
        "Output": ["(p.b + 1)", "p.tableoid", "p.ctid"],
        "Shared Hit Blocks": 1191,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 0.00,
            "Total Cost": 4191.08,
            "Plan Rows": 200006,
            "Plan Width": 14,
            "Actual Startup Time": 0.094,
            "Actual Total Time": 117.310,
            "Actual Rows": 200005,
            "Actual Loops": 1,
            "Shared Hit Blocks": 1191,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Subplans Removed": 0,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "p",
                "Schema": "public",
                "Alias": "p_1",
                "Startup Cost": 0.00,
                "Total Cost": 0.00,
                "Plan Rows": 1,
                "Plan Width": 14,
                "Actual Startup Time": 0.001,
                "Actual Total Time": 0.002,
                "Actual Rows": 0,
                "Actual Loops": 1,
                "Output": ["p_1.b", "p_1.tableoid", "p_1.ctid"],
                "Shared Hit Blocks": 0,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              },
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "tt1",
                "Schema": "public",
                "Alias": "p_2",
                "Startup Cost": 0.00,
                "Total Cost": 263.01,
                "Plan Rows": 10001,
                "Plan Width": 14,
                "Actual Startup Time": 0.092,
                "Actual Total Time": 5.036,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["p_2.b", "p_2.tableoid", "p_2.ctid"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              },
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "tt2",
                "Schema": "public",
                "Alias": "p_3",
                "Startup Cost": 0.00,
                "Total Cost": 155.01,
                "Plan Rows": 10001,
                "Plan Width": 14,
                "Actual Startup Time": 0.016,
                "Actual Total Time": 3.650,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["p_3.b", "p_3.tableoid", "p_3.ctid"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              },
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Async Capable": false,
                "Relation Name": "tt3",
                "Schema": "public",
                "Alias": "p_4",
                "Startup Cost": 0.00,
                "Total Cost": 2773.03,
                "Plan Rows": 180003,
                "Plan Width": 14,
                "Actual Startup Time": 0.018,
                "Actual Total Time": 67.436,
                "Actual Rows": 180003,
                "Actual Loops": 1,
                "Output": ["p_4.b", "p_4.tableoid", "p_4.ctid"],
                "Shared Hit Blocks": 973,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": -5951642706806634283,
  "Planning": {
    "Shared Hit Blocks": 6,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.136,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 26.970,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 22.896,
      "Calls": 10001
    }
  ],
  "Execution Time": 2265.659
}'),
(32, '###### Plan 32: Delete on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 32.83,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 0.212,
    "Actual Total Time": 0.214,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p_1"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "p_2"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "p_3"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "p_4"
      }
    ],
    "Shared Hit Blocks": 18,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 32.83,
        "Plan Rows": 6,
        "Plan Width": 10,
        "Actual Startup Time": 0.121,
        "Actual Total Time": 0.202,
        "Actual Rows": 3,
        "Actual Loops": 1,
        "Shared Hit Blocks": 15,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Subplans Removed": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Relation Name": "p",
            "Schema": "public",
            "Alias": "p_1",
            "Startup Cost": 0.00,
            "Total Cost": 0.00,
            "Plan Rows": 1,
            "Plan Width": 10,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.002,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Output": ["p_1.tableoid", "p_1.ctid"],
            "Filter": "(p_1.a = 100)",
            "Rows Removed by Filter": 0,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Scan Direction": "Forward",
            "Index Name": "i_tt1",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "p_2",
            "Startup Cost": 0.29,
            "Total Cost": 8.30,
            "Plan Rows": 1,
            "Plan Width": 10,
            "Actual Startup Time": 0.118,
            "Actual Total Time": 0.120,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["p_2.tableoid", "p_2.ctid"],
            "Index Cond": "(p_2.a = 100)",
            "Rows Removed by Index Recheck": 0,
            "Shared Hit Blocks": 5,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Scan Direction": "Forward",
            "Index Name": "i_tt2",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "p_3",
            "Startup Cost": 0.29,
            "Total Cost": 8.30,
            "Plan Rows": 1,
            "Plan Width": 10,
            "Actual Startup Time": 0.006,
            "Actual Total Time": 0.007,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Output": ["p_3.tableoid", "p_3.ctid"],
            "Index Cond": "(p_3.a = 100)",
            "Rows Removed by Index Recheck": 0,
            "Shared Hit Blocks": 2,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Async Capable": false,
            "Scan Direction": "Forward",
            "Index Name": "i_tt3_a",
            "Relation Name": "tt3",
            "Schema": "public",
            "Alias": "p_4",
            "Startup Cost": 0.42,
            "Total Cost": 16.19,
            "Plan Rows": 3,
            "Plan Width": 10,
            "Actual Startup Time": 0.066,
            "Actual Total Time": 0.071,
            "Actual Rows": 2,
            "Actual Loops": 1,
            "Output": ["p_4.tableoid", "p_4.ctid"],
            "Index Cond": "(p_4.a = 100)",
            "Rows Removed by Index Recheck": 0,
            "Shared Hit Blocks": 8,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 6350946585627028890,
  "Planning": {
    "Shared Hit Blocks": 50,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.391,
  "Triggers": [
  ],
  "Execution Time": 0.651
}'),
(33, '###### Plan 33: ON CONFLICT',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "ct1",
    "Schema": "public",
    "Alias": "ct1",
    "Startup Cost": 0.00,
    "Total Cost": 0.01,
    "Plan Rows": 0,
    "Plan Width": 0,
    "Actual Startup Time": 0.029,
    "Actual Total Time": 0.030,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Conflict Resolution": "UPDATE",
    "Conflict Arbiter Indexes": ["ct1_a_key"],
    "Tuples Inserted": 0,
    "Conflicting Tuples": 1,
    "Shared Hit Blocks": 5,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Result",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 0.01,
        "Plan Rows": 1,
        "Plan Width": 8,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.001,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["1", "1"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": -322563580534947997,
  "Planning": {
    "Shared Hit Blocks": 8,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.048,
  "Triggers": [
  ],
  "Execution Time": 0.152
}'),
(34, '###### Plan 34: GROUP BY',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 392.02,
    "Total Cost": 492.03,
    "Plan Rows": 10001,
    "Plan Width": 40,
    "Actual Startup Time": 10.828,
    "Actual Total Time": 15.418,
    "Actual Rows": 10000,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Group Key": ["tt1.a", "tt1.b"],
    "Planned Partitions": 0,
    "HashAgg Batches": 1,
    "Peak Memory Usage": 1425,
    "Disk Usage": 0,
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 317.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.079,
        "Actual Total Time": 4.105,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 217,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 3426498110299849807,
  "Planning": {
    "Shared Hit Blocks": 10,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.106,
  "Triggers": [
  ],
  "Execution Time": 16.647
}'),
(35, '###### Plan 35: GROUPING SETS',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Mixed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.00,
    "Total Cost": 642.05,
    "Plan Rows": 20003,
    "Plan Width": 40,
    "Actual Startup Time": 14.486,
    "Actual Total Time": 23.001,
    "Actual Rows": 20001,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Grouping Sets": [
      {
        "Hash Keys": [
          ["tt1.a"]
        ]
      },
      {
        "Hash Keys": [
          ["tt1.b"]
        ]
      },
      {
        "Group Keys": [
          []
        ]
      }
    ],
    "Planned Partitions": 0,
    "HashAgg Batches": 1,
    "Peak Memory Usage": 2841,
    "Disk Usage": 0,
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 317.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.075,
        "Actual Total Time": 2.082,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 217,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Query Identifier": 3930596157273795694,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.090,
  "Triggers": [
  ],
  "Execution Time": 25.195
}'),
(36, '###### Plan 36: Table sample',
 E'{
  "Plan": {
    "Node Type": "Sample Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 9.00,
    "Plan Rows": 100,
    "Plan Width": 12,
    "Actual Startup Time": 0.016,
    "Actual Total Time": 0.059,
    "Actual Rows": 185,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Sampling Method": "system",
    "Sampling Parameters": ["\'1\'::real"],
    "Repeatable Seed": "\'1\'::double precision",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": 2489568850889218847,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.040,
  "Triggers": [
  ],
  "Execution Time": 0.148
}'),
(37, '###### Plan 37: Project Set',
 E'{
  "Plan": {
    "Node Type": "Table Function Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Table Function Name": "xmltable",
    "Alias": "xmltable",
    "Startup Cost": 0.00,
    "Total Cost": 1.00,
    "Plan Rows": 100,
    "Plan Width": 32,
    "Actual Startup Time": 0.055,
    "Actual Total Time": 0.056,
    "Actual Rows": 2,
    "Actual Loops": 1,
    "Output": ["name"],
    "Table Function Call": "XMLTABLE((\'//towns/town\'::text) PASSING (\'<towns><town><name>Toronto</name></town><town><name>Ottawa</name></town></towns>\'::xml) COLUMNS name text)",
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": -5237956010904850426,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.015,
  "Triggers": [
  ],
  "Execution Time": 0.092
}'),
(38, '###### Plan 38: Incremental Sort',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 67.50,
    "Total Cost": 69.11,
    "Plan Rows": 31,
    "Plan Width": 8,
    "Actual Startup Time": 0.658,
    "Actual Total Time": 0.668,
    "Actual Rows": 31,
    "Actual Loops": 1,
    "Output": ["(((i.i / 100) + 1))", "((i.i + 1))"],
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Incremental Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 67.50,
        "Total Cost": 119.38,
        "Plan Rows": 1000,
        "Plan Width": 8,
        "Actual Startup Time": 0.657,
        "Actual Total Time": 0.661,
        "Actual Rows": 31,
        "Actual Loops": 1,
        "Output": ["(((i.i / 100) + 1))", "((i.i + 1))"],
        "Sort Key": ["(((i.i / 100) + 1))", "((i.i + 1))"],
        "Presorted Key": ["(((i.i / 100) + 1))"],
        "Full-sort Groups": {
          "Group Count": 1,
          "Sort Methods Used": ["top-N heapsort"],
          "Sort Space Memory": {
            "Average Sort Space Used": 26,
            "Peak Sort Space Used": 26
          }
        },
        "Pre-sorted Groups": {
          "Group Count": 1,
          "Sort Methods Used": ["top-N heapsort"],
          "Sort Space Memory": {
            "Average Sort Space Used": 26,
            "Peak Sort Space Used": 26
          }
        },
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Sort",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Async Capable": false,
            "Startup Cost": 67.33,
            "Total Cost": 69.83,
            "Plan Rows": 1000,
            "Plan Width": 8,
            "Actual Startup Time": 0.567,
            "Actual Total Time": 0.579,
            "Actual Rows": 101,
            "Actual Loops": 1,
            "Output": ["(((i.i / 100) + 1))", "((i.i + 1))"],
            "Sort Key": ["(((i.i / 100) + 1))"],
            "Sort Method": "quicksort",
            "Sort Space Used": 71,
            "Sort Space Type": "Memory",
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Function Scan",
                "Parent Relationship": "Outer",
                "Parallel Aware": false,
                "Async Capable": false,
                "Function Name": "generate_series",
                "Schema": "pg_catalog",
                "Alias": "i",
                "Startup Cost": 0.00,
                "Total Cost": 17.50,
                "Plan Rows": 1000,
                "Plan Width": 8,
                "Actual Startup Time": 0.068,
                "Actual Total Time": 0.347,
                "Actual Rows": 1000,
                "Actual Loops": 1,
                "Output": ["((i.i / 100) + 1)", "(i.i + 1)"],
                "Function Call": "generate_series(0, 999)",
                "Shared Hit Blocks": 0,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Query Identifier": -2200701423380060001,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.067,
  "Triggers": [
  ],
  "Execution Time": 1.029
}'),
(39, '###### Plan 39: Named Tuplestore Scan',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.02,
    "Total Cost": 0.03,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 0.005,
    "Actual Total Time": 0.006,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Named Tuplestore Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Async Capable": false,
        "Startup Cost": 0.00,
        "Total Cost": 0.02,
        "Plan Rows": 1,
        "Plan Width": 4,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.001,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  }
}'),
(40, '###### Plan 40: Parallel Seq Scan',
 '{
  "Plan": {
    "Node Type": "Gather",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.00,
    "Total Cost": 21845.68,
    "Plan Rows": 1814322,
    "Plan Width": 36,
    "Actual Startup Time": 1.217,
    "Actual Total Time": 60.905,
    "Actual Rows": 100000,
    "Actual Loops": 1,
    "Output": ["a", "b"],
    "Workers Planned": 2,
    "Workers Launched": 2,
    "Single Copy": false,
    "Shared Hit Blocks": 14286,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": true,
        "Async Capable": false,
        "Relation Name": "lt1",
        "Schema": "public",
        "Alias": "lt1",
        "Startup Cost": 0.00,
        "Total Cost": 21845.68,
        "Plan Rows": 755968,
        "Plan Width": 36,
        "Actual Startup Time": 0.022,
        "Actual Total Time": 23.673,
        "Actual Rows": 33333,
        "Actual Loops": 3,
        "Output": ["a", "b"],
        "Shared Hit Blocks": 14286,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Workers": [
          {
            "Worker Number": 0,
            "Actual Startup Time": 0.022,
            "Actual Total Time": 24.814,
            "Actual Rows": 32886,
            "Actual Loops": 1,
            "Shared Hit Blocks": 4698,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Worker Number": 1,
            "Actual Startup Time": 0.024,
            "Actual Total Time": 23.164,
            "Actual Rows": 28782,
            "Actual Loops": 1,
            "Shared Hit Blocks": 4112,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": -2173258692264587393,
  "Planning": {
    "Shared Hit Blocks": 3,
    "Shared Read Blocks": 3,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 3,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.204,
  "Triggers": [
  ],
  "Execution Time": 74.754
}'),
(41, '###### Plan 41: Parallel Index Scan',
 '{
  "Plan": {
    "Node Type": "Gather",
    "Parallel Aware": false,
    "Async Capable": false,
    "Startup Cost": 0.29,
    "Total Cost": 11.61,
    "Plan Rows": 99,
    "Plan Width": 12,
    "Actual Startup Time": 0.264,
    "Actual Total Time": 11.152,
    "Actual Rows": 100,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Workers Planned": 1,
    "Workers Launched": 1,
    "Single Copy": false,
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": true,
        "Async Capable": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 11.61,
        "Plan Rows": 58,
        "Plan Width": 12,
        "Actual Startup Time": 0.008,
        "Actual Total Time": 0.048,
        "Actual Rows": 50,
        "Actual Loops": 2,
        "Output": ["a", "b", "c"],
        "Index Cond": "(tt1.a < 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Workers": [
          {
            "Worker Number": 0,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.002,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Query Identifier": 6302439199124405535,
  "Planning": {
    "Shared Hit Blocks": 3,
    "Shared Read Blocks": 1,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.244,
  "Triggers": [
  ],
  "Execution Time": 11.311
}'),
(42, '###### Plan 42: Gather Merge',
 '{
  "Plan": {
    "Node Type": "Index Only Scan",
    "Parallel Aware": false,
    "Async Capable": false,
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.29,
    "Total Cost": 598.30,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 0.016,
    "Actual Total Time": 11.334,
    "Actual Rows": 10000,
    "Actual Loops": 1,
    "Output": ["a"],
    "Heap Fetches": 19901,
    "Shared Hit Blocks": 19886,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Query Identifier": 3925354080679300393,
  "Planning": {
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.076,
  "Triggers": [
  ],
  "Execution Time": 12.359
}'));

\pset pager
\set ECHO queries

\echo ###### set shortened JSON
UPDATE plans SET splan = pg_store_plans_shorten(lplan);

\echo ###### tag abbreviation test
SELECT splan FROM plans WHERE id in (-1, -2);

\echo ###### JSON properties round-trip test: !!! This shouldn''''t return a row
SELECT id FROM plans
	where pg_store_plans_jsonplan(splan) <> lplan;

\pset format unaligned
\pset tuples_only on
\pset recordsep '\n\n=======\n'
\echo  ###### format conversion tests
SELECT '### '||'yaml-short       '||title||E'\n'||
  pg_store_plans_yamlplan(splan)
  FROM plans WHERE id BETWEEN 1 AND 3 or id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-short        '||title||E'\n'||
  pg_store_plans_xmlplan(splan)
  FROM plans WHERE id BETWEEN 4 AND 6 or id = 1 ORDER BY id;

\echo  ###### text format output test
SELECT '### '||'TEXT-short       '||title||E'\n'||
  pg_store_plans_textplan(splan)
  FROM plans WHERE id >= 0 ORDER BY id;


\echo  ###### long-json-as-a-source test
SELECT '### '||'yaml-long JSON   '||title||E'\n'||
  pg_store_plans_yamlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-long JSON    '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-long JSON   '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;

\echo  ###### chopped-source test
SELECT '### '||'inflate-chopped  '||title||E'\n'||
  pg_store_plans_jsonplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 16 AND 18 ORDER BY id;
\echo  ################## 
SELECT '### '||'yaml-chopped     '||title||E'\n'||
  pg_store_plans_yamlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 19 AND 21 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-chopped      '||title||E'\n'||
  pg_store_plans_xmlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 22 AND 24 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-chopped     '||title||E'\n'||
  pg_store_plans_textplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 25 AND 27 ORDER BY id;

\echo ###### shorten test
SELECT '### '||'shorten          '||title||E'\n'||
  pg_store_plans_shorten(lplan)
  FROM plans WHERE id = -2 ORDER BY id;
\echo ###### normalize test
SELECT '### '||'normalize        '||title||E'\n'||
  pg_store_plans_normalize(lplan)
  FROM plans ORDER BY id;

