package jp.gr.java_conf.miya.pglauncher.dialogs;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProgramTreeDropAdapter extends ViewerDropAdapter {
	
	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private ConfigDialog dialog_;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public ProgramTreeDropAdapter(ConfigDialog dialog,
									TreeViewer viewer) {
		super(viewer);
		dialog_ = dialog;
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public boolean performDrop(Object data) {
		TreeViewer viewer = (TreeViewer)getViewer();
		Element el = TreeUtils.getSelectedElement(viewer);
		
		Element target = (Element)getCurrentTarget();
		if (target == null) target = (Element)getViewer().getInput();
		
		if(getCurrentLocation() == LOCATION_NONE) return false;
		
		if(el.equals(target)) return false;
		
		if(target.getNodeName().equals(Const.NODE_ROOT)){
			switch(getCurrentLocation()){
				case LOCATION_AFTER:
				case LOCATION_BEFORE:
					return false;
			}
		}
		
		Element el2 = target;
		while(true){
			if(el2.getNodeName().equals(Const.NODE_ROOT)) break;
			el2 = (Element)el2.getParentNode();
			if(el.equals(el2)) return false;
		}
		
		el.getParentNode().removeChild(el);
		
		switch(getCurrentLocation()){
			case LOCATION_ON:
				target.appendChild(el);
				break;
			case LOCATION_AFTER:
				NodeList list = target.getParentNode().getChildNodes();
				for(int i = 0;i < list.getLength();i++){
					Node node = list.item(i);
					if(node == target){
						if(i + 1 == list.getLength()){
							target.getParentNode().appendChild(el);
						}else{
							target.getParentNode().insertBefore(el,list.item(i + 1));
						}
						break;
					}
				}
				break;
			case LOCATION_BEFORE:
				list = target.getParentNode().getChildNodes();
				for(int i = 0;i < list.getLength();i++){
					Node node = list.item(i);
					if(node == target){
						target.getParentNode().insertBefore(el,target);
						break;
					}
				}
				break;
		}
		viewer.refresh();
		dialog_.modified();
		
		return true;
	}

	public boolean validateDrop(Object target,
									int operation,
									TransferData type) {
		if(ProgramTransfer.getInstance().isSupportedType(type)){
			Element el = (Element)target;
			if(getCurrentLocation() == LOCATION_ON){
				if(el.getNodeName().equals(Const.NODE_PROGRAM) ||
						el.getNodeName().equals(Const.NODE_FOLDER)){
					return false;
				}
			}
			return true;
		}
		return false;
	}
}
