package jp.gr.java_conf.miya.pglauncher.actions;

import java.io.File;
import java.io.IOException;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchWindow;


public class ProgramAction extends Action {
	
	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private String path_;
	private String arg_;
	private boolean isExe_;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public ProgramAction(String name, String path, String arg){
		setText(name);
		path_ = path;
		arg_ = arg;
		ImageDescriptor imgDesc = ImageUtils.getImageDescriptorFromProgram(path);
		if(imgDesc == null){
			String extension = path.substring(path.lastIndexOf(".") + 1);
			if(extension.equalsIgnoreCase(Const.ICON_EXE)){
				imgDesc = ImageUtils.getImageDescriptorFromIcon(Const.ICON_EXE);
			}else{
				imgDesc = ImageUtils.getImageDescriptorFromIcon(Const.ICON_UNKOWN);
			}
		}
		setImageDescriptor(imgDesc);
	}

	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		
		WorkbenchWindow workbenchWindow = (WorkbenchWindow)PGLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		IStatusLineManager lineManager = workbenchWindow.getActionBars().getStatusLineManager();
		
		File file = new File(path_);
		if(!file.exists()){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									getText() + " Ŏw肳ꂽpX݂܂B");
			return;
		}
		
		int delim = path_.lastIndexOf("\\");
		int slash = path_.lastIndexOf("/");
		if(slash > delim) delim = slash;
		File dir = new File(path_.substring(0,delim));
		
		try{
			Process proc = null;
			if(arg_ == null || arg_.equals("")){
				proc = Runtime.getRuntime().exec("\"" + path_ + "\"",null,dir);
			}else{
				proc = Runtime.getRuntime().exec("\"" + path_ + "\" " + arg_,null,dir);
			}
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_RUN),
					getText() + " N܂B");
		}catch(IOException e){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									getText() + " ̋NɎs܂B");
		}
	}
}
