package jp.gr.java_conf.miya.pglauncher.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.utils.ImageUtils;


import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.internal.WorkbenchWindow;

public class FolderAction extends Action {
	
	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private String path_;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public FolderAction(String name, String path){
		setText(name);
		path_ = path;
		setImageDescriptor(ImageUtils.getImageDescriptorFromIcon(Const.ICON_FOLDER));
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		WorkbenchWindow workbenchWindow = (WorkbenchWindow)PGLauncherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		IStatusLineManager lineManager = workbenchWindow.getActionBars().getStatusLineManager();
		
		File file = new File(path_);
		if(!file.exists()){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									getText() + " Ŏw肳ꂽpX݂܂B");
			return;
		}
		
		try{
			Process proc = Runtime.getRuntime().exec("explorer /e ,\"" + path_ + "\"");
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_RUN),
					getText() + " tH_\܂B");
		}catch(IOException e){
			lineManager.setMessage(ImageUtils.getImageFromIcon(Const.ICON_ERROR),
									getText() + " tH_J܂łB");
		}
	}
}
