/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.actions.ConfigAction;
import jp.gr.java_conf.miya.pglauncher.actions.FolderAction;
import jp.gr.java_conf.miya.pglauncher.actions.ProgramAction;
import jp.gr.java_conf.miya.pglauncher.utils.XMLUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PGLauncherAction
implements IWorkbenchWindowPulldownDelegate {
    private IWorkbenchWindow window_;
    private ConfigAction config_;
    private Separator separator_;

    public Menu getMenu(Control parent) {
        return this._createMenu(parent);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window_ = window;
        this.config_ = new ConfigAction((Control)window.getShell());
        this.separator_ = new Separator();
    }

    public void run(IAction action) {
        this.getMenu((Control)this.window_.getShell()).setVisible(true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private Menu _createMenu(Control control) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Element node = XMLUtils.getInstance().loadDocument().getDocumentElement();
                PGLauncherAction.this._addMenu(node, manager);
                manager.add((IContributionItem)PGLauncherAction.this.separator_);
                manager.add((IAction)PGLauncherAction.this.config_);
            }
        });
        control.setMenu(manager.createContextMenu(control));
        return control.getMenu();
    }

    private void _addMenu(Node node, IMenuManager manager) {
        if (node.getNodeName().equals("pglauncher")) {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                this._addMenu(list.item(i), manager);
                ++i;
            }
        } else if (node.getNodeName().equals("group")) {
            NamedNodeMap attrMap = node.getAttributes();
            String name = attrMap.getNamedItem("name").getNodeValue();
            MenuManager group = new MenuManager(name);
            manager.add((IContributionItem)group);
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                this._addMenu(list.item(i), (IMenuManager)group);
                ++i;
            }
        } else if (node.getNodeName().equals("program")) {
            NamedNodeMap attrMap = node.getAttributes();
            String name = attrMap.getNamedItem("name").getNodeValue();
            String path = attrMap.getNamedItem("path").getNodeValue();
            String arg = attrMap.getNamedItem("arg").getNodeValue();
            manager.add((IAction)new ProgramAction(name, path, arg));
        } else if (node.getNodeName().equals("folder")) {
            NamedNodeMap attrMap = node.getAttributes();
            String name = attrMap.getNamedItem("name").getNodeValue();
            String path = attrMap.getNamedItem("path").getNodeValue();
            manager.add((IAction)new FolderAction(name, path));
        }
    }
}

