<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwSmartyView.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwSmartyView.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwSmartyView extends xbpwAbstractView
{
    /** Templates directory path */
    var $templatesDir = '';

    /**
     * Smarty instance
     *
     * @access private
     * @var object
     */
    var $smarty = null;

    /**
     * Result string
     *
     * @access private
     * @var string
     */
    var $result = null;

    /**
     * Initialize view instance.
     *
     * @access public
     * @param array $config
     * @return boolean
     */
    function init($config)
    {
        $smartyClass = '';
        $templateDir = '';
        $compileDir = '';
        $configDir = '';
        $cacheDir = '';
        $pluginsDir = '';

        if (isset($config['_pw_template_class'])) {
            $smartyClass = $config['_pw_template_class'];
        }
        else {
            trigger_error("Configuration parameter '_pw_template_class' is not defined.", E_USER_ERROR);
        }
        if (isset($config['_pw_template_templates_dir'])) {
            $templateDir = $config['_pw_template_templates_dir'];
        }
        if (isset($config['_pw_template_compile_dir'], $config)) {
            $compileDir = $config['_pw_template_compile_dir'];
        }
        if (isset($config['_pw_template_config_dir'], $config)) {
            $configDir = $config['_pw_template_config_dir'];
        }
        if (isset($config['_pw_template_cache_dir'], $config)) {
            $cacheDir = $config['_pw_template_cache_dir'];
        }
        if (isset($config['_pw_template_plugins_dir'])) {
            $pluginsDir = $config['_pw_template_plugins_dir'];
        }
        if (!class_exists('Smarty')) {
            require_once $smartyClass;
        }
        $this->smarty = new Smarty;
        //$this->smarty->load_filter('output', 'trimwhitespace');
        $this->smarty->template_dir = $templateDir;
        $this->smarty->compile_dir = $compileDir;
        $this->smarty->config_dir = $configDir;
        $this->smarty->cache_dir = $cacheDir;
        $this->templatesDir = $templateDir;

        if ($pluginsDir == '') {
            $pluginsDir = array('plugins',
                                PW_CORE_DIR . DS . 'util' . DS . 'smarty.plugins');
        }
        else {
            $pluginsDir = array('plugins',
                                PW_CORE_DIR . DS . 'util' . DS . 'smarty.plugins',
                                $pluginsDir);
        }
        $this->smarty->plugins_dir = $pluginsDir;

        return true;
    }

    /**
     * Merge model data with template.
     *
     * @access public
     * @param string $template Path to template file
     * @param array $model Array of model values
     * @return boolean
     */
    function dispatch($template, $model, $pwProperty)
    {
        //pw core parameter
        foreach ($pwProperty as $key => $value) {
            if (is_object($value)) {
                $this->smarty->assign_by_ref($key, $value);
            } else {
                $this->smarty->assign($key, $value);
            }
        }
        //model parameter
        foreach ($model as $key => $value) {
            if (is_object($value)) {
                $this->smarty->assign_by_ref($key, $value);
            } else {
                $this->smarty->assign($key, $value);
            }
        }

        $default_layout = '';
        if($pwProperty['_pw_layout_template']){
            if(strtolower($pwProperty['_pw_layout_template'])!='none') {
                $default_layout = $this->templatesDir . DS . 'layout/' . $pwProperty['_pw_layout_template'] . '.tpl';
            }
        }

        //setting metaheaders
        $meta_headers   = array();
        $meta_headers[] = "<meta http-equiv='Pragma' content='no-cache'>";
        $meta_headers[] = "<meta http-equiv='Cache-Control' content='no-cache'>";
        $meta_headers[] = "<meta http-equiv='Expires' content='0'>";
        $meta_headers[] = "<meta http-equiv='Content-Type' content='text/html; charset=" . PW_HTML_META_CHARSET . "'>";
        $pw->meta_headers = implode("\n", $meta_headers)."\n";

        //template type
        $template_dir = $pwProperty['_pw_template'];
        if ($template_dir!='') {
            $template_dir .= '/';
        }

        //スタイルシート
        $css_headers = array();
        foreach ($pwProperty['_pw_css'] as $key=>$val) {
            if ($val=='screen' || $val=='print') {
                $file = $template_dir . $key;
                if (defined('PW_WEB_ALIAS')) {
                    if (strlen(PW_WEB_ALIAS) > 0) {
                        $file = '/' . PW_WEB_ALIAS . '/' . $template_dir . $key;
                    }
                    else { //PW_WEB_ALIASがdefineしてあるが、空の場合
                        $file = '/' . $template_dir . $key;
                    }
                }
                $css_headers[] = "<link rel='stylesheet' media='" . $val . "' type='text/css' href='" . $file . "' />";
            }
            else {
                $file = $template_dir . $val;
                if (defined('PW_WEB_ALIAS')) {
                    if (strlen(PW_WEB_ALIAS) > 0) {
                        $file = '/' . PW_WEB_ALIAS . '/' . $template_dir . $val;
                    }
                    else { //PW_WEB_ALIASがdefineしてあるが、空の場合
                        $file = '/' . $template_dir . $val;
                    }
                }
                $css_headers[] = "<link rel='stylesheet' type='text/css' href='" . $file . "' />";
            }
        }
        $this->smarty->assign('_css_headers', implode("\n", $css_headers)."\n");

       //JSファイル
        $js_headers = array();
        foreach ($pwProperty['_pw_jscript'] as $val) {
            $file = $template_dir . $val;
            if (defined('PW_WEB_ALIAS')) {
                if (strlen(PW_WEB_ALIAS) > 0) {
                    $file = '/' . PW_WEB_ALIAS . '/' . $template_dir . $val;
                }
                else { //PW_WEB_ALIASがdefineしてあるが、空の場合
                    $file = '/' . $template_dir . $val;
                }
            }
            $js_headers[] = "<script language='javascript' src='" . $file . "' ></script>";
        }
        $this->smarty->assign('_js_headers', implode("\n", $js_headers)."\n");


        $layout = $this->templatesDir . DS . $template;
        $contents = null;
        if(file_exists($default_layout)){
            ob_start();
            $pw->contents = $this->smarty->fetch($template);
            ob_end_clean();
            $contents = $default_layout;
        }
        else{
            $contents = $layout;
        }

        //default layout reader
        ob_start();
        $this->result = $this->smarty->fetch($contents);
        ob_end_clean();
        return true;
    }

    /**
     * Returns result string
     *
     * @access public
     * @return string
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * Returns whether template file exists.
     *
     * @access public
     * @return boolean
     */
    function isTemplateExists($template)
    {
        return $this->smarty->template_exists($template);
    }
}
