<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    pettiwork.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: pettiwork.php 20 2008-07-14 02:16:24Z simizu001 $
 * @copyright 2007-2008 Exbridge,Inc.
 */
define('DS', DIRECTORY_SEPARATOR);
define('PS', PATH_SEPARATOR);

define('PW_VERSION', '0.9.0');
define('PW_SESSION_GLOBAL_KEY', 'jp.pettiwork.session.global');
define('PW_SESSION_FLASH_KEY', 'jp.pettiwork.session.flash');
define('PW_SESSION_USER_KEY', 'jp.pettiwork.session.user');

define('PW_WEBACCESS_KEY', 'webaccess');
define('PW_ACTION_KEY',    'action');

define('PW_CONTINUE_PROCESS',  1);
define('PW_TERMINATE_PROCESS', 2);

define('PW_CORE_INCLUDE_DIR', PW_ROOT_DIR);
define('PW_CORE_DIR', PW_ROOT_DIR . DS . 'pettiwork');

if (!defined('PW_PREFIX')) {//template prefix dir etc...
    define('PW_PREFIX', '');
}
if (!defined('PW_CTL')) {//custorm controller prefix dir
    define('PW_CTL', PW_PREFIX);
}
if (!defined('PW_SRV')) {//service prefix dir
    define('PW_SRV', '');
}

try {
    require_once(PW_ROOT_DIR . DS . 'config.php');
    require_once(PW_CORE_DIR . DS . 'xbpwException.php');

    //system setting define
    if (!defined('PW_CORE_LIBRALY_CACHE')) {
        define('PW_CORE_LIBRALY_CACHE', true);
    }
    if (!defined('PW_APP_CONFIG_DIR')) {
        define('PW_APP_CONFIG_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'config');
    }
    if (!defined('PW_APP_CONTROLLER_DIR')) {
        define('PW_APP_CONTROLLER_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'controllers');
    }
    if (!defined('PW_APP_LIBRALY_DIR')) {
        define('PW_APP_LIBRALY_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'lib');
    }
    if (!defined('PW_APP_MODELS_DIR')) {
        define('PW_APP_MODELS_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'models');
    }
    if (!defined('PW_APP_SERVICES_DIR')) {
        define('PW_APP_SERVICES_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'services');
    }
    if (!defined('PW_APP_VALIDATORS_DIR')) {
        define('PW_APP_VALIDATORS_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'validators');
    }
    if (!defined('PW_APP_VIEWS_DIR')) {
        define('PW_APP_VIEWS_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'views');
    }
    if (!defined('PW_APP_WEB_DIR')) {
        define('PW_APP_WEB_DIR', PW_ROOT_DIR . DS . 'app' . DS . 'web');
    }
    if (!defined('PW_VENDORS_DIR')) {
        define('PW_VENDORS_DIR', PW_ROOT_DIR . DS . 'vendors');
    }
    if (!defined('PW_TMP_DIR')) {
        define('PW_TMP_DIR', PW_ROOT_DIR . DS . 'tmp');
    }

    define('PW_PEAR_INCLUDE_DIR', PW_VENDORS_DIR . DS . 'pear');
    if (function_exists('ini_set')) {
        //ini_set('include_path', ini_get('include_path') . PS . PW_CORE_INCLUDE_DIR . PS . PW_PEAR_INCLUDE_DIR);
        ini_set('include_path', PW_CORE_INCLUDE_DIR . PS . PW_PEAR_INCLUDE_DIR);
    }

    //not exsists cache file
    if (PW_CORE_LIBRALY_CACHE && file_exists(PW_TMP_DIR . DS . 'cache')) {
        $autoload_file = 'autoloading.cache';
        if (PW_PREFIX != '') {
            $autoload_file = 'autoloading.' . PW_PREFIX . '.cache';
        }
        $cache_file = PW_TMP_DIR . DS . 'cache' . DS . $autoload_file;

        if (!file_exists($cache_file)) {
            $contents = array();
            $contents[] = '<?php return array(';
            contents_list($contents);
            $contents[] = ');';
            @fclose(@fwrite(@fopen($cache_file, 'w'), @implode(chr(10), $contents)));
        }
        $cache_list = include($cache_file);
        foreach ($cache_list as $file) {
            require_once(addslashes($file));
        }
    }
    else {
        $cache_list = contents_list();
        foreach ($cache_list as $file) {
            require_once($file);
        }
    }

    //application setting define
    if (!defined('PW_DEBUG')) {
        define('PW_DEBUG', false);
    }
    if (!defined('PW_HTML_META_CHARSET')) {
        define('PW_HTML_META_CHARSET', 'UTF-8');
    }
    if (!defined('PW_ENCODE')) {
        define('PW_ENCODE', PW_HTML_META_CHARSET);
    }
    if (!defined('PW_MOBILE_ENCODE')) {
        define('PW_MOBILE_ENCODE', PW_ENCODE);
    }
    if (!defined('PW_CSV_ENCODE')) {
        define('PW_CSV_ENCODE', PW_ENCODE);
    }
    if (!defined('PW_TEMPLATE_AUTO_CONVERT')) {
        define('PW_TEMPLATE_AUTO_CONVERT', false);
    }
    if (!defined('PW_ERROR_MAIL_SENDER')) {
        define('PW_ERROR_MAIL_SENDER', false);
    }
    if (!defined('PW_EXCEPTION_DISABLED')) {
        define('PW_EXCEPTION_DISABLED', false);
    }
    if (!defined('PW_TEMPLATE_ENGINE')) {
        define('PW_TEMPLATE_ENGINE', 'Default');
    }
    if (!defined('PW_LAYOUT_TEMPLATE')) {
        define('PW_LAYOUT_TEMPLATE', '');
    }
    if (!defined('PW_LANGUAGE')) {
        define('PW_LANGUAGE', 'jp');
    }
    if (!defined('PW_DISABLE_SESSION')) {
        define('PW_DISABLE_SESSION', false);
    }
    if (!defined('PW_SESSION_NAME')) {
        define('PW_SESSION_NAME', 'pettiwork');
    }
    if (!defined('PW_SESSION')) {
        define('PW_SESSION', 'php');
    }
    if (!defined('PW_DYNAMIC_VALUE_OBJECT')) {
        define('PW_DYNAMIC_VALUE_OBJECT', true);
    }
    if (!defined('PW_VALUE_OBJECT_CACHE_DIR')) {
        define('PW_VALUE_OBJECT_CACHE_DIR', PW_TMP_DIR . DS . 'values');
    }
    if (!defined('PW_DATABASE_CONNECTOR_MODE')) {
        define('PW_DATABASE_CONNECTOR_MODE', '0');
    }

    if (strtolower(PW_TEMPLATE_ENGINE) == 'smarty') {
        define('PW_TEMPLATE_CLASS', PW_VENDORS_DIR . DS . 'smarty' . DS . 'libs' . DS . 'Smarty.class.php');
        if (!defined('PW_TEMPLATE_COMPILE_DIR')) {
            define('PW_TEMPLATE_COMPILE_DIR', PW_TMP_DIR . DS . 'templates_c');
        }
        if (!defined('PW_TEMPLATE_PLUGINS_DIR')) {
            define('PW_TEMPLATE_PLUGINS_DIR', '');
        }
    }

    if (PW_LAYOUT_TEMPLATE=='') {
        if (PW_PREFIX == '') {
            define('PW_TEMPLATE_TEMPLATES_DIR', PW_APP_VIEWS_DIR);
        }
        else {
            define('PW_TEMPLATE_TEMPLATES_DIR', PW_APP_VIEWS_DIR . DS . PW_PREFIX);
        }
    }
    else {
        if (PW_PREFIX == '') {
            define('PW_TEMPLATE_TEMPLATES_DIR', PW_APP_VIEWS_DIR . DS . PW_LAYOUT_TEMPLATE);
        }
        else {
            define('PW_TEMPLATE_TEMPLATES_DIR', PW_APP_VIEWS_DIR . DS . PW_PREFIX . DS . PW_LAYOUT_TEMPLATE);
        }
    }

    //language file reading
    $lang_file = PW_APP_CONFIG_DIR . DS . 'language.' . PW_LANGUAGE . '.inc';
    if (PW_PREFIX != '') {
        $lang_file = PW_APP_CONFIG_DIR . DS . PW_PREFIX . DS . 'language.' . PW_LANGUAGE . '.inc';
    }
    if (file_exists($lang_file)) {
        require_once($lang_file);
    }

    //connect db
    $_pw_db;
    $_pw_somfa_conf = PW_APP_CONFIG_DIR . DS . 'database.inc';
    if (PW_PREFIX != '') {
        $_pw_somfa_conf = PW_APP_CONFIG_DIR . DS . PW_PREFIX . DS . 'database.inc';
    }
    if (file_exists($_pw_somfa_conf)) {
        if (!isset($_pw_db)) {
            require_once(PW_VENDORS_DIR . DS . 'adodb' . DS . 'adodb.inc.php');
            require_once(PW_VENDORS_DIR . DS . 'somfa' . DS . 'somfa.php');
            $_pw_db = & new somfa(include($_pw_somfa_conf), PW_DATABASE_CONNECTOR_MODE);
        }
    }
}
catch (Exception $e) {
    throw $e;
}

function file_walker($dir, $contents, $ext='php') {
    $file_list = array();
    if (intval(str_replace('.', '', PHP_VERSION)) > '500') {
        $file_list = scandir($dir);
    }
    else {
        //php4用
        $dh  = opendir($dir);
        while (false !== ($filename = readdir($dh))) {
            $file_list[] = $filename;
        }
        sort($file_list);
    }

    if ($file_list != FALSE) {
        foreach ($file_list as $key => $value) {
            if ($value == '.' || $value == '..') {
                continue;
            }
            $file = $dir . DS . $value;
            if (is_file($file)) {
                $pathInfo = pathinfo($file);
                if (strtolower($pathInfo['extension']) == $ext) {
                    if (PW_CORE_LIBRALY_CACHE && file_exists(PW_TMP_DIR . DS . 'cache')) {
                        $contents[] = "'" . $value . "' => '" . $file . "',";
                    }
                    else {
                        $contents[] = $file;
                    }
                }
            }
            else {
                $contents = file_walker($file, $contents);
            }
        }
    }
    return $contents;
}

function contents_list(&$contents=array()) {
    $config_dir = PW_APP_CONFIG_DIR;
    if (PW_PREFIX != '') {
        $config_dir = PW_APP_CONFIG_DIR . DS . PW_PREFIX;
    }
    $contents = file_walker($config_dir, $contents);
    $contents = file_walker(PW_CORE_DIR, $contents);
    if (file_exists(PW_APP_LIBRALY_DIR)) {
        $contents = file_walker(PW_APP_LIBRALY_DIR, $contents);
    }
    return $contents;
}
