<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwDefaultView.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwDefaultView.php 3 2008-07-01 10:08:07Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwDefaultView extends xbpwAbstractView
{
    /** Templates directory path */
    var $templatesDir = '';

    /** Result string */
    var $result = null;

    /**
     * Initialize view instance.
     * @access public
     * @param array $config Configuration values
     * @return boolean
     */
    function init($config)
    {
        if (!isset($config['_pw_template_templates_dir'])) {
            if (PW_EXCEPTION_DISABLED) {
                trigger_error("Configuration parameter '_pw_template_templates_dir' is not defined.", E_USER_ERROR);
            }
            else {
                throw new xbpwException(E_USER_ERROR, "Configuration parameter '_pw_template_templates_dir' is not defined.");
            }
        }
        $templatesDir = $config['_pw_template_templates_dir'];
        if (substr($templatesDir, strlen($templatesDir) - 2, 1) === DS) {
            $templatesDir = substr($templatesDir, 0, strlen($templatesDir) - 2);
        }
        $this->templatesDir = $templatesDir;
        return true;
    }

    /**
     * @access public
     * @param string $template Path to template file
     * @param array $model Array of model values
     * @return boolean
     */
    function dispatch($template, $model, $pwProperty)
    {
        //pw core parameter
        $pw =& new xbpwDefaultViewModel;
        foreach ($pwProperty as $name => $value) {
            $pw->$name = $value;
        }
        //model parameter
        $m =& new xbpwDefaultViewModel;
        foreach ($model as $name => $value) {
            $m->$name = $value;
        }

        $default_layout = '';
        if ($pwProperty['_pw_layout_template']) {
            if (strtolower($pwProperty['_pw_layout_template'])!='none') {
                $default_layout = $this->templatesDir . DS . 'layout/' . $pwProperty['_pw_layout_template'] . '.tpl';
            }
        }

        //setting metaheaders
        $meta_headers   = array();
        $meta_headers['Pragma'] = "<meta http-equiv='Pragma' content='no-cache'>";
        $meta_headers['Cache-Control'] = "<meta http-equiv='Cache-Control' content='no-cache'>";
        $meta_headers['Expires'] = "<meta http-equiv='Expires' content='0'>";
        $meta_headers['Content-Type'] = "<meta http-equiv='Content-Type' content='text/html; charset=" . PW_HTML_META_CHARSET . "'>";
        foreach ($pwProperty['_pw_meta_header'] as $key=>$val) {
            $meta_headers[$key] = "<meta http-equiv='" . $key . "' content='" . $val . "'>";
        }
        $pw->_meta_headers = implode("\n", $meta_headers)."\n";

        //template type
        $template_dir = $pwProperty['_pw_template'];
        if ($template_dir!='') {
            $template_dir .= '/';
        }

        $path = '';
        if (defined('PW_WEB_ALIAS')) {
            $path = '/' . PW_WEB_ALIAS . '/';
        }

        //スタイルシート
        $css_headers = array();
        foreach ($pwProperty['_pw_css'] as $key=>$val) {
            if ($val=='screen' || $val=='print') {
                $file = $path . $template_dir . $key;
                $css_headers[] = "<link rel='stylesheet' media='" . $val . "' type='text/css' href='" . $file . "' />";
            }
            else {
                $file = $path . $template_dir . $val;
                $css_headers[] = "<link rel='stylesheet' type='text/css' href='" . $file . "' />";
            }
        }
        $pw->_css_headers = implode("\n", $css_headers)."\n";

       //JSファイル
        $js_headers = array();
        foreach ($pwProperty['_pw_jscript'] as $val) {
            $file = $path . $template_dir . $val;
            $js_headers[] = "<script language='javascript' src='" . $file . "' ></script>";
        }
        $pw->_js_headers = implode("\n", $js_headers)."\n";

        $conv = false;
        if (PW_TEMPLATE_AUTO_CONVERT) {
            require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Net'. DS . 'UserAgent'. DS . 'Mobile.php');
            if (Net_UserAgent_Mobile::isMobile()) {
                $conv = true;
            }
        }

        $layout = $this->templatesDir . DS . $template;
        $contents = null;
        if (file_exists($default_layout)) {
            ob_start();
            require_once $layout;
            $pw->contents = ob_get_contents();
            ob_end_clean();
            //if ($conv) {
            //    $pw->contents = mb_convert_encoding($pw->contents, PW_MOBILE_ENCODE, PW_ENCODE);
            //}
            $contents = $default_layout;
        }
        else {
            $contents = $layout;
        }

        //default layout reader
        ob_start();
        require_once $contents;
        $this->result = ob_get_contents();
        ob_end_clean();
        if ($conv) {
            $this->result = mb_convert_encoding($this->result, PW_MOBILE_ENCODE, PW_ENCODE);
        }
        return true;
    }

    /**
     * @access public
     * @return string
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * @access public
     * @return boolean
     */
    function isTemplateExists($template)
    {
        return file_exists($this->templatesDir . DS . $template);
    }

    /**
     * @access public
     * @param string $value
     * @return string
     */
    function e($value)
    {
        if (is_string($value)) {
            return htmlspecialchars($value);
        }
        return $value;
    }
}

class xbpwDefaultViewModel
{
}
