<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwZip.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwZip.php 602 2008-06-23 23:37:33Z tajima $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwZip {

    /**
     * Creates new instance.
     * @access public
     */
    function xbpwZip()
    {
    }

    /**
     * create zip file
     *
     * @param array or string $file_array
     * @param string $archive_path
     * @param boolean $del_flg
     * @access public
     */
    public function execute($files, $archive_path, $del_flg=true)
    {
        $archive = addslashes($archive_path);
        $f_list = array();
        if (is_array($files)) {
            foreach ($files as $file) {
                $f_list[] = addslashes($file);
            }
        }
        else {
            $f_list[] = addslashes($files);
        }

        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Archive' . DS . 'Zip.php');
        $zip = new Archive_Zip($archive, true);
        $zip->create($f_list, array("remove_all_path"=>true));
        if ($del_flg) {
            if (is_array($files)) {
                foreach ($files as $file) {
                    unlink($file);
                }
            }
            else {
                unlink($files);
            }
        }
        return true;
    }
}
?>
