<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author Noriaki Koide <advans@mu-fan.com>
 *         S.Tajima<tajima@exbridge.jp> 2007/10/22 change class name etc...
 * @version svn:$Id: somfaModel.php 8755 2008-10-03 05:49:26Z hatanaka $
 * @copyright 2007-2008 Exbridge,inc.
 */
class somfaModel
{
    /**
     * SOMFA Config 
     * @var array
     * @access private
     */
    var $_my_conf = '';

    /**
     * SOMFA Database Instance
     * @access private
     */
    var $_db = null;

    /**
     * ADODB Object
     * @var Object $_con
     * @access private
     */
    var $_con = null;

    /**
     * primary key
     * @var array
     * @access private
     */
    var $_primary_keys = array();

    /**
     * field list
     * @var array
     * @access private
     */
    var $_field_list = array();

    /**
     * value list key
     * @var array
     * @access private
     */
    var $_val_list = array();

    /**
     * prefix name
     * @var string
     * @access private
     */
    var $_prefix_name ='';

    /**
     * table name
     * @var string
     * @access private
     */
    var $_table_name ='';

    /**
     * pager limit rows num 
     * -1: unlimited
     * @var integer
     * @access private
     */
    var $_pager_limit = -1;

    /**
     * limit rows num 
     * -1: unlimited
     * @var integer
     * @access private
     */
    var $_limit = -1;

    /**
     * offset rows num 
     * -1: unlimited
     * @var integer
     * @access private
     */
    var $_offset = -1;

    /**
     * auto insert
     * @var string
     * @access private
     */
    var $_auto_insert_columns = array();

    /**
     * auto update
     * @var string
     * @access private
     */
    var $_auto_update_columns = array();

    /**
     * table Column Details
     * @var array
     * @access private
     */
    var $_column_details = array();

    /**
     * update Column
     * @var array
     * @access private
     */
    var $_update_columns = array();

    /**
     * Construct
     * @return void
     */
    function somfaModel(& $con, $config)
    {
        $this->_my_conf = $config;
        $this->_con = $con;
        $this->_db = new somfaDatabase($this->_my_conf);
        $this->_pager_limit = $this->_my_conf['page_max'];
        $this->_prefix_name = $this->_my_conf['prefix'];
        $this->_auto_insert_columns = $this->_my_conf['auto_insert_columns'];
        $this->_auto_update_columns = $this->_my_conf['auto_update_columns'];
        //add prefix
        if ($this->_prefix_name != '') {
            $this->_table_name = $this->_prefix_name . '.' . $this->_table_name;
        }
    }

    /**
     * _sync.
     * @access private
     * @param array
     */
    function _sync($params)
    {
        if (!is_null($params)) {
            if (!is_array($params)) {
                trigger_error("Model class parameter is not array(_sync).", E_USER_NOTICE);
            }
        }
        foreach ($params as $key => $value) {
            $this->validation($value, $key);
        }
    }

    /**
     * 
     */
    function validation($val, $columnName)
    {
        if (is_null($val)) {
            return;
        }
        $columnName = strtolower($columnName);
        if ($this->$columnName !== strtolower($val)) {
            $this->$columnName = $val;
            $this->_update_columns[$columnName] = strtolower($columnName);
        }
    }

    /**
     * initialize.
     * @access public
     */
    function build_lkey_criteria (& $c, & $pkey, & $vars)
    {
        foreach ($pkey as $key=>$val) {
            $c->addCriterion($key ." = ? ");
            $vars[] = $val;
        }
        return $c;
    }

    /**
     * initialize.
     * @access public
     */
    function build_pkey_criteria(& $c, & $vars)
    {
        foreach ($this->_primary_keys as $primary_key) {
            //if (strlen($this->$primary_key) > 0) {
                $c->addCriterion ($primary_key ." = ? ");
                $vars[] = $this->$primary_key;
            //}
            //else {
            //    if ($this->_column_details[$primary_key]['auto_increment']!='1') {
            //        trigger_error('build_pkey not found pkeys parameter', E_USER_ERROR);
            //        return false;
            //    }
            //}
        }
        return $c;
    }

    /**
     * build.
     * @access private
     */
    function build($c)
    {
        $criteria = array();
        // select ?,?,?.. from tableName
        if (count($c->_select_columns) < 1) {
            $c->_select_columns[] = "*";
        }
        $criteria[] = "SELECT \n" . @implode(", \n", $c->_select_columns) . " \nFROM " . $this->_table_name;
        // where *=* 或は　* like *　など
        if (count($c->_criterion) > 0) {
            $criteria[] = "WHERE " . @implode("\n", $c->_criterion);
        }
        // group by ?,...
        if (count($c->_group_by_columns) > 0) {
            $criteria[] = "GROUP BY \n" . @implode(",\n", $c->_group_by_columns);
        }
        // order by ? ASC,...
        if (count($c->_order_by_columns) > 0) {
            $criteria[] = "ORDER BY \n" . @implode(",\n", $c->_order_by_columns);
        }
        return @implode("\n", $criteria);
    }

    /**
     * retrieveByLK ( logical key )
     * @param array( 'key' => 'value' ... )
     * @return array
     */
    function retrieveByLK($pkey, $output = true)
    {
        require_once('somfaCriteria.php');
        $c = new somfaCriteria();
        $vars = array();
        $results = $this->build_lkey_criteria($c, $pkey, $vars);
        if (!$results) {
            return -1;
        }
        $sql = $this->build($c);
        if (!is_null($sql)) {
            $rs = $this->_db->selectLimit($this->_con, $sql, -1, -1, $vars, $output);
            foreach ($this->_field_list as $key) {
                $this->$key = '';
            }
            unset($this->_update_columns);
            if ($rs) {
                $rd  = $rs->GetArray();
                $cnt = count($rd);
                if ($cnt == 1) {
                    foreach ($rd[0] as $key => $val) {
                        $this->$key = $val;
                    }
                    return $rd[0];
                }
                else if ($cnt > 1) {
                    trigger_error('retrieveByLK many record found', E_USER_ERROR);
                    return $cnt;
                }
                else {
                    return $cnt;
                }
            }
        }
        return -1;
    }

    /**
     * retrieveByPK
     * @param array( 'key' => 'value' ... )
     * @return array
     */
    function retrieveByPK($pkey = false, $output = true)
    {
        if ($pkey) {
            $this->_sync($pkey);
        }
        require_once('somfaCriteria.php');
        $c = new somfaCriteria();
        $vars = array();
        $results = $this->build_pkey_criteria($c, $vars);
        if (!$results) {
            return -1;
        }
        $sql = $this->build($c);
        if (!is_null($sql)) {
            $rs = $this->_db->selectLimit($this->_con, $sql, -1, -1, $vars, $output );
            foreach ($this->_field_list as $key) {
                $this->$key = '';
            }
            unset($this->_update_columns);
            if ($rs) {
                $rd  = $rs->GetArray();
                $cnt = count($rd);
                if ($cnt == 1) {
                    foreach ($rd[0] as $key => $val) {
                        $this->$key = $val;
                    }
                    return $rd[0];
                }
                else if ($cnt > 1) {
                    trigger_error('retrieveByPK many record found', E_USER_ERROR);
                    return $cnt;
                }
                else {
                    return $cnt;
                }
            }
        }
        return -1;
    }

    /**
     * find process.
     * @access public
     */
    function find($c = null, $bindVars = false)
    {
        if (is_null($c)) {
            require_once('somfaCriteria.php');
            $c = new somfaCriteria();
        }
        $sql = $this->build($c);
        if (!is_null($sql)) {
            $rs = $this->_db->selectLimit($this->_con, $sql, $this->_limit, $this->_offset, $bindVars);
            if ($rs) {
                $this->_val_list = $rs->GetArray();
                return $this->_val_list;
            }
        }
        return null;
    }

    /**
     * find process.
     * @access public
     */
    function cache_find($c = null, $bindVars = false)
    {
        if (is_null($c)) {
            require_once('somfaCriteria.php');
            $c = new somfaCriteria();
        }
        $sql = $this->build($c);
        if (!is_null($sql)) {
            $rs = $this->_db->cache_selectLimit($this->_con, $sql, $this->_limit, $this->_offset, $bindVars);
            if ($rs) {
                $this->_val_list = $rs->GetArray();
                return $this->_val_list;
            }
        }
        return null;
    }

    /**
     * exists
     * @return bool
     */
    function exists($param, $lk=null)
    {
        if (is_null($lk)) {
            $ret = $this->retrieveByPK($param, false);
            if (is_array($ret)) {
                return 1;
            }
            return 0;
        }
        else {
            $ret = $this->retrieveByLK($lk, false);
            if (is_array($ret)) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    /**
     * Save 
     * @return bool
     */
    function save($param, $lk=null)
    {
        $ret = $this->exists($param, $lk);
        if ($ret == 0) {
            return $this->insert($param);
        }
        else if ($ret == 1) {
            return $this->update($param, $lk);
        }
        trigger_error('no execute save process ['.$ret.']', E_USER_NOTICE);
        return -1;
    }

    /**
     * Remove 
     * @return bool
     */
    function remove($param)
    {
        $ret = $this->exists($param, $param);
        if ($ret == 1) {
            return $this->delete($param);
        }
        trigger_error('no execute remove process ['.$ret.']', E_USER_NOTICE);
        return -1;
    }

    
    /**
     * insert process.
     * @access public
     */
    function insert ($param)
    {
        $this->_sync($param);
        $ret = $this->_db->execute($this->_con, $this->generateQuery('I'));
        unset($this->_update_columns);
        if ($ret) {
            return 1;
        }
        return -1;
    }

    /**
     * update process.
     * @access public
     */
    function update ($param, $lk=null)
    {
        $this->_sync($param);
        $ret = $this->_db->execute($this->_con, $this->generateQuery('U', $lk));
        unset($this->_update_columns);
        if ($ret) {
            return 2;
        }
        return -1;
    }

    /**
     * delete process.
     * @access public
     */
    function delete($param)
    {
        $this->_sync($param);
        $ret = $this->_db->execute($this->_con, $this->generateQuery('D', $param));
        unset($this->_update_columns);
        if ($ret) {
            return 1;
        }
        return -1;
    }

    /**
     * generateQuery process.
     * @access private
     */
    function generateQuery($type = 'I', $lk=null)
    {
        //generate SET list
        $column_labels = array();
        $column_values = array();
        $column_pkeys  = array();
        foreach ($this->_column_details as $key => $columns) {
            if (strlen($this->$key) == 0) {
                if (!isset($this->_update_columns[$key])) {
                    continue;
                }
            }
            $column_labels[] = $key;

            $mType = $this->_con->MetaType($columns['type']);

            if ($mType=='C' || $mType=='X' || $mType=='D' || $mType=='T') {
                if(strtolower($this->$key) == 'null'){
                    $column_values[$key] = 'null';
                }else{
                    $column_values[$key] = $this->_con->qstr($this->$key,get_magic_quotes_gpc());
                }
                if (is_null($lk[$key])) {
                    if ($columns['primary_key']=='1') {
                        $column_pkeys[$key] = $this->_con->qstr($this->$key,get_magic_quotes_gpc());
                    }
                }
                else {
                    $column_pkeys[$key] = $this->_con->qstr($this->$key,get_magic_quotes_gpc());
                }
            }
            else if ($mType=='I' || $mType=='R' || $mType=='N') {
                if (strlen($this->$key)==0) {
                    $column_values[$key] = $this->$key==''?'null':$this->$key;
                }
                else {
                    $column_values[$key] = $this->$key;
                }
                if (is_null($lk[$key])) {
                    if ($columns['primary_key'] == '1') {
                        $column_pkeys[$key] = $this->$key;
                    }
                }
                else {
                    $column_pkeys[$key] = $lk[$key];
                }
            }
            else {
                if(strtolower($this->$key) == 'null'){
                    $column_values[$key] = 'null';
                }else{
                    $column_values[$key] = $this->_con->qstr($this->$key,get_magic_quotes_gpc());
                }
                if (is_null($lk[$key])) {
                    if ( $columns['primary_key'] == '1' ) {
                        $column_pkeys[$key] = $this->_con->qstr($this->$key,get_magic_quotes_gpc());
                    }
                }
                else {
                    $column_pkeys[$key] = $this->_con->qstr($lk[$key],get_magic_quotes_gpc());
                }
            }
        }
        $field_list = array_flip($this->_field_list);
        //自動設定処理
        if (is_array($this->_auto_update_columns)) {
            foreach ($this->_auto_update_columns as $key => $val) {
                if (isset($field_list[$key])) {
                    $column_labels[] = $key;
                    eval("\$column_values[$key] = \"'\" .$val. \"'\";");
                }
            }
        }
        if ($type == 'I') {
            //自動設定処理
            if (is_array($this->_auto_insert_columns)) {
                foreach ($this->_auto_insert_columns as $key => $val) {
                    if (isset($field_list[$key])) {
                        $column_labels[] = $key;
                        eval("\$column_values[$key] = \"'\" .$val. \"'\";");
                    }
                }
            }
            return "INSERT INTO " . $this->_table_name . " ( \n" . @implode(",\n", $column_labels) . " ) \nVALUES ( \n" . @implode(",\n", $column_values) . " )";
        }
        else if ($type == 'U') {
            //create [ column = value ]
            $columns_decorate = array ();
            foreach ($column_values as $key => $value) {
                $columns_decorate[] = $key . ' = ' . $value;
            }
            //create [ column = value ]
            $wheres_decorate = array ();
            foreach ($column_pkeys as $key => $value) {
                $wheres_decorate[] = $key . ' = ' . $value;
            }
            return "UPDATE " . $this->_table_name . " SET \n" . @implode(",\n", $columns_decorate) . " \nWHERE " . @implode(" \nAND ", $wheres_decorate);
        }
        else if ($type == 'D') {
            //create [ column = value ]
            $wheres_decorate = array ();
            foreach ($column_pkeys as $key => $value) {
                $wheres_decorate[] = $key . ' = ' . $value;
            }
            return 'DELETE FROM ' . $this->_table_name . " \nWHERE " . @implode(" \nAND ", $wheres_decorate);
        }
    }
}
?>
