<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author S.Tajima<tajima@exbridge.jp> 2007/10/22 DBアクセス関連を分離
 * @version svn:$Id: somfaDatabase.php 8755 2008-10-03 05:49:26Z hatanaka $
 * @copyright 2007-2008 Exbridge,inc.
 */
class somfaDatabase
{
    /**
     * SOMFA Config 
     * @var array
     * @access private
     */
    var $_my_conf = '';

    /**
     * connector_mode
     * @var array
     * @access private
     */
    var $_connector_mode = '';

    /**
     * database dsn
     * @var string
     * @access private
     */
    var $_dsn = null;

    /**
     * database type
     * @var string
     * @access private
     */
    var $_type = '';

    /**
     * database encoding
     * @var string
     * @access private
     */
    var $_encoding = null;

    /**
     * recordset cacche time
     * @var string
     * @access private
     */
    var $_cache_time = 0;

    /**
     * recordset cacche dir
     * @var string
     * @access private
     */
    var $_cache_dir = 0;

    /**
     * Construct
     * @param string
     * @return void
     */
    function somfaDatabase($config = '', $connector_mode = '0')
    {
        $this->_my_conf = $config;
        $this->_connector_mode = $connector_mode;
    }

    /**
     * ADODB Connection Rapper
     * @param string
     * @access public
     */
    function & connect($ident = 'default')
    {
        foreach ($this->_my_conf as $key=>$conf) {
            if ($this->_connector_mode == '0') {
                if ($key==$ident) {
                    $con = $this->_connect($conf, true);
                    break;
                }
            }
            else {
                $con = $this->_connect($conf, false);
                if ($con) {
                    break;
                }
            }
        }
        return $con;
    }

    function & _connect($conf, $errflg) {
        $this->_dsn        = $conf['dsn'];
        $this->_type       = $conf['type'];
        $this->_encoding   = $conf['encoding'];
        $this->_cache_dir  = $conf['cache_data_dir'];
        $this->_cache_time = $conf['cache_data_time'];

        //connect
        $con = & NewADOConnection($this->_dsn);
        if (!$con) {
            if ($errflg) {
                trigger_error("Database connect failure.", E_USER_ERROR);
            }
            return false;
        }
        //init
        $con->cacheSecs = $this->_cache_time;
        $con->SetFetchMode(ADODB_FETCH_ASSOC);

        if ($this->_type == 'mysqli') {
             if (!is_null($this->_encoding)) {
                $con->SetCharSet($this->_encoding);
            }
        }
        else if ($this->_type == 'pgsql') {
            if (!is_null($this->_encoding)) {
                $con->SetCharSet($this->_encoding);
            }
        }
        return $con;
    }

    /**
     * public
     * begin transaction
     * @param adodb Object
     * @access public
     */
    function begin(& $con)
    {
        if (!is_null($con) && $con->IsConnected()) {
            somfaLogger('Begin Transaction .........', __CLASS__, __FILE__, __LINE__);
            $con->StartTrans();
            return true;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * commit transaction
     * @param adodb Object
     * @access public
     */
    function commit(& $con)
    {
        if (!is_null($con) && $con->IsConnected()) {
            somfaLogger('Commit Transaction .........', __CLASS__, __FILE__, __LINE__);
            $con->CompleteTrans();
            return true;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * rollback transaction
     * @param adodb Object
     * @access public
     */
    function rollback(& $con)
    {
        if (!is_null($con) && $con->IsConnected()) {
            somfaLogger('Rollback Transaction .........', __CLASS__, __FILE__, __LINE__);
            $con->FailTrans();
            $con->CompleteTrans();
            return true;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * close database
     * @param adodb Object
     * @access public
     */
    function close(& $con)
    {
        if (!is_null($con) && $con->IsConnected()) {
            $con->Close();
            $con = null;
            return true;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * execute
     * @param adodb Object
     * @param string
     * @param array
     * @access public
     */
    function execute(& $con, $sql, $bind = false, $output = true)
    {
        if (!is_null($con) && $con->IsConnected()) {
            $this->putLog($sql, '-1', '-1', $bind, $output);
            $rs = $con->Execute($sql, $bind);
            if ($rs === false) {
                if (strstr(strtolower($sql), 'drop table')) {
                    return false;
                }
                if (strstr(strtolower($sql), 'create table')) {
                    return false;
                }
                if (strstr(strtolower($sql), 'create view')) {
                    return false;
                }
                if (strstr(strtolower($sql), 'create function')) {
                    return false;
                }
                $this->rollback($con);
                if (method_exists($con, 'ErrorMsg')) {
                    if ($con->ErrorMsg()) {
                        trigger_error('execute failure'. $con->ErrorMsg(), E_USER_ERROR);
                        return false;
                    }
                }
                trigger_error('execute failure', E_USER_ERROR);
                return false;
            }
            if (method_exists($con, 'ErrorMsg')) {
                if ($con->ErrorMsg()) {
                    trigger_error($con->ErrorMsg(), E_USER_ERROR);
                    return false;
                }
            }
            //somfaLogger("\n\n" . var_export($rs, true), __CLASS__, __FILE__, __LINE__);
            return $rs;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * cache execute
     * @param adodb Object
     * @param string
     * @param array
     * @access public
     */
    function cache_execute(& $con, $sql, $bind = false, $output = true)
    {
        if (!is_null($con) && $con->IsConnected()) {
            $this->putLog($sql, '-1', '-1', $bind, $output);
            $rs = $con->CacheExecute($sql, $bind);
            if ($rs === false) {
                $this->rollback($con);
                trigger_error('cache_execute failure', E_USER_ERROR);
                return false;
            }
            return $rs;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * selectLimit
     * @param adodb Object
     * @param string
     * @param integer
     * @param integer
     * @param array
     * @access public
     */
    function selectLimit(& $con, $sql, $limit = -1, $offset = -1, $bind = false, $output = true)
    {
        if (!is_null($con) && $con->IsConnected()) {
            $this->putLog( $sql, $limit, $offset, $bind, $output );
            $rs = $con->SelectLimit( $sql, $limit, $offset, $bind );
            return $rs;
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * cache selectLimit
     * @param adodb Object
     * @param string
     * @param integer
     * @param integer
     * @param array
     * @access public
     */
    function cache_selectLimit(& $con, $sql, $limit = -1, $offset = -1, $bind = false, $output = true)
    {
        if (!is_null($con) && $con->IsConnected()) {
            $this->putLog($sql, $limit, $offset, $bind, $output = true);
            global $ADODB_CACHE_DIR;
            $ADODB_CACHE_DIR = $this->_cache_dir;
            return $con->CacheSelectLimit($sql, $limit, $offset, $bind );
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * insert blob
     * @param adodb Object
     * @param string
     * @param string
     * @param string
     * @param string
     * @access public
     */
    function blob(& $con, $table, $column, $path, $where)
    {
        if (!is_null($con) && $con->IsConnected()) {
            //return $con->UpdateBlobFile($table, $column, $path, $where);
            $fp = @fopen($path, 'r');
            $contents = @fread($fp, filesize($path));
            @fclose($fp);

            $sql = "update ". $table ." set ";
            $sql.= $column ." = '". base64_encode($contents) ."' ";
            $sql.= 'where ' . $where;
            $this->putLog( $sql, '', '', false);
            return $con->Execute($sql);
        }
        trigger_error("connection not found.", E_USER_ERROR);
        return false;
    }

    /**
     * public
     * get blob
     * @param string
     * @access public
     */
    function getBlob($field)
    {
        return base64_decode($field);
    }

    /**
     * private
     * sql log output
     * @param string
     * @param array
     * @access private
     */
    function putLog($sql, $limit, $offset, $bind, $output=true)
    {
        if ($output) {
            if ($bind === false) {
                somfaLogger("\n\n" . $sql . "\n[offset:$offset][limit:$limit]\n", __CLASS__, __FILE__, __LINE__);
            }
            else {
                somfaLogger("\n\n" . $sql . "\n[offset:$offset][limit:$limit]\n" . var_export( $bind, true ) . "\n", __CLASS__, __FILE__, __LINE__);
            }
        }
    }
}
