<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwSession.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwSession.php 8734 2008-10-03 00:15:23Z shimizu $
 * @copyright 2007-2008 Exbridge,Inc.
 */
$ADODB_SESSION_DRIVER = '';
$ADODB_SESSION_CONNECT = '';
$ADODB_SESSION_USER = '';
$ADODB_SESSION_PWD = '';
$ADODB_SESSION_DB = '';
$ADODB_SESSION_EXPIRE_NOTIFY = array();
$PW_USER_SESSION_EXPIRE_NOTIFY = '';
class xbpwSession
{
    /** session management infomation */
    var $_session_conf = '';

    /**
     * Create new instance
     * @public
     */
    function xbpwSession($sessionConfig='')
    {
        $this->_session_conf = $sessionConfig;
    }

    /**
     * Session start function
     * @public
     */
    function start()
    {
        if (strtolower(PW_SESSION) == 'php') {
            if (session_name() != PW_SESSION_NAME) {
                session_name(PW_SESSION_NAME);
            }
        }
        else {
            global $ADODB_SESSION_DRIVER;
            global $ADODB_SESSION_CONNECT;
            global $ADODB_SESSION_USER;
            global $ADODB_SESSION_PWD;
            global $ADODB_SESSION_DB;
            global $ADODB_SESSION_EXPIRE_NOTIFY;
            global $PW_USER_SESSION_EXPIRE_NOTIFY;
            $ADODB_SESSION_DRIVER  = $this->_session_conf['type'];//pgsql or mysql or oracle
            $ADODB_SESSION_CONNECT = $this->_session_conf['host'];
            $ADODB_SESSION_USER    = $this->_session_conf['user'];
            $ADODB_SESSION_PWD     = $this->_session_conf['password'];
            $ADODB_SESSION_DB      = $this->_session_conf['database'];
            $PW_USER_SESSION_EXPIRE_NOTIFY = $this->_session_conf['gc_function'];
            $ADODB_SESSION_EXPIRE_NOTIFY = array('', 'NotifyFn');
            include(PW_VENDORS_DIR . DS . 'adodb' . DS . 'session' . DS . 'adodb-session.php');
            if (session_name() != PW_SESSION_NAME) {
                session_name(PW_SESSION_NAME);
                adodb_sess_open(false, $name, 'P');
            }
        }
        session_start();
    }
}

/**
 * ガベージコレクション用関数
 */
function NotifyFn($expireref, $sesskey)
{
    foreach (glob(PW_TMP_DIR . DS . 'session' . DS . $sesskey . '.*.flash.cache') as $file) {
        unlink($file);
    }
    global $PW_USER_SESSION_EXPIRE_NOTIFY;
    if ($PW_USER_SESSION_EXPIRE_NOTIFY!='') {
        if (function_exists($PW_USER_SESSION_EXPIRE_NOTIF)) {
           call_user_func($PW_USER_SESSION_EXPIRE_NOTIFY);
        }
    }
}
