<?php
/*
 * This file is part of HELIOS.PetitMail
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * メール配信webサービスヴァリデータークラス
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS.PetitMail
 * @version   svn:$Id: webValidator.php 8522 2008-09-27 08:14:42Z shimizu $
 */
class webValidator extends xbpwValidator
{
    /**
     * 用語追加画面の入力チェック
     *
     * @param  $values 入力チェック対象項目配列
     * @access public
     */
    function validateRequestSend($values)
    {
        //必須チェック
        if (isNULL(str_replace(array(" ", "　"), array("", ""), $values['from_mail']))) {
            $this->addError('from_mail_null', CL_FROMMAIL . 'は必須入力です');
        }

        $to_mail_str = is_array($values['to_mail_list'])?implode(',', $values['to_mail_list']):$values['to_mail_list'];
        if (isNULL(str_replace(array(" ", "　"), array("", ""), $to_mail_str))) {
            $this->addError('to_mail_null', CL_TOMAIL . 'は必須入力です');
        }
        if (isNULL(str_replace(array(" ", "　"), array("", ""), $values['subject']))) {
            $this->addError('subject_null', CL_SUBJECT . 'は必須入力です');
        }
        if (isNULL(str_replace(array(" ", "　"), array("", ""), $values['body']))) {
            $this->addError('body_null', CL_BODY . 'は必須入力です');
        }

        //メール情報チェック
/*
        if (!$this->chkMailInfo($values['from_mail_info'])) {
            $this->addError('from_mail_mail', CL_FROMMAIL . 'のメールアドレスが不正です[' . $values['from_mail_info']['mail'] . ']');
        }
*/
        $i = 0;
        foreach($values['to_mail_info_list'] as $to_mail_info) {
            $i++;
            if (!$this->chkMailInfo($to_mail_info)) {
                $this->addError('to_mail_mail_' . $i, CL_TOMAIL . 'のメールアドレスが不正です[' . $values['to_mail_info']['mail'] . ']');
            }
        }

        $i = 0;
        foreach($values['cc_mail_info_list'] as $cc_mail_info) {
            $i++;
            if (!$this->chkMailInfo($cc_mail_info)) {
                $this->addError('cc_mail_mail_' . $i, 'Ccのメールアドレスが不正です[' . $values['cc_mail_info']['mail'] . ']');
            }
        }
        $i = 0;
        foreach($values['bcc_mail_info_list'] as $bcc_mail_info) {
            $i++;
            if (!$this->chkMailInfo($bcc_mail_info)) {
                $this->addError('bcc_mail_mail_' . $i, 'Bccのメールアドレスが不正です[' . $values['bcc_mail_info']['mail'] . ']');
            }
        }
    }

    /**
     * メール情報チェック
     *
     * @param  $mail_info チェック対象値
     * @access public
     */
    function chkMailInfo($mail_info) {
        if(is_array($mail_info)) {
            $mail = $mail_info['mail'];
        }
        else {
            $mail = $mail_info;
        }
        return $this->chkMail($mail);
    }

    /**
     * メールチェック
     *
     * @param  $value チェック対象値
     * @access public
     */
    function chkMail($value) {
        return (isNULL($value) || preg_match('/^\w+([-+.]\w+)*@\w+([-.]\\w+)*\.\w+([-.]\w+)*$/', $value));
    }
}
